/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import wayoftime.bloodmagic.common.meteor.MeteorLayer;
import wayoftime.bloodmagic.recipe.RecipeMeteor;

public class MeteorRecipeSerializer<RECIPE extends RecipeMeteor>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public MeteorRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray input = JSONUtils.func_151202_d((JsonObject)json, (String)"input") ? JSONUtils.func_151214_t((JsonObject)json, (String)"input") : JSONUtils.func_152754_s((JsonObject)json, (String)"input");
        Ingredient inputIng = Ingredient.func_199802_a((JsonElement)input);
        int syphon = JSONUtils.func_151203_m((JsonObject)json, (String)"syphon");
        float explosionRadius = JSONUtils.func_151203_m((JsonObject)json, (String)"explosion");
        ArrayList<MeteorLayer> layerList = new ArrayList<MeteorLayer>();
        if (json.has("layers") && JSONUtils.func_151202_d((JsonObject)json, (String)"layers")) {
            JsonArray mainArray = JSONUtils.func_151214_t((JsonObject)json, (String)"layers");
            for (JsonElement element : mainArray) {
                JsonObject obj = element.getAsJsonObject();
                MeteorLayer layer = MeteorLayer.deserialize(obj);
                layerList.add(layer);
            }
        }
        return this.factory.create(recipeId, inputIng, syphon, explosionRadius, layerList);
    }

    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
        int syphon = buffer.readInt();
        float explosionRadius = buffer.readFloat();
        int listSize = buffer.readInt();
        ArrayList<MeteorLayer> layerList = new ArrayList<MeteorLayer>();
        for (int i = 0; i < listSize; ++i) {
            MeteorLayer layer = MeteorLayer.read(buffer);
            layerList.add(layer);
        }
        return this.factory.create(recipeId, input, syphon, explosionRadius, layerList);
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        ((RecipeMeteor)recipe).write(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends RecipeMeteor> {
        public RECIPE create(ResourceLocation var1, Ingredient var2, int var3, float var4, List<MeteorLayer> var5);
    }
}

