/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.entity.projectile;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EntityPotionFlask
extends ProjectileItemEntity
implements IRendersAsItem {
    public boolean isLingering = false;
    public static final Predicate<LivingEntity> WATER_SENSITIVE = LivingEntity::func_230270_dK_;

    public EntityPotionFlask(EntityType<? extends EntityPotionFlask> typeIn, World worldIn) {
        super(typeIn, worldIn);
    }

    public EntityPotionFlask(World worldIn, LivingEntity livingEntityIn) {
        super(EntityType.field_200754_at, livingEntityIn, worldIn);
    }

    public EntityPotionFlask(World worldIn, double x, double y, double z) {
        super(EntityType.field_200754_at, x, y, z, worldIn);
    }

    protected Item func_213885_i() {
        return Items.field_185155_bH;
    }

    public void setIsLingering(boolean isLingering) {
        this.isLingering = isLingering;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    protected void func_230299_a_(BlockRayTraceResult p_230299_1_) {
        super.func_230299_a_(p_230299_1_);
        if (!this.field_70170_p.field_72995_K) {
            ItemStack itemstack = this.func_184543_l();
            Potion potion = PotionUtils.func_185191_c((ItemStack)itemstack);
            List list = PotionUtils.func_185189_a((ItemStack)itemstack);
            boolean flag = potion == Potions.field_185230_b && list.isEmpty();
            Direction direction = p_230299_1_.func_216354_b();
            BlockPos blockpos = p_230299_1_.func_216350_a();
            BlockPos blockpos1 = blockpos.func_177972_a(direction);
            if (flag) {
                this.extinguishFires(blockpos1, direction);
                this.extinguishFires(blockpos1.func_177972_a(direction.func_176734_d()), direction);
                for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                    this.extinguishFires(blockpos1.func_177972_a(direction1), direction1);
                }
            }
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        if (!this.field_70170_p.field_72995_K) {
            boolean flag;
            ItemStack itemstack = this.func_184543_l();
            Potion potion = PotionUtils.func_185191_c((ItemStack)itemstack);
            List list = PotionUtils.func_185189_a((ItemStack)itemstack);
            boolean bl = flag = potion == Potions.field_185230_b && list.isEmpty();
            if (flag) {
                this.applyWater();
            } else if (!list.isEmpty()) {
                if (this.isLingering()) {
                    this.makeAreaOfEffectCloud(itemstack, potion);
                } else {
                    this.func_213888_a(list, result.func_216346_c() == RayTraceResult.Type.ENTITY ? ((EntityRayTraceResult)result).func_216348_a() : null);
                }
            }
            int i = potion.func_185172_c() ? 2007 : 2002;
            this.field_70170_p.func_217379_c(i, this.func_233580_cy_(), PotionUtils.func_190932_c((ItemStack)itemstack));
            this.func_70106_y();
        }
    }

    private void applyWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List list = this.field_70170_p.func_175647_a(LivingEntity.class, axisalignedbb, WATER_SENSITIVE);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                double d0 = this.func_70068_e((Entity)livingentity);
                if (!(d0 < 16.0) || !livingentity.func_230270_dK_()) continue;
                livingentity.func_70097_a(DamageSource.func_76354_b((Entity)livingentity, (Entity)this.func_234616_v_()), 1.0f);
            }
        }
    }

    private void func_213888_a(List<EffectInstance> p_213888_1_, @Nullable Entity p_213888_2_) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, axisalignedbb);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                double d0;
                if (!livingentity.func_184603_cC() || !((d0 = this.func_70068_e((Entity)livingentity)) < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                if (livingentity == p_213888_2_) {
                    d1 = 1.0;
                }
                for (EffectInstance effectinstance : p_213888_1_) {
                    Effect effect = effectinstance.func_188419_a();
                    if (effect.func_76403_b()) {
                        effect.func_180793_a((Entity)this, this.func_234616_v_(), livingentity, effectinstance.func_76458_c(), d1);
                        continue;
                    }
                    int i = (int)(d1 * (double)effectinstance.func_76459_b() + 0.5);
                    if (i <= 20) continue;
                    livingentity.func_195064_c(new EffectInstance(effect, i, effectinstance.func_76458_c(), effectinstance.func_82720_e(), effectinstance.func_188418_e()));
                }
            }
        }
    }

    public void makeAreaOfEffectCloud(ItemStack p_190542_1_, Potion p_190542_2_) {
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        Entity entity = this.func_234616_v_();
        if (entity instanceof LivingEntity) {
            areaeffectcloudentity.func_184481_a((LivingEntity)entity);
        }
        areaeffectcloudentity.func_184483_a(3.0f);
        areaeffectcloudentity.func_184495_b(-0.5f);
        areaeffectcloudentity.func_184485_d(10);
        areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
        areaeffectcloudentity.func_184484_a(p_190542_2_);
        for (EffectInstance effectinstance : PotionUtils.func_185190_b((ItemStack)p_190542_1_)) {
            areaeffectcloudentity.func_184496_a(new EffectInstance(effectinstance));
        }
        CompoundNBT compoundnbt = p_190542_1_.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("CustomPotionColor", 99)) {
            areaeffectcloudentity.func_184482_a(compoundnbt.func_74762_e("CustomPotionColor"));
        }
        this.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    public boolean isLingering() {
        return this.isLingering;
    }

    public void extinguishFires(BlockPos pos, Direction p_184542_2_) {
        BlockState blockstate = this.field_70170_p.func_180495_p(pos);
        if (blockstate.func_235714_a_((ITag)BlockTags.field_232872_am_)) {
            this.field_70170_p.func_217377_a(pos, false);
        } else if (CampfireBlock.func_226915_i_((BlockState)blockstate)) {
            this.field_70170_p.func_217378_a((PlayerEntity)null, 1009, pos, 0);
            CampfireBlock.func_235475_c_((IWorld)this.field_70170_p, (BlockPos)pos, (BlockState)blockstate);
            this.field_70170_p.func_175656_a(pos, (BlockState)blockstate.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false)));
        }
    }
}

