/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.potion;

import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import wayoftime.bloodmagic.potion.PotionBloodMagic;
import wayoftime.bloodmagic.potion.PotionFireFuse;
import wayoftime.bloodmagic.potion.PotionHeavyHeart;
import wayoftime.bloodmagic.potion.PotionPassivity;
import wayoftime.bloodmagic.potion.PotionPlantLeech;
import wayoftime.bloodmagic.potion.PotionSacrificialLamb;
import wayoftime.bloodmagic.potion.PotionSoftFall;
import wayoftime.bloodmagic.potion.PotionSoulSnare;
import wayoftime.bloodmagic.potion.PotionSuspended;

public class BloodMagicPotions {
    public static final Effect SOUL_SNARE = new PotionSoulSnare();
    public static final Effect FIRE_FUSE = new PotionFireFuse();
    public static final Effect SOUL_FRAY = new PotionBloodMagic(EffectType.HARMFUL, -1);
    public static final Effect PLANT_LEECH = new PotionPlantLeech();
    public static final Effect SACRIFICIAL_LAMB = new PotionSacrificialLamb();
    public static final Effect FLIGHT = new PotionBloodMagic(EffectType.BENEFICIAL, 2350561);
    public static final Effect SPECTRAL_SIGHT = new PotionBloodMagic(EffectType.BENEFICIAL, 3127315);
    public static final Effect GRAVITY = new PotionBloodMagic(EffectType.HARMFUL, 0x800080);
    public static final Effect HEAVY_HEART = new PotionHeavyHeart();
    public static final Effect GROUNDED = new PotionBloodMagic(EffectType.HARMFUL, 12223835);
    public static final Effect SUSPENDED = new PotionSuspended();
    public static final Effect PASSIVITY = new PotionPassivity();
    public static final Effect BOUNCE = new PotionBloodMagic(EffectType.BENEFICIAL, 5766958);
    public static final Effect OBSIDIAN_CLOAK = new PotionBloodMagic(EffectType.BENEFICIAL, 3938957);
    public static final Effect HARD_CLOAK = new PotionBloodMagic(EffectType.BENEFICIAL, 3938957);
    public static final Effect SOFT_FALL = new PotionSoftFall();

    public static void registerPotions(RegistryEvent.Register<Effect> evt) {
        IForgeRegistry reg = evt.getRegistry();
        reg.register((IForgeRegistryEntry)((Effect)SOUL_SNARE.setRegistryName("soulsnare")));
        reg.register((IForgeRegistryEntry)((Effect)FIRE_FUSE.setRegistryName("firefuse")));
        reg.register((IForgeRegistryEntry)((Effect)SOUL_FRAY.setRegistryName("soulfray")));
        reg.register((IForgeRegistryEntry)((Effect)PLANT_LEECH.setRegistryName("plantleech")));
        reg.register((IForgeRegistryEntry)((Effect)SACRIFICIAL_LAMB.setRegistryName("sacrificiallamb")));
        reg.register((IForgeRegistryEntry)((Effect)FLIGHT.setRegistryName("flight")));
        reg.register((IForgeRegistryEntry)((Effect)SPECTRAL_SIGHT.setRegistryName("spectral_sight")));
        reg.register((IForgeRegistryEntry)((Effect)GRAVITY.func_220304_a((Attribute)ForgeMod.ENTITY_GRAVITY.get(), "AF8B6E3F-3328-4C0A-AA66-6BA6BB6DBEF6", 0.5, AttributeModifier.Operation.MULTIPLY_BASE).setRegistryName("gravity")));
        reg.register((IForgeRegistryEntry)((Effect)HEAVY_HEART.setRegistryName("heavy_heart")));
        reg.register((IForgeRegistryEntry)((Effect)GROUNDED.setRegistryName("grounded")));
        reg.register((IForgeRegistryEntry)((Effect)SUSPENDED.setRegistryName("suspended")));
        reg.register((IForgeRegistryEntry)((Effect)PASSIVITY.setRegistryName("passivity")));
        reg.register((IForgeRegistryEntry)((Effect)BOUNCE.setRegistryName("bounce")));
        reg.register((IForgeRegistryEntry)((Effect)OBSIDIAN_CLOAK.setRegistryName("obsidian_cloak")));
        reg.register((IForgeRegistryEntry)((Effect)HARD_CLOAK.func_220304_a(Attributes.field_233827_j_, "BF8B6E3F-3328-4C0A-AA66-3BA6BB6DBEF6", 3.0, AttributeModifier.Operation.ADDITION).setRegistryName("hard_cloak")));
        reg.register((IForgeRegistryEntry)((Effect)SOFT_FALL.setRegistryName("soft_fall")));
    }

    public static Effect getEffect(ResourceLocation rl) {
        return (Effect)ForgeRegistries.POTIONS.getValue(rl);
    }

    public static ResourceLocation getRegistryName(Effect effect) {
        return ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)effect);
    }
}

