/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.ritual.harvest.HarvestRegistry;
import wayoftime.bloodmagic.ritual.harvest.IHarvestHandler;

@RitualRegister(value="harvest")
public class RitualHarvest
extends Ritual {
    public static final String HARVEST_RANGE = "harvestRange";

    public RitualHarvest() {
        super("ritualHarvest", 0, 20000, "ritual.bloodmagic.harvestRitual");
        this.addBlockRange(HARVEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-4, 1, -4), 9, 5, 9));
        this.setMaximumVolumeAndDistanceOfRange(HARVEST_RANGE, 0, 15, 15);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        if (masterRitualStone.getOwnerNetwork().getCurrentEssence() < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        int harvested = 0;
        AreaDescriptor harvestArea = masterRitualStone.getBlockRange(HARVEST_RANGE);
        harvestArea.resetIterator();
        while (harvestArea.hasNext()) {
            BlockPos nextPos = ((BlockPos)harvestArea.next()).func_177971_a((Vector3i)pos);
            if (!RitualHarvest.harvestBlock(world, nextPos, masterRitualStone.getMasterBlockPos())) continue;
            ++harvested;
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * harvested));
    }

    @Override
    public int getRefreshCost() {
        return 20;
    }

    @Override
    public int getRefreshTime() {
        return 5;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addParallelRunes(components, 2, 0, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 3, 1, 0, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 3, 2, 0, EnumRuneType.WATER);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualHarvest();
    }

    public static boolean harvestBlock(World world, BlockPos cropPos, BlockPos controllerPos) {
        BlockState harvestState = world.func_180495_p(cropPos);
        TileEntity potentialInventory = world.func_175625_s(controllerPos.func_177984_a());
        IItemHandler itemHandler = null;
        if (potentialInventory != null && potentialInventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).isPresent()) {
            itemHandler = (IItemHandler)potentialInventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).resolve().get();
        }
        for (IHarvestHandler handler : HarvestRegistry.getHarvestHandlers()) {
            ArrayList drops;
            if (!handler.test(world, cropPos, harvestState) || !handler.harvest(world, cropPos, harvestState, drops = Lists.newArrayList())) continue;
            for (ItemStack stack : drops) {
                if (stack.func_190926_b()) continue;
                if (itemHandler != null) {
                    // empty if block
                }
                InventoryHelper.func_180173_a((World)world, (double)cropPos.func_177958_n(), (double)cropPos.func_177956_o(), (double)cropPos.func_177952_p(), (ItemStack)stack);
            }
            return true;
        }
        return false;
    }
}

