/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import com.mojang.authlib.GameProfile;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="magnetism")
public class RitualMagnetic
extends Ritual {
    public static final String PLACEMENT_RANGE = "placementRange";
    public BlockPos lastPos;
    private FakePlayer fakePlayer;

    public RitualMagnetic() {
        super("ritualMagnetic", 0, 5000, "ritual.bloodmagic.magneticRitual");
        this.addBlockRange(PLACEMENT_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, 1, -1), 3));
        this.setMaximumVolumeAndDistanceOfRange(PLACEMENT_RANGE, 50, 4, 4);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        Vector3d MRSpos = new Vector3d((double)masterRitualStone.getMasterBlockPos().func_177958_n(), (double)masterRitualStone.getMasterBlockPos().func_177956_o(), (double)masterRitualStone.getMasterBlockPos().func_177952_p());
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        AreaDescriptor placementRange = masterRitualStone.getBlockRange(PLACEMENT_RANGE);
        BlockPos replacement = pos;
        boolean replace = false;
        for (BlockPos offset : placementRange.getContainedPositions(pos)) {
            if (!world.func_175623_d(offset)) continue;
            replacement = offset;
            replace = true;
            break;
        }
        BlockState downState = world.func_180495_p(pos.func_177977_b());
        int radius = this.getRadius(downState.func_177230_c());
        int maxBlockChecks = 100;
        int checks = 0;
        if (replace) {
            int j = -1;
            int i = -radius;
            int k = -radius;
            if (this.lastPos != null && !this.lastPos.equals((Object)BlockPos.field_177992_a)) {
                j = this.lastPos.func_177956_o();
                i = Math.min(radius, Math.max(-radius, this.lastPos.func_177958_n()));
                k = Math.min(radius, Math.max(-radius, this.lastPos.func_177952_p()));
            }
            while (j + pos.func_177956_o() >= 0) {
                while (i <= radius) {
                    while (k <= radius) {
                        if (checks >= maxBlockChecks) {
                            this.lastPos = new BlockPos(i, j, k);
                            return;
                        }
                        ++checks;
                        BlockPos newPos = pos.func_177982_a(i, j, k);
                        Vector3d newPosVector = new Vector3d((double)newPos.func_177958_n(), (double)newPos.func_177956_o(), (double)newPos.func_177952_p());
                        BlockState state = world.func_180495_p(newPos);
                        ItemStack checkStack = new ItemStack((IItemProvider)state.func_177230_c());
                        if (RitualMagnetic.isBlockOre(checkStack)) {
                            Utils.swapLocations(world, newPos, world, replacement);
                            masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                            this.lastPos = new BlockPos(i, j, ++k);
                            return;
                        }
                        ++k;
                    }
                    ++i;
                    k = -radius;
                }
                --j;
                i = -radius;
            }
            j = -1;
            this.lastPos = new BlockPos(i, j, k);
        }
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.lastPos = new BlockPos(tag.func_74762_e("xCoord"), tag.func_74762_e("yCoord"), tag.func_74762_e("zCoord"));
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        if (this.lastPos != null) {
            tag.func_74768_a("xCoord", this.lastPos.func_177958_n());
            tag.func_74768_a("yCoord", this.lastPos.func_177956_o());
            tag.func_74768_a("zCoord", this.lastPos.func_177952_p());
        }
    }

    public int getRadius(Block block) {
        if (block == Blocks.field_150339_S) {
            return 7;
        }
        if (block == Blocks.field_150340_R) {
            return 15;
        }
        if (block == Blocks.field_150484_ah) {
            return 31;
        }
        return 3;
    }

    @Override
    public int getRefreshTime() {
        return 40;
    }

    @Override
    public int getRefreshCost() {
        return 50;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 2, 1, EnumRuneType.EARTH);
        this.addCornerRunes(components, 2, 1, EnumRuneType.AIR);
        this.addParallelRunes(components, 2, 2, EnumRuneType.FIRE);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualMagnetic();
    }

    private FakePlayer getFakePlayer(ServerWorld world) {
        return this.fakePlayer == null ? (this.fakePlayer = FakePlayerFactory.get((ServerWorld)world, (GameProfile)new GameProfile(null, "bloodmagic_ritual_magnetic"))) : this.fakePlayer;
    }

    public static boolean isBlockOre(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().func_206844_a((ITag)Tags.Items.ORES);
    }
}

