/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.structures;

import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.gson.Serializers;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.structures.DungeonDoor;
import wayoftime.bloodmagic.structures.DungeonRoom;
import wayoftime.bloodmagic.structures.DungeonRoomRegistry;
import wayoftime.bloodmagic.structures.StoneToOreProcessor;
import wayoftime.bloodmagic.tile.TileDungeonController;
import wayoftime.bloodmagic.tile.TileDungeonSeal;

public class DungeonSynthesizer {
    public static boolean displayDetailedInformation = false;
    public Map<String, Map<Direction, List<BlockPos>>> availableDoorMasterMap = new HashMap<String, Map<Direction, List<BlockPos>>>();
    public List<AreaDescriptor> descriptorList = new ArrayList<AreaDescriptor>();
    private int activatedDoors = 0;
    private ResourceLocation specialRoomPool = BloodMagic.rl("room_pools/tier2/mine_entrances");
    private List<ResourceLocation> specialRoomBuffer = new ArrayList<ResourceLocation>();

    public void writeToNBT(CompoundNBT tag) {
        String json = Serializers.GSON.toJson(this.availableDoorMasterMap);
        tag.func_74778_a("dungeon_door_map", json);
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < this.descriptorList.size(); ++i) {
            AreaDescriptor desc = this.descriptorList.get(i);
            CompoundNBT compoundnbt = new CompoundNBT();
            desc.writeToNBT(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        if (!listnbt.isEmpty()) {
            tag.func_218657_a("area_descriptors", (INBT)listnbt);
        }
    }

    public void readFromNBT(CompoundNBT tag) {
        String testJson = tag.func_74779_i("dungeon_door_map");
        if (!testJson.isEmpty()) {
            this.availableDoorMasterMap = (Map)Serializers.GSON.fromJson(testJson, new TypeToken<Map<String, Map<Direction, List<BlockPos>>>>(){}.getType());
        }
        ListNBT listnbt = tag.func_150295_c("area_descriptors", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            AreaDescriptor.Rectangle rec = new AreaDescriptor.Rectangle(BlockPos.field_177992_a, 0);
            rec.readFromNBT(compoundnbt);
            this.descriptorList.add(rec);
        }
    }

    public BlockPos[] generateInitialRoom(ResourceLocation initialType, Random rand, ServerWorld world, BlockPos spawningPosition) {
        PlacementSettings settings = new PlacementSettings();
        Mirror mir = Mirror.NONE;
        settings.func_186214_a(mir);
        Rotation rot = Rotation.NONE;
        settings.func_186220_a(rot);
        settings.func_186222_a(true);
        settings.func_186218_a(null);
        settings.func_215223_c(true);
        DungeonRoom initialRoom = DungeonRoomRegistry.getRandomDungeonRoom(initialType, rand);
        BlockPos roomPlacementPosition = initialRoom.getInitialSpawnOffsetForControllerPos(settings, spawningPosition);
        this.descriptorList.addAll(initialRoom.getAreaDescriptors(settings, roomPlacementPosition));
        for (Direction facing : Direction.values()) {
            Map<String, List<BlockPos>> doorTypeMap = initialRoom.getAllDoorOffsetsForFacing(settings, facing, roomPlacementPosition);
            for (Map.Entry<String, List<BlockPos>> entry : doorTypeMap.entrySet()) {
                Map<Direction, List<BlockPos>> doorDirectionMap;
                if (!this.availableDoorMasterMap.containsKey(entry.getKey())) {
                    this.availableDoorMasterMap.put(entry.getKey(), new HashMap());
                }
                if (!(doorDirectionMap = this.availableDoorMasterMap.get(entry.getKey())).containsKey(facing)) {
                    doorDirectionMap.put(facing, new ArrayList());
                }
                doorDirectionMap.get(facing).addAll((Collection<BlockPos>)entry.getValue());
            }
        }
        initialRoom.placeStructureAtPosition(rand, settings, world, roomPlacementPosition);
        this.addNewControllerBlock(world, spawningPosition);
        List<DungeonDoor> doorTypeMap = initialRoom.getPotentialConnectedRoomTypes(settings, roomPlacementPosition);
        for (DungeonDoor dungeonDoor : doorTypeMap) {
            this.addNewDoorBlock(world, spawningPosition, dungeonDoor.doorPos, dungeonDoor.doorDir, dungeonDoor.doorType, dungeonDoor.getRoomList(), dungeonDoor.getSpecialRoomList());
        }
        BlockPos playerPos = initialRoom.getPlayerSpawnLocationForPlacement(settings, roomPlacementPosition);
        BlockPos portalLocation = initialRoom.getPortalOffsetLocationForPlacement(settings, roomPlacementPosition);
        return new BlockPos[]{playerPos, portalLocation};
    }

    public void addNewControllerBlock(ServerWorld world, BlockPos controllerPos) {
        world.func_180501_a(controllerPos, ((Block)BloodMagicBlocks.DUNGEON_CONTROLLER.get()).func_176223_P(), 3);
        TileEntity tile = world.func_175625_s(controllerPos);
        if (tile instanceof TileDungeonController) {
            ((TileDungeonController)tile).setDungeonSynthesizer(this);
        }
    }

    public void addNewDoorBlock(ServerWorld world, BlockPos controllerPos, BlockPos doorBlockPos, Direction doorFacing, String doorType, List<ResourceLocation> potentialRoomTypes, List<ResourceLocation> specialRoomTypes) {
        BlockPos doorBlockOffsetPos = doorBlockPos.func_177972_a(doorFacing).func_177967_a(Direction.UP, 2);
        Direction rightDirection = doorFacing.func_176746_e();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                world.func_175656_a(doorBlockOffsetPos.func_177967_a(rightDirection, i).func_177967_a(Direction.UP, j), ((Block)BloodMagicBlocks.DUNGEON_BRICK_ASSORTED.get()).func_176223_P());
            }
        }
        ResourceLocation specialRoomType = this.getSpecialRoom(specialRoomTypes);
        if (specialRoomType != null) {
            DungeonRoom randomRoom = DungeonSynthesizer.getRandomRoom(specialRoomType, world.field_73012_v);
            if (randomRoom != null) {
                if (this.checkRequiredRoom(world, controllerPos, specialRoomType, doorBlockOffsetPos, randomRoom, world.field_73012_v, doorBlockPos, doorFacing, doorType)) {
                    this.removeSpecialRoom(specialRoomType);
                    world.func_180501_a(doorBlockOffsetPos, Blocks.field_150451_bX.func_176223_P(), 3);
                    return;
                }
            } else if (displayDetailedInformation) {
                System.out.println("Uh oh.");
            }
        }
        potentialRoomTypes = this.modifyRoomTypes(potentialRoomTypes);
        world.func_180501_a(doorBlockOffsetPos, ((Block)BloodMagicBlocks.DUNGEON_SEAL.get()).func_176223_P(), 3);
        TileEntity tile = world.func_175625_s(doorBlockOffsetPos);
        if (tile instanceof TileDungeonSeal) {
            ((TileDungeonSeal)tile).acceptDoorInformation(controllerPos, doorBlockPos, doorFacing, doorType, potentialRoomTypes);
        }
    }

    public List<ResourceLocation> modifyRoomTypes(List<ResourceLocation> potentialRoomTypes) {
        ArrayList<ResourceLocation> modifiedRoomTypes = new ArrayList<ResourceLocation>(potentialRoomTypes);
        return modifiedRoomTypes;
    }

    public ResourceLocation getSpecialRoom(List<ResourceLocation> potentialSpecialRoomTypes) {
        if (potentialSpecialRoomTypes.isEmpty() || this.specialRoomBuffer.isEmpty()) {
            return null;
        }
        for (ResourceLocation resource : potentialSpecialRoomTypes) {
            if (!this.specialRoomBuffer.contains(resource)) continue;
            return resource;
        }
        return potentialSpecialRoomTypes.get(0);
    }

    public void removeSpecialRoom(ResourceLocation resource) {
        if (this.specialRoomBuffer.contains(resource)) {
            this.specialRoomBuffer.remove(resource);
        }
    }

    public boolean checkRequiredRoom(ServerWorld world, BlockPos controllerPos, ResourceLocation specialRoomType, BlockPos doorBlockOffsetPos, DungeonRoom room, Random rand, BlockPos activatedDoorPos, Direction doorFacing, String activatedDoorType) {
        PlacementSettings settings = new PlacementSettings();
        Mirror mir = Mirror.NONE;
        settings.func_186214_a(mir);
        Rotation rot = Rotation.NONE;
        settings.func_186220_a(rot);
        settings.func_186222_a(false);
        settings.func_186218_a(null);
        settings.func_215223_c(true);
        DungeonRoom placedRoom = null;
        Pair activatedDoor = Pair.of((Object)doorFacing, (Object)activatedDoorPos);
        Pair addedDoor = null;
        BlockPos roomLocation = null;
        Direction oppositeDoorFacing = doorFacing.func_176734_d();
        List rotationList = Rotation.func_222467_b((Random)rand);
        Rotation finalRotation = null;
        block0: for (Rotation initialRotation : rotationList) {
            settings.func_186220_a(initialRotation);
            List<BlockPos> otherDoorList = room.getDoorOffsetsForFacing(settings, activatedDoorType, oppositeDoorFacing, BlockPos.field_177992_a);
            if (otherDoorList == null || otherDoorList.isEmpty()) continue;
            int doorIndex = rand.nextInt(otherDoorList.size());
            BlockPos testDoor = otherDoorList.get(doorIndex);
            roomLocation = activatedDoorPos.func_177973_b((Vector3i)testDoor).func_177971_a(doorFacing.func_176730_m());
            List<AreaDescriptor> descriptors = room.getAreaDescriptors(settings, roomLocation);
            for (AreaDescriptor testDesc : descriptors) {
                for (AreaDescriptor currentDesc : this.descriptorList) {
                    if (!testDesc.intersects(currentDesc)) continue;
                    break block0;
                }
            }
            this.descriptorList.addAll(descriptors);
            addedDoor = Pair.of((Object)oppositeDoorFacing, (Object)testDoor.func_177971_a((Vector3i)roomLocation));
            placedRoom = room;
            finalRotation = initialRotation;
            break;
        }
        if (placedRoom == null) {
            return false;
        }
        this.spawnDoorBlock(world, controllerPos, specialRoomType, doorBlockOffsetPos, doorFacing, activatedDoorPos, activatedDoorType, room, finalRotation, roomLocation);
        return true;
    }

    public void spawnDoorBlock(ServerWorld world, BlockPos controllerPos, ResourceLocation specialRoomType, BlockPos doorBlockOffsetPos, Direction doorFacing, BlockPos activatedDoorPos, String activatedDoorType, DungeonRoom room, Rotation rotation, BlockPos roomLocation) {
        this.forcePlacementOfRoom(world, controllerPos, doorFacing, activatedDoorPos, activatedDoorType, room, rotation, roomLocation);
    }

    public int addNewRoomToExistingDungeon(ServerWorld world, BlockPos controllerPos, ResourceLocation roomType, Random rand, BlockPos activatedDoorPos, Direction doorFacing, String activatedDoorType, List<ResourceLocation> potentialRooms) {
        for (int i = 0; i < 10; ++i) {
            boolean testPlacement = this.attemptPlacementOfRandomRoom(world, controllerPos, roomType, rand, activatedDoorPos, doorFacing, activatedDoorType, potentialRooms, false);
            if (!testPlacement) continue;
            return 0;
        }
        ResourceLocation pathPool = new ResourceLocation("bloodmagic:room_pools/connective_corridors");
        if (this.attemptPlacementOfRandomRoom(world, controllerPos, pathPool, rand, activatedDoorPos, doorFacing, activatedDoorType, potentialRooms, true)) {
            return 1;
        }
        return 2;
    }

    public boolean forcePlacementOfRoom(ServerWorld world, BlockPos controllerPos, Direction doorFacing, BlockPos activatedDoorPos, String activatedDoorType, DungeonRoom room, Rotation rotation, BlockPos roomLocation) {
        if (displayDetailedInformation) {
            System.out.println("Forcing room! Room is: " + room);
        }
        if (room == null) {
            return false;
        }
        PlacementSettings settings = new PlacementSettings();
        Mirror mir = Mirror.NONE;
        settings.func_186214_a(mir);
        Rotation rot = Rotation.NONE;
        settings.func_186220_a(rot);
        settings.func_186222_a(false);
        settings.func_186218_a(null);
        settings.func_215223_c(true);
        settings.func_186220_a(rotation);
        DungeonRoom placedRoom = room;
        Pair activatedDoor = Pair.of((Object)doorFacing, (Object)activatedDoorPos);
        Pair addedDoor = null;
        Direction oppositeDoorFacing = doorFacing.func_176734_d();
        addedDoor = Pair.of((Object)oppositeDoorFacing, (Object)activatedDoorPos.func_177972_a(doorFacing));
        settings.func_215219_b();
        settings.func_215222_a((StructureProcessor)new StoneToOreProcessor(room.oreDensity));
        placedRoom.placeStructureAtPosition(world.field_73012_v, settings, world, roomLocation);
        for (String doorType : placedRoom.doorMap.keySet()) {
            Direction addedDoorFace;
            if (!this.availableDoorMasterMap.containsKey(doorType)) {
                this.availableDoorMasterMap.put(doorType, new HashMap());
            }
            Map<Direction, List<BlockPos>> availableDoorMap = this.availableDoorMasterMap.get(doorType);
            for (Direction facing : Direction.values()) {
                if (!availableDoorMap.containsKey(facing)) {
                    availableDoorMap.put(facing, new ArrayList());
                }
                List<BlockPos> doorList = availableDoorMap.get(facing);
                doorList.addAll(placedRoom.getDoorOffsetsForFacing(settings, doorType, facing, roomLocation));
            }
            if (!doorType.equals(activatedDoorType)) continue;
            Direction activatedDoorFace = (Direction)activatedDoor.getKey();
            if (availableDoorMap.containsKey(activatedDoorFace)) {
                availableDoorMap.get(activatedDoorFace).remove(activatedDoor.getRight());
            }
            if (!availableDoorMap.containsKey(addedDoorFace = (Direction)addedDoor.getKey())) continue;
            availableDoorMap.get(addedDoorFace).remove(addedDoor.getRight());
        }
        List<DungeonDoor> doorTypeMap = placedRoom.getPotentialConnectedRoomTypes(settings, roomLocation);
        for (DungeonDoor dungeonDoor : doorTypeMap) {
            if (((Direction)addedDoor.getKey()).equals((Object)dungeonDoor.doorDir) && ((BlockPos)addedDoor.getRight()).equals((Object)dungeonDoor.doorPos)) continue;
            if (displayDetailedInformation) {
                System.out.println("Room list: " + dungeonDoor.getRoomList());
            }
            this.addNewDoorBlock(world, controllerPos, dungeonDoor.doorPos, dungeonDoor.doorDir, dungeonDoor.doorType, dungeonDoor.getRoomList(), dungeonDoor.getSpecialRoomList());
        }
        return true;
    }

    public boolean attemptPlacementOfRandomRoom(ServerWorld world, BlockPos controllerPos, ResourceLocation roomType, Random rand, BlockPos activatedDoorPos, Direction doorFacing, String activatedDoorType, List<ResourceLocation> potentialRooms, boolean extendCorriDoors) {
        PlacementSettings settings = new PlacementSettings();
        Mirror mir = Mirror.NONE;
        settings.func_186214_a(mir);
        Rotation rot = Rotation.NONE;
        settings.func_186220_a(rot);
        settings.func_186222_a(false);
        settings.func_186218_a(null);
        settings.func_215223_c(true);
        DungeonRoom placedRoom = null;
        Pair activatedDoor = Pair.of((Object)doorFacing, (Object)activatedDoorPos);
        Pair addedDoor = null;
        BlockPos roomLocation = null;
        Direction oppositeDoorFacing = doorFacing.func_176734_d();
        DungeonRoom testingRoom = DungeonSynthesizer.getRandomRoom(roomType, rand);
        if (displayDetailedInformation) {
            System.out.println("Room type: " + roomType);
        }
        List rotationList = Rotation.func_222467_b((Random)rand);
        block0: for (Rotation initialRotation : rotationList) {
            settings.func_186220_a(initialRotation);
            List<BlockPos> otherDoorList = testingRoom.getDoorOffsetsForFacing(settings, activatedDoorType, oppositeDoorFacing, BlockPos.field_177992_a);
            if (otherDoorList == null || otherDoorList.isEmpty()) continue;
            int doorIndex = rand.nextInt(otherDoorList.size());
            BlockPos testDoor = otherDoorList.get(doorIndex);
            roomLocation = activatedDoorPos.func_177973_b((Vector3i)testDoor).func_177971_a(doorFacing.func_176730_m());
            List<AreaDescriptor> descriptors = testingRoom.getAreaDescriptors(settings, roomLocation);
            for (AreaDescriptor testDesc : descriptors) {
                for (AreaDescriptor currentDesc : this.descriptorList) {
                    if (!testDesc.intersects(currentDesc)) continue;
                    break block0;
                }
            }
            settings.func_215219_b();
            settings.func_215222_a((StructureProcessor)new StoneToOreProcessor(testingRoom.oreDensity));
            this.descriptorList.addAll(descriptors);
            addedDoor = Pair.of((Object)oppositeDoorFacing, (Object)testDoor.func_177971_a((Vector3i)roomLocation));
            placedRoom = testingRoom;
            break;
        }
        if (placedRoom == null) {
            return false;
        }
        placedRoom.placeStructureAtPosition(rand, settings, world, roomLocation);
        ++this.activatedDoors;
        this.checkSpecialRoomRequirements();
        for (String doorType : placedRoom.doorMap.keySet()) {
            Direction addedDoorFace;
            if (!this.availableDoorMasterMap.containsKey(doorType)) {
                this.availableDoorMasterMap.put(doorType, new HashMap());
            }
            Map<Direction, List<BlockPos>> availableDoorMap = this.availableDoorMasterMap.get(doorType);
            for (Direction facing : Direction.values()) {
                if (!availableDoorMap.containsKey(facing)) {
                    availableDoorMap.put(facing, new ArrayList());
                }
                List<BlockPos> doorList = availableDoorMap.get(facing);
                doorList.addAll(placedRoom.getDoorOffsetsForFacing(settings, doorType, facing, roomLocation));
            }
            if (!doorType.equals(activatedDoorType)) continue;
            Direction activatedDoorFace = (Direction)activatedDoor.getKey();
            if (availableDoorMap.containsKey(activatedDoorFace)) {
                availableDoorMap.get(activatedDoorFace).remove(activatedDoor.getRight());
            }
            if (!availableDoorMap.containsKey(addedDoorFace = (Direction)addedDoor.getKey())) continue;
            availableDoorMap.get(addedDoorFace).remove(addedDoor.getRight());
        }
        List<DungeonDoor> doorTypeMap = placedRoom.getPotentialConnectedRoomTypes(settings, roomLocation);
        for (DungeonDoor dungeonDoor : doorTypeMap) {
            if (((Direction)addedDoor.getKey()).equals((Object)dungeonDoor.doorDir) && ((BlockPos)addedDoor.getRight()).equals((Object)dungeonDoor.doorPos)) continue;
            if (extendCorriDoors) {
                this.addNewDoorBlock(world, controllerPos, dungeonDoor.doorPos, dungeonDoor.doorDir, activatedDoorType, potentialRooms, new ArrayList<ResourceLocation>());
                continue;
            }
            if (displayDetailedInformation) {
                System.out.println("Room list: " + dungeonDoor.getRoomList());
            }
            this.addNewDoorBlock(world, controllerPos, dungeonDoor.doorPos, dungeonDoor.doorDir, dungeonDoor.doorType, dungeonDoor.getRoomList(), dungeonDoor.getSpecialRoomList());
        }
        return true;
    }

    public void checkSpecialRoomRequirements() {
        if (displayDetailedInformation) {
            System.out.println("Number of activated doors: " + this.activatedDoors);
        }
        if (this.activatedDoors == 3) {
            // empty if block
        }
    }

    public static boolean placeStructureAtPosition(Random rand, ServerWorld world, BlockPos pos) {
        return false;
    }

    public static DungeonRoom getRandomRoom(ResourceLocation roomType, Random rand) {
        return DungeonRoomRegistry.getRandomDungeonRoom(roomType, rand);
    }

    public static DungeonRoom getDungeonRoom(ResourceLocation dungeonName) {
        return DungeonRoomRegistry.getDungeonRoom(dungeonName);
    }
}

