/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import java.util.Locale;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.block.BlockDemonCrystal;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.tile.base.TileTicking;
import wayoftime.bloodmagic.will.DemonWillHolder;

public class TileDemonCrystal
extends TileTicking {
    public static final double sameWillConversionRate = 45.0;
    public static final double defaultWillConversionRate = 90.0;
    public static final double timeDelayForWrongWill = 0.6;
    public final int maxWill = 100;
    public DemonWillHolder holder = new DemonWillHolder();
    public double progressToNextCrystal = 0.0;
    public int internalCounter = 0;
    public Direction placement = Direction.UP;
    public double injectedWill = 0.0;
    public double speedModifier = 1.0;
    public double appliedConversionRate = 45.0;
    public EnumDemonWillType willType;
    @ObjectHolder(value="bloodmagic:demoncrystal")
    public static TileEntityType<TileDemonCrystal> TYPE;

    public TileDemonCrystal(TileEntityType<?> type, EnumDemonWillType willType) {
        super(type);
        this.willType = willType;
    }

    public TileDemonCrystal(EnumDemonWillType willType) {
        this(TYPE, willType);
    }

    public TileDemonCrystal() {
        this(TYPE, EnumDemonWillType.DEFAULT);
    }

    @Override
    public void onUpdate() {
        int crystalCount;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.internalCounter;
        if (this.internalCounter % 20 == 0 && (crystalCount = this.getCrystalCount()) < 7) {
            EnumDemonWillType type = this.getWillType();
            double value = WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), this.field_174879_c, type);
            if (value >= 0.5) {
                double nextProgress = this.getCrystalGrowthPerSecond(value);
                double bufferDrainRate = 45.0 - this.appliedConversionRate;
                double conversionRate = Math.min(this.appliedConversionRate, 45.0);
                if (this.injectedWill > 0.0 && bufferDrainRate > 0.0) {
                    nextProgress = Math.min(this.injectedWill / bufferDrainRate, nextProgress);
                }
                nextProgress = Math.min(WorldDemonWillHandler.drainWill(this.func_145831_w(), this.func_174877_v(), type, nextProgress * conversionRate, true) / conversionRate, nextProgress);
                this.progressToNextCrystal += nextProgress;
                if (this.injectedWill > 0.0 && bufferDrainRate > 0.0) {
                    this.injectedWill = Math.max(0.0, this.injectedWill - nextProgress * bufferDrainRate);
                    if (this.injectedWill <= 0.0) {
                        this.appliedConversionRate = 45.0;
                        this.speedModifier = 1.0;
                    }
                }
            } else if (type != EnumDemonWillType.DEFAULT && (value = WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), this.field_174879_c, EnumDemonWillType.DEFAULT)) > 0.5) {
                double nextProgress = this.getCrystalGrowthPerSecond(value) * 0.6;
                this.progressToNextCrystal += WorldDemonWillHandler.drainWill(this.func_145831_w(), this.func_174877_v(), EnumDemonWillType.DEFAULT, nextProgress * 90.0, true) / 90.0;
            }
            if (this.speedModifier <= 0.0) {
                this.speedModifier = 1.0;
            }
            this.checkAndGrowCrystal();
        }
    }

    public double getInjectedWill() {
        return this.injectedWill;
    }

    public void applyCatalyst(double addedInjectedWill, double speedModifier, double conversionRate) {
        if (this.speedModifier < speedModifier) {
            this.speedModifier = speedModifier;
        }
        if (this.appliedConversionRate > conversionRate) {
            this.appliedConversionRate = conversionRate;
        }
        this.injectedWill += addedInjectedWill;
    }

    public double growCrystalWithWillAmount(double willDrain, double progressPercentage) {
        double percentDrain;
        int crystalCount = this.getCrystalCount();
        if (crystalCount >= 7) {
            return 0.0;
        }
        EnumDemonWillType type = this.getWillType();
        double value = WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), this.field_174879_c, type);
        double d = percentDrain = willDrain <= 0.0 ? 1.0 : Math.min(1.0, value / willDrain);
        if (percentDrain <= 0.0) {
            return 0.0;
        }
        WorldDemonWillHandler.drainWill(this.func_145831_w(), this.field_174879_c, type, percentDrain * willDrain, true);
        this.progressToNextCrystal += percentDrain * progressPercentage;
        this.checkAndGrowCrystal();
        return percentDrain * progressPercentage;
    }

    public EnumDemonWillType getWillType() {
        return this.willType;
    }

    public void checkAndGrowCrystal() {
        int crystalCount = this.getCrystalCount();
        if (this.progressToNextCrystal >= 1.0 && this.internalCounter % 100 == 0 && crystalCount < 7) {
            this.progressToNextCrystal -= 1.0;
            this.setCrystalCount(crystalCount + 1);
            this.func_70296_d();
            this.notifyUpdate();
        }
    }

    public double getMaxWillForCrystal() {
        return 50.0;
    }

    public boolean dropSingleCrystal() {
        EnumDemonWillType type;
        ItemStack stack;
        int crystalCount = this.getCrystalCount();
        if (!this.func_145831_w().field_72995_K && crystalCount > 1 && !(stack = BlockDemonCrystal.getItemStackDropped(type = this.getWillType(), 1)).func_190926_b()) {
            this.setCrystalCount(crystalCount - 1);
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)stack);
            this.notifyUpdate();
            return true;
        }
        return false;
    }

    public double getCrystalGrowthPerSecond(double will) {
        double speed = 0.005 * Math.sqrt(will / 200.0);
        if (this.speedModifier > 0.0) {
            speed *= this.speedModifier;
        }
        return speed;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        this.holder.readFromNBT(tag, "Will");
        this.placement = Direction.func_82600_a((int)tag.func_74762_e("placement"));
        this.progressToNextCrystal = tag.func_74769_h("progress");
        this.willType = !tag.func_74764_b("demonWillType") ? EnumDemonWillType.DEFAULT : EnumDemonWillType.valueOf(tag.func_74779_i("demonWillType").toUpperCase(Locale.ROOT));
        this.injectedWill = tag.func_74769_h("injectedWill");
        this.speedModifier = tag.func_74769_h("speedModifier");
        this.appliedConversionRate = tag.func_74769_h("appliedConversionRate");
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        this.holder.writeToNBT(tag, "Will");
        tag.func_74768_a("placement", this.placement.func_176745_a());
        tag.func_74780_a("progress", this.progressToNextCrystal);
        if (this.willType == EnumDemonWillType.DEFAULT) {
            if (tag.func_74764_b("demonWillType")) {
                tag.func_82580_o("demonWillType");
            }
        } else {
            tag.func_74778_a("demonWillType", this.willType.toString());
        }
        tag.func_74780_a("injectedWill", this.injectedWill);
        tag.func_74780_a("speedModifier", this.speedModifier);
        tag.func_74780_a("appliedConversionRate", this.appliedConversionRate);
        return tag;
    }

    public int getCrystalCount() {
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        return (Integer)state.func_177229_b((Property)BlockDemonCrystal.AGE) + 1;
    }

    public void setCrystalCount(int crystalCount) {
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)state.func_206870_a((Property)BlockDemonCrystal.AGE, (Comparable)Integer.valueOf(crystalCount - 1)));
    }

    public Direction getPlacement() {
        return this.placement;
    }

    public void setPlacement(Direction placement) {
        this.placement = placement;
    }
}

