/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.recipe.IElvenItem;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.item.ModItems;
import vazkii.patchouli.api.PatchouliAPI;

public class ItemLexicon
extends Item
implements IElvenItem {
    public static final String TAG_ELVEN_UNLOCK = "botania:elven_unlock";

    public ItemLexicon(Item.Properties props) {
        super(props);
    }

    public static boolean isOpen() {
        return Registry.field_212630_s.func_177774_c((Object)ModItems.lexicon).equals((Object)PatchouliAPI.get().getOpenBookGui());
    }

    public void func_150895_a(@Nonnull ItemGroup tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((IItemProvider)this));
            ItemStack creative = new ItemStack((IItemProvider)this);
            creative.func_196082_o().func_74757_a(TAG_ELVEN_UNLOCK, true);
            list.add((Object)creative);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)ItemLexicon.getEdition().func_230532_e_().func_240699_a_(TextFormatting.GRAY));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)playerIn;
            UseItemSuccessTrigger.INSTANCE.trigger(player, stack, player.func_71121_q(), player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            PatchouliAPI.get().openBookGUI((ServerPlayerEntity)playerIn, Registry.field_212630_s.func_177774_c((Object)this));
            playerIn.func_184185_a(ModSounds.lexiconOpen, 1.0f, (float)(0.7 + Math.random() * 0.4));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public static ITextComponent getEdition() {
        return PatchouliAPI.get().getSubtitle(Registry.field_212630_s.func_177774_c((Object)ModItems.lexicon));
    }

    public static ITextComponent getTitle(ItemStack stack) {
        ITextComponent title = stack.func_200301_q();
        String akashicTomeNBT = "akashictome:displayName";
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(akashicTomeNBT)) {
            title = ITextComponent.Serializer.func_240643_a_((String)stack.func_77978_p().func_74779_i(akashicTomeNBT));
        }
        return title;
    }

    @Override
    public boolean isElvenItem(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n(TAG_ELVEN_UNLOCK);
    }

    public static BlockRayTraceResult doRayTrace(World world, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        return Item.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)fluidMode);
    }
}

