/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.util.RenderContextList;
import team.chisel.ctm.client.model.ModelUtil;
import team.chisel.ctm.client.state.CTMContext;
import team.chisel.ctm.client.util.ProfileUtil;

public abstract class AbstractCTMBakedModel
implements IDynamicBakedModel {
    private static Cache<ModelResourceLocation, AbstractCTMBakedModel> itemcache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private static Cache<State, AbstractCTMBakedModel> modelcache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(5000L).build();
    @Nonnull
    private final IModelCTM model;
    @Nonnull
    private final IBakedModel parent;
    @Nonnull
    private final Overrides overrides = new Overrides();
    protected final ListMultimap<RenderType, BakedQuad> genQuads = MultimapBuilder.hashKeys().arrayListValues().build();
    protected final Table<RenderType, Direction, List<BakedQuad>> faceQuads = Tables.newCustomTable(new HashMap(), () -> Maps.newEnumMap(Direction.class));
    private final EnumMap<Direction, ImmutableList<BakedQuad>> noLayerCache = new EnumMap(Direction.class);
    private ImmutableList<BakedQuad> noSideNoLayerCache;
    protected static final ModelProperty<CTMContext> CTM_CONTEXT = new ModelProperty();
    protected static final RenderType[] LAYERS = RenderType.func_228661_n_().toArray(new RenderType[0]);

    public static void invalidateCaches() {
        itemcache.invalidateAll();
        modelcache.invalidateAll();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        ImmutableList<BakedQuad> ret;
        IBakedModel parent = this.getParent(rand);
        ProfileUtil.start("ctm_models");
        AbstractCTMBakedModel baked = this;
        RenderType layer = MinecraftForgeClient.getRenderLayer();
        try {
            if (Minecraft.func_71410_x().field_71441_e != null && extraData.hasProperty(CTM_CONTEXT)) {
                ProfileUtil.start("state_creation");
                RenderContextList ctxList = ((CTMContext)extraData.getData(CTM_CONTEXT)).getContextList(state, baked);
                Object2LongMap<ICTMTexture<?>> serialized = ctxList.serialized();
                ProfileUtil.endAndStart("model_creation");
                baked = (AbstractCTMBakedModel)modelcache.get((Object)new State(state, serialized, parent), () -> this.createModel(state, this.model, parent, ctxList, rand));
                ProfileUtil.end();
            } else if (state != null) {
                ProfileUtil.start("model_creation");
                baked = (AbstractCTMBakedModel)modelcache.get((Object)new State(state, null, parent), () -> this.createModel(state, this.model, parent, null, rand));
                ProfileUtil.end();
            }
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        ProfileUtil.start("quad_lookup");
        if (side != null && layer != null) {
            ret = (List)baked.faceQuads.get((Object)layer, (Object)side);
        } else if (side != null) {
            AbstractCTMBakedModel _baked = baked;
            ret = (List)baked.noLayerCache.computeIfAbsent(side, f -> ImmutableList.copyOf((Collection)_baked.faceQuads.column(f).values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList())));
        } else if (layer != null) {
            ret = baked.genQuads.get((Object)layer);
        } else {
            ret = baked.noSideNoLayerCache;
            if (ret == null) {
                ret = baked.noSideNoLayerCache = ImmutableList.copyOf((Collection)baked.genQuads.values().stream().distinct().collect(Collectors.toList()));
            }
        }
        ProfileUtil.end();
        ProfileUtil.end();
        return ret;
    }

    public IModelData getModelData(IBlockDisplayReader world, BlockPos pos, BlockState state, IModelData tileData) {
        if (tileData == EmptyModelData.INSTANCE) {
            tileData = new ModelDataMap.Builder().withProperty(CTM_CONTEXT).build();
        }
        tileData.setData(CTM_CONTEXT, (Object)new CTMContext((IBlockReader)world, pos));
        return tileData;
    }

    @Nonnull
    public IBakedModel getParent(Random rand) {
        if (this.getParent() instanceof WeightedBakedModel) {
            List models = ((WeightedBakedModel)this.getParent()).field_177565_b;
            return ((WeightedBakedModel.WeightedModel)WeightedRandom.func_180166_a((List)models, (int)(Math.abs((int)((int)rand.nextLong())) % ((WeightedBakedModel)this.getParent()).field_177567_a))).field_185281_b;
        }
        return this.getParent();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.parent.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.parent.func_177554_e();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack ms) {
        this.parent.handlePerspective(cameraTransformType, ms);
        return this;
    }

    protected abstract AbstractCTMBakedModel createModel(BlockState var1, @Nonnull IModelCTM var2, IBakedModel var3, RenderContextList var4, Random var5);

    public boolean func_230044_c_() {
        return this.getParent().func_230044_c_();
    }

    private <T> T applyToParent(Random rand, Function<AbstractCTMBakedModel, T> func) {
        IBakedModel parent = this.getParent(rand);
        if (parent instanceof AbstractCTMBakedModel) {
            return func.apply((AbstractCTMBakedModel)parent);
        }
        return null;
    }

    protected ICTMTexture<?> getOverrideTexture(Random rand, int tintIndex, ResourceLocation texture) {
        ICTMTexture ret = this.getModel().getOverrideTexture(tintIndex, texture);
        if (ret == null) {
            ret = this.applyToParent(rand, parent -> parent.getOverrideTexture(rand, tintIndex, texture));
        }
        return ret;
    }

    protected ICTMTexture<?> getTexture(Random rand, ResourceLocation texture) {
        ICTMTexture ret = this.getModel().getTexture(texture);
        if (ret == null) {
            ret = this.applyToParent(rand, parent -> parent.getTexture(rand, texture));
        }
        return ret;
    }

    protected TextureAtlasSprite getOverrideSprite(Random rand, int tintIndex) {
        TextureAtlasSprite ret = this.getModel().getOverrideSprite(tintIndex);
        if (ret == null) {
            ret = this.applyToParent(rand, parent -> parent.getOverrideSprite(rand, tintIndex));
        }
        return ret;
    }

    public Collection<ICTMTexture<?>> getCTMTextures() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.getModel().getCTMTextures());
        if (this.getParent() instanceof AbstractCTMBakedModel) {
            builder.addAll(((AbstractCTMBakedModel)this.getParent()).getCTMTextures());
        }
        return builder.build();
    }

    public AbstractCTMBakedModel(@Nonnull IModelCTM model, @Nonnull IBakedModel parent) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        this.model = model;
        this.parent = parent;
    }

    @Nonnull
    public IModelCTM getModel() {
        return this.model;
    }

    @Nonnull
    public IBakedModel getParent() {
        return this.parent;
    }

    private static class State {
        @Nonnull
        private final BlockState cleanState;
        @Nullable
        private final Object2LongMap<ICTMTexture<?>> serializedContext;
        @Nonnull
        private final IBakedModel parent;

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            State other = (State)obj;
            if (this.cleanState != other.cleanState) {
                return false;
            }
            if (this.parent != other.parent) {
                return false;
            }
            return !(this.serializedContext == null ? other.serializedContext != null : !this.serializedContext.equals(other.serializedContext));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + System.identityHashCode(this.cleanState);
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            result = 31 * result + (this.serializedContext == null ? 0 : this.serializedContext.hashCode());
            return result;
        }

        @Nonnull
        public BlockState getCleanState() {
            return this.cleanState;
        }

        @Nullable
        public Object2LongMap<ICTMTexture<?>> getSerializedContext() {
            return this.serializedContext;
        }

        @Nonnull
        public IBakedModel getParent() {
            return this.parent;
        }

        public State(@Nonnull BlockState cleanState, @Nullable Object2LongMap<ICTMTexture<?>> serializedContext, @Nonnull IBakedModel parent) {
            if (cleanState == null) {
                throw new NullPointerException("cleanState is marked non-null but is null");
            }
            if (parent == null) {
                throw new NullPointerException("parent is marked non-null but is null");
            }
            this.cleanState = cleanState;
            this.serializedContext = serializedContext;
            this.parent = parent;
        }

        public String toString() {
            return "AbstractCTMBakedModel.State(cleanState=" + this.getCleanState() + ", serializedContext=" + this.getSerializedContext() + ", parent=" + this.getParent() + ")";
        }
    }

    @ParametersAreNonnullByDefault
    private class Overrides
    extends ItemOverrideList {
        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, ClientWorld world, LivingEntity entity) {
            Block block = null;
            if (stack.func_77973_b() instanceof BlockItem) {
                block = ((BlockItem)stack.func_77973_b()).func_179223_d();
            }
            BlockState state = block == null ? null : block.func_176223_P();
            ModelResourceLocation mrl = ModelUtil.getMesh(stack);
            if (mrl == null) {
                return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            }
            Random random = new Random();
            random.setSeed(42L);
            return (IBakedModel)itemcache.get((Object)mrl, () -> AbstractCTMBakedModel.this.createModel(state, AbstractCTMBakedModel.this.model, AbstractCTMBakedModel.this.getParent(random), null, random));
        }
    }
}

