/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.api.block;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.TagsProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import team.chisel.api.block.BlockProvider;
import team.chisel.api.block.ChiselBlockFactory;
import team.chisel.api.block.ModelTemplate;
import team.chisel.api.block.RecipeTemplate;
import team.chisel.api.block.VariantTemplate;
import team.chisel.api.block.VariationData;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.client.data.ModelTemplates;
import team.chisel.client.data.VariantTemplates;
import team.chisel.repack.registrate.Registrate;
import team.chisel.repack.registrate.builders.BlockBuilder;
import team.chisel.repack.registrate.builders.ItemBuilder;
import team.chisel.repack.registrate.providers.DataGenContext;
import team.chisel.repack.registrate.providers.ProviderType;
import team.chisel.repack.registrate.providers.RegistrateBlockstateProvider;
import team.chisel.repack.registrate.providers.RegistrateItemModelProvider;
import team.chisel.repack.registrate.providers.RegistrateLangProvider;
import team.chisel.repack.registrate.providers.RegistrateRecipeProvider;
import team.chisel.repack.registrate.providers.RegistrateTagsProvider;
import team.chisel.repack.registrate.providers.loot.RegistrateBlockLootTables;
import team.chisel.repack.registrate.util.entry.BlockEntry;
import team.chisel.repack.registrate.util.nullness.NonNullBiConsumer;
import team.chisel.repack.registrate.util.nullness.NonNullFunction;
import team.chisel.repack.registrate.util.nullness.NonNullSupplier;
import team.chisel.repack.registrate.util.nullness.NonNullUnaryOperator;

@ParametersAreNonnullByDefault
public class ChiselBlockBuilder<T extends Block> {
    private final ChiselBlockFactory parent;
    private final Registrate registrate;
    private final Material material;
    private final String blockName;
    private final List<VariationBuilder<T>> variations;
    private final BlockProvider<T> provider;
    @Nullable
    private ITag.INamedTag<Block> group;
    private Set<ResourceLocation> otherBlocks = new HashSet<ResourceLocation>();
    private Set<ResourceLocation> otherTags = new HashSet<ResourceLocation>();
    private String groupName;
    private boolean opaque = true;
    private Supplier<Supplier<RenderType>> layer = () -> RenderType::func_228639_c_;
    private ModelTemplate model = ModelTemplates.simpleBlock();
    private RecipeTemplate recipe = RecipeTemplate.none();
    private NonNullBiConsumer<RegistrateBlockLootTables, T> loot = (rec$, x$0) -> ((BlockLootTables)rec$).func_218492_c((Block)x$0);
    private static final NonNullUnaryOperator<AbstractBlock.Properties> NO_ACTION = NonNullUnaryOperator.identity();

    protected ChiselBlockBuilder(ChiselBlockFactory parent, Registrate registrate, Material material, String blockName, @Nullable ITag.INamedTag<Block> group, BlockProvider<T> provider) {
        this.parent = parent;
        this.registrate = registrate;
        this.material = material;
        this.blockName = blockName;
        this.provider = provider;
        this.group = group;
        this.groupName = group == null ? null : RegistrateLangProvider.toEnglishName(group.func_230234_a_().func_110623_a());
        this.variations = new ArrayList<VariationBuilder<T>>();
    }

    public ChiselBlockBuilder<T> applyIf(BooleanSupplier pred, NonNullUnaryOperator<ChiselBlockBuilder<T>> action) {
        if (pred.getAsBoolean()) {
            return (ChiselBlockBuilder)action.apply(this);
        }
        return this;
    }

    public VariationBuilder<T> variation(String name) {
        return this._variation(VariantTemplates.empty(name, new String[0]));
    }

    public ChiselBlockBuilder<T> variation(VariantTemplate template) {
        return this._variation(template).buildVariation();
    }

    private VariationBuilder<T> _variation(VariantTemplate template) {
        return new VariationBuilder(this, template.getName()).opaque(this.opaque).localizedName(template.getLocalizedName()).model(template.getModelTemplate().orElse(this.model)).recipe(template.getRecipeTemplate().orElse(this.recipe)).tooltip(template.getTooltip());
    }

    public ChiselBlockBuilder<T> variations(Collection<? extends VariantTemplate> templates) {
        ChiselBlockBuilder<T> ret = this;
        for (VariantTemplate variantTemplate : templates) {
            ret = this.variation(variantTemplate);
        }
        return ret;
    }

    public ChiselBlockBuilder<T> addBlock(Block block) {
        return this.addBlock(block.getRegistryName());
    }

    public ChiselBlockBuilder<T> addBlock(ResourceLocation block) {
        this.otherBlocks.add(block);
        return this;
    }

    public ChiselBlockBuilder<T> addTag(ITag.INamedTag<Block> tag) {
        return this.addTag(tag.func_230234_a_());
    }

    public ChiselBlockBuilder<T> addTag(ResourceLocation tag) {
        this.otherTags.add(tag);
        return this;
    }

    public Map<String, BlockEntry<T>> build() {
        return this.build(NO_ACTION);
    }

    public Map<String, BlockEntry<T>> build(NonNullUnaryOperator<AbstractBlock.Properties> after) {
        HashMap<String, BlockEntry<T>> ret;
        block6: {
            block7: {
                if (this.variations.size() == 0) {
                    throw new IllegalArgumentException("Must have at least one variation!");
                }
                Variation[] data = new Variation[this.variations.size()];
                for (int i = 0; i < this.variations.size(); ++i) {
                    data[i] = ((VariationBuilder)this.variations.get(i)).doBuild();
                }
                ret = new HashMap<String, BlockEntry<T>>(data.length);
                ICarvingGroup group = CarvingUtils.itemGroup(this.group, this.groupName);
                for (int i = 0; i < data.length; ++i) {
                    if (Strings.emptyToNull((String)data[i].getName()) == null) continue;
                    int index = i;
                    Variation var = data[index];
                    VariationBuilder builder = this.variations.get(index);
                    ret.put(var.getName(), (BlockEntry<T>)((BlockBuilder)((BlockBuilder)((Registrate)this.registrate.object(this.blockName + "/" + var.getName())).block(this.material, p -> this.provider.createBlock((AbstractBlock.Properties)p, new VariationDataImpl((NonNullSupplier)ret.get(var.getName()), var.getName(), var.getDisplayName(), group))).properties(p -> p.func_200943_b(1.0f)).addLayer(this.layer).transform(this::addTag).properties(after).blockstate((ctx, prov) -> builder.model.accept((RegistrateBlockstateProvider)prov, (Block)ctx.getEntry())).setData(ProviderType.LANG, NonNullBiConsumer.noop())).recipe((DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) -> builder.recipe.accept((RegistrateRecipeProvider)prov, (Block)ctx.getEntry())).loot(this.loot).item((x$0, x$1) -> this.provider.createBlockItem((Object)((Block)x$0), (Item.Properties)x$1)).model((DataGenContext<Item, T> ctx, RegistrateItemModelProvider prov) -> {
                        ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.withExistingParent("item/" + prov.name(ctx::getEntry), new ResourceLocation(prov.modid(ctx::getEntry), "block/" + prov.name(ctx::getEntry)));
                    }).transform(this::addTag).build()).register());
                }
                if (this.group == null) break block6;
                CarvingUtils.getChiselRegistry().addGroup(group);
                if (!this.otherBlocks.isEmpty()) break block7;
                if (this.otherTags.isEmpty()) break block6;
            }
            this.addExtraTagEntries(ProviderType.BLOCK_TAGS, t -> t, arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getValue(arg_0));
            this.addExtraTagEntries(ProviderType.ITEM_TAGS, t -> this.parent.getItemTag(t.func_230234_a_()), arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0));
        }
        return ret;
    }

    private <TAG> void addExtraTagEntries(ProviderType<? extends RegistrateTagsProvider<TAG>> type, NonNullFunction<ITag.INamedTag<Block>, ITag.INamedTag<TAG>> tagGetter, NonNullFunction<ResourceLocation, TAG> entryLookup) {
        this.registrate.addDataGenerator(type, prov -> {
            TagsProvider.Builder builder = prov.func_240522_a_((ITag.INamedTag)tagGetter.apply(this.group)).func_240534_a_(this.otherBlocks.stream().map(entryLookup::apply).toArray());
            this.otherTags.forEach(arg_0 -> ((TagsProvider.Builder)builder).addOptional(arg_0));
        });
    }

    private <B extends Block, P> BlockBuilder<B, P> addTag(BlockBuilder<B, P> builder) {
        if (this.group != null) {
            return builder.tag(this.group);
        }
        return builder;
    }

    private <I extends Item, P> ItemBuilder<I, P> addTag(ItemBuilder<I, P> builder) {
        if (this.group != null) {
            return builder.tag(this.parent.getItemTag(this.group.func_230234_a_()));
        }
        return builder;
    }

    public ChiselBlockBuilder<T> setGroup(@Nullable ITag.INamedTag<Block> group) {
        this.group = group;
        return this;
    }

    public ChiselBlockBuilder<T> setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public ChiselBlockBuilder<T> opaque(boolean opaque) {
        this.opaque = opaque;
        return this;
    }

    public ChiselBlockBuilder<T> layer(Supplier<Supplier<RenderType>> layer) {
        this.layer = layer;
        return this;
    }

    public ChiselBlockBuilder<T> model(ModelTemplate model) {
        this.model = model;
        return this;
    }

    public ChiselBlockBuilder<T> recipe(RecipeTemplate recipe) {
        this.recipe = recipe;
        return this;
    }

    public ChiselBlockBuilder<T> loot(NonNullBiConsumer<RegistrateBlockLootTables, T> loot) {
        this.loot = loot;
        return this;
    }

    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    private static final class VariationDataImpl
    implements VariationData {
        private final String name;
        private final TranslationTextComponent displayName;
        private final NonNullSupplier<? extends Block> block;
        private final ICarvingGroup group;

        VariationDataImpl(NonNullSupplier<? extends Block> block, String name, TranslationTextComponent displayName, ICarvingGroup group) {
            this.block = block;
            this.name = name;
            this.displayName = displayName;
            this.group = group;
        }

        @Override
        public Block getBlock() {
            return this.block.get();
        }

        @Override
        public Item getItem() {
            return this.getBlock().func_199767_j();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariationDataImpl)) {
                return false;
            }
            VariationDataImpl other = (VariationDataImpl)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            TranslationTextComponent this$displayName = this.getDisplayName();
            TranslationTextComponent other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            Block this$block = this.getBlock();
            Block other$block = other.getBlock();
            if (this$block == null ? other$block != null : !this$block.equals(other$block)) {
                return false;
            }
            ICarvingGroup this$group = this.getGroup();
            ICarvingGroup other$group = other.getGroup();
            return !(this$group == null ? other$group != null : !this$group.equals(other$group));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            TranslationTextComponent $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            Block $block = this.getBlock();
            result = result * 59 + ($block == null ? 43 : $block.hashCode());
            ICarvingGroup $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            return result;
        }

        public String toString() {
            return "ChiselBlockBuilder.VariationDataImpl(name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", block=" + this.getBlock() + ", group=" + this.getGroup() + ")";
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TranslationTextComponent getDisplayName() {
            return this.displayName;
        }

        @Override
        public ICarvingGroup getGroup() {
            return this.group;
        }
    }

    @MethodsReturnNonnullByDefault
    private static class Variation {
        private final String name;
        private final TranslationTextComponent displayName;

        public Variation(String name, TranslationTextComponent displayName) {
            this.name = name;
            this.displayName = displayName;
        }

        public String getName() {
            return this.name;
        }

        public TranslationTextComponent getDisplayName() {
            return this.displayName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Variation)) {
                return false;
            }
            Variation other = (Variation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            TranslationTextComponent this$displayName = this.getDisplayName();
            TranslationTextComponent other$displayName = other.getDisplayName();
            return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Variation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            TranslationTextComponent $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            return result;
        }

        public String toString() {
            return "ChiselBlockBuilder.Variation(name=" + this.getName() + ", displayName=" + this.getDisplayName() + ")";
        }
    }

    public static class VariationBuilder<T extends Block> {
        private static final Map<ResourceLocation, String> TRANSLATIONS = new HashMap<ResourceLocation, String>();
        private static final Map<ResourceLocation, TranslationTextComponent> COMPONENTS = new HashMap<ResourceLocation, TranslationTextComponent>();
        private ChiselBlockBuilder<T> parent;
        private String name;
        private String localizedName;
        private boolean opaque;
        private ModelTemplate model = ModelTemplates.simpleBlock();
        private RecipeTemplate recipe = RecipeTemplate.none();
        private String[] tooltip = new String[0];

        private VariationBuilder(ChiselBlockBuilder<T> parent, String name) {
            this.parent = parent;
            this.name = name;
            this.localizedName = RegistrateLangProvider.toEnglishName(name);
        }

        public VariationBuilder<T> tooltip(String ... lines) {
            this.tooltip = Arrays.copyOf(lines, lines.length);
            return this;
        }

        public ChiselBlockBuilder<T> buildVariation() {
            ((ChiselBlockBuilder)this.parent).variations.add(this);
            return this.parent;
        }

        public VariationBuilder<T> next(String name) {
            return this.buildVariation().variation(name);
        }

        public Map<String, BlockEntry<T>> build() {
            return this.buildVariation().build();
        }

        public Map<String, BlockEntry<T>> build(NonNullUnaryOperator<AbstractBlock.Properties> after) {
            return this.buildVariation().build(after);
        }

        private Variation doBuild() {
            ResourceLocation translationKey = new ResourceLocation(((ChiselBlockBuilder)this.parent).registrate.getModid(), this.name);
            String existingTranslation = TRANSLATIONS.get(translationKey);
            if (existingTranslation != null && !Objects.equals(this.localizedName, existingTranslation)) {
                throw new IllegalStateException("Cannot redefine existing variation's localized name: " + translationKey + " -> " + this.localizedName + " (should be " + existingTranslation + ")");
            }
            if (existingTranslation == null) {
                TRANSLATIONS.put(translationKey, this.localizedName);
                TranslationTextComponent component = ((ChiselBlockBuilder)this.parent).registrate.addLang("variant", translationKey, this.localizedName);
                COMPONENTS.put(translationKey, component);
                for (int j = 0; j < this.tooltip.length; ++j) {
                    ((ChiselBlockBuilder)this.parent).registrate.addRawLang(component.func_150268_i() + ".desc." + (j + 1), this.tooltip[j]);
                }
            }
            return new Variation(this.name, COMPONENTS.get(translationKey));
        }

        public VariationBuilder<T> localizedName(String localizedName) {
            this.localizedName = localizedName;
            return this;
        }

        public VariationBuilder<T> opaque(boolean opaque) {
            this.opaque = opaque;
            return this;
        }

        public VariationBuilder<T> model(ModelTemplate model) {
            this.model = model;
            return this;
        }

        public VariationBuilder<T> recipe(RecipeTemplate recipe) {
            this.recipe = recipe;
            return this;
        }
    }
}

