/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.item;

import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.BlockVoxelShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import team.chisel.Chisel;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.IChiselMode;
import team.chisel.common.util.Point2i;
import team.chisel.repack.registrate.providers.RegistrateLangProvider;

public enum ChiselMode implements IChiselMode
{
    SINGLE("Chisel a single block."){

        public Iterable<BlockPos> getCandidates(PlayerEntity player, BlockPos pos, Direction side) {
            return Collections.singleton(pos);
        }

        @Override
        public AxisAlignedBB getBounds(Direction side) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
    }
    ,
    PANEL("Chisel a 3x3 square of blocks."){
        private final BlockPos ONE = new BlockPos(1, 1, 1);
        private final BlockPos NEG_ONE = new BlockPos(-1, -1, -1);

        public Iterable<BlockPos> getCandidates(PlayerEntity player, BlockPos pos, Direction side) {
            if (side.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
                side = side.func_176734_d();
            }
            Vector3i offset = side.func_176730_m();
            return ChiselMode.filteredIterable(BlockPos.func_218281_b((BlockPos)this.NEG_ONE.func_177971_a(offset).func_177971_a((Vector3i)pos), (BlockPos)this.ONE.func_177973_b(offset).func_177971_a((Vector3i)pos)), player.field_70170_p, player.field_70170_p.func_180495_p(pos));
        }

        @Override
        public AxisAlignedBB getBounds(Direction side) {
            switch (side.func_176740_k()) {
                default: {
                    return new AxisAlignedBB(0.0, -1.0, -1.0, 1.0, 2.0, 2.0);
                }
                case Y: {
                    return new AxisAlignedBB(-1.0, 0.0, -1.0, 2.0, 1.0, 2.0);
                }
                case Z: 
            }
            return new AxisAlignedBB(-1.0, -1.0, 0.0, 2.0, 2.0, 1.0);
        }
    }
    ,
    COLUMN("Chisel a 3x1 column of blocks."){

        public Iterable<BlockPos> getCandidates(PlayerEntity player, BlockPos pos, Direction side) {
            int facing = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            LinkedHashSet<BlockPos> ret = new LinkedHashSet<BlockPos>();
            for (int i = -1; i <= 1; ++i) {
                if (side != Direction.DOWN && side != Direction.UP) {
                    ret.add(pos.func_177981_b(i));
                    continue;
                }
                if (facing == 0 || facing == 2) {
                    ret.add(pos.func_177970_e(i));
                    continue;
                }
                ret.add(pos.func_177965_g(i));
            }
            return ChiselMode.filteredIterable(ret.stream(), player.field_70170_p, player.field_70170_p.func_180495_p(pos));
        }

        @Override
        public AxisAlignedBB getBounds(Direction side) {
            return PANEL.getBounds(side);
        }

        @Override
        public long[] getCacheState(BlockPos origin, Direction side) {
            return ArrayUtils.add((long[])super.getCacheState(origin, side), (long)Minecraft.func_71410_x().field_71439_g.func_174811_aO().ordinal());
        }
    }
    ,
    ROW("Chisel a 1x3 row of blocks."){

        public Iterable<BlockPos> getCandidates(PlayerEntity player, BlockPos pos, Direction side) {
            int facing = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            LinkedHashSet<BlockPos> ret = new LinkedHashSet<BlockPos>();
            for (int i = -1; i <= 1; ++i) {
                if (side != Direction.DOWN && side != Direction.UP) {
                    if (side == Direction.EAST || side == Direction.WEST) {
                        ret.add(pos.func_177970_e(i));
                        continue;
                    }
                    ret.add(pos.func_177965_g(i));
                    continue;
                }
                if (facing == 0 || facing == 2) {
                    ret.add(pos.func_177965_g(i));
                    continue;
                }
                ret.add(pos.func_177970_e(i));
            }
            return ChiselMode.filteredIterable(ret.stream(), player.field_70170_p, player.field_70170_p.func_180495_p(pos));
        }

        @Override
        public AxisAlignedBB getBounds(Direction side) {
            return PANEL.getBounds(side);
        }

        @Override
        public long[] getCacheState(BlockPos origin, Direction side) {
            return COLUMN.getCacheState(origin, side);
        }
    }
    ,
    CONTIGUOUS("Chisel an area of alike blocks, extending 10 blocks in any direction."){

        @Override
        public Iterable<? extends BlockPos> getCandidates(PlayerEntity player, BlockPos pos, Direction side) {
            return () -> ChiselMode.getContiguousIterator(pos, player.field_70170_p, Direction.values());
        }

        @Override
        public AxisAlignedBB getBounds(Direction side) {
            int r = 10;
            return new AxisAlignedBB((double)(-r - 1), (double)(-r - 1), (double)(-r - 1), (double)(r + 2), (double)(r + 2), (double)(r + 2));
        }
    }
    ,
    CONTIGUOUS_2D("Contiguous (2D)", "Chisel an area of alike blocks, extending 10 blocks along the plane of the current side."){

        @Override
        public Iterable<? extends BlockPos> getCandidates(PlayerEntity player, BlockPos pos, Direction side) {
            return () -> ChiselMode.getContiguousIterator(pos, player.field_70170_p, (Direction[])ArrayUtils.removeElements((Object[])Direction.values(), (Object[])new Direction[]{side, side.func_176734_d()}));
        }

        @Override
        public AxisAlignedBB getBounds(Direction side) {
            int r = 10;
            switch (side.func_176740_k()) {
                default: {
                    return new AxisAlignedBB(0.0, (double)(-r - 1), (double)(-r - 1), 1.0, (double)(r + 2), (double)(r + 2));
                }
                case Y: {
                    return new AxisAlignedBB((double)(-r - 1), 0.0, (double)(-r - 1), (double)(r + 2), 1.0, (double)(r + 2));
                }
                case Z: 
            }
            return new AxisAlignedBB((double)(-r - 1), (double)(-r - 1), 0.0, (double)(r + 2), (double)(r + 2), 1.0);
        }
    };

    public static final int CONTIGUOUS_RANGE = 10;
    private final TranslationTextComponent localizedName;
    private final TranslationTextComponent localizedDescription;

    private static Iterator<BlockPos> getContiguousIterator(final BlockPos origin, final World world, final Direction[] directionsToSearch) {
        final BlockState state = world.func_180495_p(origin);
        return new Iterator<BlockPos>(){
            private Set<BlockPos> seen;
            private Queue<Node> search;
            {
                this.seen = Sets.newHashSet((Object[])new BlockPos[]{origin});
                this.search = new ArrayDeque<Node>();
                this.search.add(new Node(origin, 0));
            }

            @Override
            public boolean hasNext() {
                return !this.search.isEmpty();
            }

            @Override
            public BlockPos next() {
                Node ret = this.search.poll();
                if (ret.getDistance() < 10) {
                    for (Direction face : directionsToSearch) {
                        BlockPos bp = ret.getPos().func_177972_a(face);
                        BlockState newState = world.func_180495_p(bp);
                        if (!this.seen.contains(bp) && newState == state) {
                            for (Direction obscureCheck : Direction.values()) {
                                BlockPos obscuringPos = bp.func_177972_a(obscureCheck);
                                if (newState.func_242698_a((IBlockReader)world, bp, obscureCheck.func_176734_d(), BlockVoxelShape.FULL)) continue;
                                this.search.offer(new Node(bp, ret.getDistance() + 1));
                                break;
                            }
                        }
                        this.seen.add(bp);
                    }
                }
                return ret.getPos();
            }
        };
    }

    private ChiselMode(String desc) {
        this(null, desc);
    }

    private ChiselMode(String name, String desc) {
        CarvingUtils.getModeRegistry().registerMode(this);
        this.localizedName = Chisel.registrate().addRawLang(this.getUnlocName(), name == null ? RegistrateLangProvider.toEnglishName(this.name()) : name);
        this.localizedDescription = Chisel.registrate().addRawLang(this.getUnlocDescription(), desc);
    }

    private static Iterable<BlockPos> filteredIterable(Stream<BlockPos> source, World world, BlockState state) {
        return source.filter(p -> world.func_180495_p(p) == state)::iterator;
    }

    @Override
    public Point2i getSpritePos() {
        return new Point2i(this.ordinal() % 10 * 24, this.ordinal() / 10 * 24);
    }

    public TranslationTextComponent getLocalizedName() {
        return this.localizedName;
    }

    public TranslationTextComponent getLocalizedDescription() {
        return this.localizedDescription;
    }

    private static final class Node {
        private final BlockPos pos;
        private final int distance;

        public Node(BlockPos pos, int distance) {
            this.pos = pos;
            this.distance = distance;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int getDistance() {
            return this.distance;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            BlockPos this$pos = this.getPos();
            BlockPos other$pos = other.getPos();
            if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
                return false;
            }
            return this.getDistance() == other.getDistance();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BlockPos $pos = this.getPos();
            result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
            result = result * 59 + this.getDistance();
            return result;
        }

        public String toString() {
            return "ChiselMode.Node(pos=" + this.getPos() + ", distance=" + this.getDistance() + ")";
        }
    }
}

