/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia;

import com.epherical.croptopia.Composter;
import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.ForgeAdapter;
import com.epherical.croptopia.blocks.CroptopiaCropBlock;
import com.epherical.croptopia.config.Config;
import com.epherical.croptopia.items.GuideBookItem;
import com.epherical.croptopia.items.SeedItem;
import com.epherical.croptopia.listeners.BiomeModification;
import com.epherical.croptopia.listeners.BlockBreakEvent;
import com.epherical.croptopia.listeners.EntitySpawn;
import com.epherical.croptopia.listeners.Harvest;
import com.epherical.croptopia.listeners.LootTableModification;
import com.epherical.croptopia.loot.AdditionalTableModifier;
import com.epherical.croptopia.loot.EntityModifier;
import com.epherical.croptopia.loot.SpawnChestModifier;
import com.epherical.croptopia.register.Content;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventListenerHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="croptopia")
public class CroptopiaForge {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final SpawnChestModifier.Serializer SPAWN_CHEST_MODIFIER = new SpawnChestModifier.Serializer();
    private static final EntityModifier.Serializer ENTITY_MODIFIER = new EntityModifier.Serializer();
    private static final AdditionalTableModifier.Serializer ADDTIONAL_TABLE_MODIFIER = new AdditionalTableModifier.Serializer();
    public static Config config;
    public static ItemGroup CROPTOPIA_ITEM_GROUP;
    public static CroptopiaMod mod;
    private static boolean hasRun;

    public CroptopiaForge() {
        config = new Config();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(config::initConfig);
        MinecraftForge.EVENT_BUS.addListener(CroptopiaForge::onWorldLoad);
        MinecraftForge.EVENT_BUS.register((Object)new BiomeModification());
        MinecraftForge.EVENT_BUS.register((Object)new LootTableModification());
        MinecraftForge.EVENT_BUS.register((Object)new Harvest());
        MinecraftForge.EVENT_BUS.register((Object)new BlockBreakEvent());
        MinecraftForge.EVENT_BUS.register((Object)new EntitySpawn());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CroptopiaForge.config.config);
        EventListenerHelper.getListenerList(PlayerInteractEvent.RightClickBlock.class);
        CROPTOPIA_ITEM_GROUP = new ItemGroup("croptopia"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)Content.COFFEE);
            }
        };
        mod = new CroptopiaMod(new ForgeAdapter());
    }

    private void setup(FMLCommonSetupEvent event) {
        Composter.init();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        CroptopiaMod.cropBlocks.forEach(block -> RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228641_d_()));
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        colors.func_186722_a((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)world, (BlockPos)pos) : FoliageColors.func_77468_c(), CroptopiaMod.leafBlocks.toArray(new Block[0]));
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((IItemProvider)Content.COOKING_POT));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((IItemProvider)Content.FOOD_PRESS));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((IItemProvider)Content.FRYING_PAN));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((IItemProvider)Content.MORTAR_AND_PESTLE));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterWaterItem", () -> new ItemStack((IItemProvider)Content.WATER_BOTTLE));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterMilkItem", () -> new ItemStack((IItemProvider)Content.MILK_BOTTLE));
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLDedicatedServerSetupEvent event) {
    }

    public static ResourceLocation createIdentifier(String name) {
        return new ResourceLocation("croptopia", name);
    }

    private static void modifyVillagerFoodItems() {
    }

    private static void modifyVillagerGatherables() {
    }

    public static void onWorldLoad(WorldEvent.Load event) {
        if (!hasRun) {
            CroptopiaForge.modifyVillagerFoodItems();
            CroptopiaForge.modifyVillagerGatherables();
            hasRun = true;
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            Content.registerBlocks((id, object) -> {
                object.setRegistryName(id);
                blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)object);
                return object;
            });
        }

        @SubscribeEvent
        public static void onItemRegister(RegistryEvent.Register<Item> itemRegister) {
            Content.GUIDE = new GuideBookItem(CroptopiaMod.createGroup());
            Content.GUIDE.setRegistryName(CroptopiaForge.createIdentifier("guide"));
            itemRegister.getRegistry().register((IForgeRegistryEntry)Content.GUIDE);
            Content.registerItems((id, item) -> {
                item.setRegistryName(id);
                itemRegister.getRegistry().register((IForgeRegistryEntry)item);
                if (item instanceof BlockNamedItem) {
                    ((BlockNamedItem)item).func_195946_a(Item.field_179220_a, item);
                }
                if (item instanceof SeedItem) {
                    SeedItem it = (SeedItem)((Object)item);
                    CroptopiaCropBlock block = (CroptopiaCropBlock)it.func_179223_d();
                    block.setSeed(it);
                }
                return item;
            });
        }

        @SubscribeEvent
        public static void onLootRegister(RegistryEvent.Register<GlobalLootModifierSerializer<?>> register) {
            SPAWN_CHEST_MODIFIER.setRegistryName(new ResourceLocation("croptopia", "spawn_loot"));
            ENTITY_MODIFIER.setRegistryName(new ResourceLocation("croptopia", "entity_modifier"));
            ADDTIONAL_TABLE_MODIFIER.setRegistryName(new ResourceLocation("croptopia", "table_adder"));
            register.getRegistry().register((IForgeRegistryEntry)SPAWN_CHEST_MODIFIER);
            register.getRegistry().register((IForgeRegistryEntry)ENTITY_MODIFIER);
            register.getRegistry().register((IForgeRegistryEntry)ADDTIONAL_TABLE_MODIFIER);
        }
    }
}

