/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.blocks;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.blocks.CroptopiaCropBlock;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LeafCropBlock
extends CroptopiaCropBlock {
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;
    public static final IntegerProperty DISTANCE = BlockStateProperties.field_208514_aa;

    public LeafCropBlock(AbstractBlock.Properties settings) {
        super(settings);
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197868_b();
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this);
    }

    @Override
    protected boolean func_200014_a_(BlockState floor, IBlockReader world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return true;
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        int distance = LeafCropBlock.getDistanceFromLog(neighborState) + 1;
        if (distance != 1 || (Integer)state.func_177229_b((Property)DISTANCE) != distance) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
        return state;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (CroptopiaMod.getInstance().platform().skipHarvest()) {
            return super.func_225533_a_(state, world, pos, player, hand, hit);
        }
        if (this.func_185527_x(state) == this.func_185526_g()) {
            player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
            player.func_71020_j(0.005f);
            world.func_180501_a(pos, this.func_185528_e(0), 2);
            if (world instanceof ServerWorld) {
                for (ItemStack droppedStack : LeafCropBlock.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, null)) {
                    LeafCropBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)droppedStack);
                }
                return ActionResultType.CONSUME;
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public int func_185526_g() {
        return 3;
    }

    public IntegerProperty func_185524_e() {
        return AGE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE, DISTANCE});
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        int i;
        if (world.func_226659_b_(pos, 0) >= 9 && (i = this.func_185527_x(state)) < this.func_185526_g() && random.nextInt(100) % 20 == 0) {
            world.func_180501_a(pos, this.func_185528_e(i + 1), 3);
        }
        if ((Integer)state.func_177229_b((Property)DISTANCE) == 7) {
            LeafCropBlock.func_220075_c((BlockState)state, (World)world, (BlockPos)pos);
            world.func_217377_a(pos, false);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        worldIn.func_180501_a(pos, LeafCropBlock.updateDistanceFromLogs(state, (IWorld)worldIn, pos), 3);
    }

    public int func_200011_d(BlockState state, IBlockReader world, BlockPos pos) {
        return 1;
    }

    private static BlockState updateDistanceFromLogs(BlockState state, IWorld world, BlockPos pos) {
        Direction[] directions;
        int distance = 7;
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (Direction direction : directions = Direction.values()) {
            mutablePos.func_239622_a_((Vector3i)pos, direction);
            distance = Math.min(distance, LeafCropBlock.getDistanceFromLog(world.func_180495_p((BlockPos)mutablePos)) + 1);
            if (distance == 1) break;
        }
        return (BlockState)state.func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(distance));
    }

    private static int getDistanceFromLog(BlockState state) {
        if (state.func_235714_a_((ITag)BlockTags.field_200031_h)) {
            return 0;
        }
        return state.func_177230_c() instanceof LeafCropBlock || state.func_177230_c() instanceof LeavesBlock ? (Integer)state.func_177229_b((Property)DISTANCE) : 7;
    }
}

