/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="croptopia", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private final ForgeConfigSpec.Builder CONFIG_BUILDER = new ForgeConfigSpec.Builder();
    public ForgeConfigSpec config;
    public static ForgeConfigSpec.ConfigValue<Boolean> rightClickHarvest;
    public static ForgeConfigSpec.ConfigValue<Boolean> disableSaltGeneration;
    public final Map<TreeConfiguration, TreeBuilder> builderMap = new HashMap<TreeConfiguration, TreeBuilder>();
    private final Multimap<ResourceLocation, String> features = HashMultimap.create();
    public static boolean canRightClickHarvest;
    public static boolean isSaltDisabled;

    public Config() {
        rightClickHarvest = this.CONFIG_BUILDER.comment("allows the user to right click harvest crops").translation("croptopia.config.rightclickharvest").define("rightClickHarvest", true);
        disableSaltGeneration = this.CONFIG_BUILDER.comment("allows the user to disable salt generation in the world, default is false").define("disableSaltGeneration", false);
        List<TreeConfiguration> trees = TreeConfiguration.init();
        this.CONFIG_BUILDER.comment("Croptopia tree generation").push("worldGeneration");
        for (TreeConfiguration tree : trees) {
            this.builderMap.put(tree, new TreeBuilder(this.CONFIG_BUILDER, tree));
        }
        this.CONFIG_BUILDER.pop();
        this.config = this.CONFIG_BUILDER.build();
    }

    @SubscribeEvent
    public void initConfig(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == this.config) {
            canRightClickHarvest = (Boolean)rightClickHarvest.get();
            isSaltDisabled = (Boolean)disableSaltGeneration.get();
            for (Map.Entry<TreeConfiguration, TreeBuilder> entry : this.builderMap.entrySet()) {
                for (String s : (List)entry.getValue().acceptableBiomes.get()) {
                    this.features.put((Object)new ResourceLocation(s), (Object)entry.getKey().featureKey);
                }
            }
        }
    }

    private static ResourceLocation bygID(String name) {
        return new ResourceLocation("byg", name);
    }

    public Map<TreeConfiguration, TreeBuilder> getBuilderMap() {
        return this.builderMap;
    }

    public Multimap<ResourceLocation, String> getFeatures() {
        return this.features;
    }

    public static class TreeConfiguration {
        String featureKey;
        List<RegistryKey<Biome>> treesInBiome;
        List<String> keys;

        public TreeConfiguration(String featureKey, List<RegistryKey<Biome>> treesInBiome) {
            this.featureKey = featureKey;
            this.treesInBiome = treesInBiome;
            this.keys = new ArrayList<String>();
            for (RegistryKey<Biome> biomeRegistryKey : treesInBiome) {
                this.keys.add(biomeRegistryKey.func_240901_a_().toString());
            }
        }

        public static void createSameTreeConfigs(SetMultimap<String, RegistryKey<Biome>> map, Collection<RegistryKey<Biome>> biomes, String ... keys) {
            for (String key : keys) {
                map.putAll((Object)key, biomes);
            }
        }

        public static List<TreeConfiguration> init() {
            List<RegistryKey<Biome>> forestBiomes = Arrays.asList(Biomes.field_76767_f, Biomes.field_76785_t, Biomes.field_185444_T);
            List<RegistryKey<Biome>> jungleBiomes = Arrays.asList(Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x);
            List<RegistryKey<Biome>> plainsKeys = Arrays.asList(Biomes.field_76772_c, Biomes.field_185441_Q);
            List<RegistryKey<Biome>> darkForestKeys = Arrays.asList(Biomes.field_150585_R, Biomes.field_185430_ab);
            HashMultimap biomes = HashMultimap.create();
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, RegistryKey<Biome>>)biomes, forestBiomes, "lime_tree_configured", "pear_tree_configured", "apricot_tree_configured", "avocado_tree_configured", "star_fruit_tree_configured", "lemon_tree_configured", "cherry_tree_configured", "plum_tree_configured", "persimmon_tree_configured", "orange_tree_configured", "nectarine_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, RegistryKey<Biome>>)biomes, jungleBiomes, "date_tree_configured", "dragon_fruit_tree_configured", "mango_tree_configured", "nutmeg_tree_configured", "coconut_tree_configured", "kumquat_tree_configured", "grapefruit_tree_configured", "banana_tree_configured", "fig_tree_configured", "cinnamon_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, RegistryKey<Biome>>)biomes, plainsKeys, "apple_tree_configured", "orange_tree_configured", "peach_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, RegistryKey<Biome>>)biomes, darkForestKeys, "almond_tree_configured", "cashew_tree_configured", "pecan_tree_configured", "walnut_tree_configured");
            RegistryKey aspenForest = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("aspen_forest"));
            RegistryKey autumnalValley = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("autumnal_valley"));
            RegistryKey bayou = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("bayou"));
            RegistryKey blackForest = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("black_forest"));
            RegistryKey canadianShield = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("canadian_shield"));
            RegistryKey cherryBlossomForest = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("cherry_blossom_forest"));
            RegistryKey cikaWoods = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("cika_woods"));
            RegistryKey coniferousForest = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("coniferous_forest"));
            RegistryKey cragGardens = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("crag_gardens"));
            RegistryKey cypressSwamplands = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("cypress_swamplands"));
            RegistryKey deadSea = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("dead_sea"));
            RegistryKey daciteRidges = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("dacite_ridges"));
            RegistryKey windsweptDunes = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("windswept_dunes"));
            RegistryKey ebonyWoods = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("ebony_woods"));
            RegistryKey forgottenForest = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("forgotten_forest"));
            RegistryKey grove = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("temperate_grove"));
            RegistryKey guianaShield = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("guiana_shield"));
            RegistryKey jacarandaForest = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("jacaranda_forest"));
            RegistryKey mapleTaiga = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("maple_taiga"));
            RegistryKey coconinoMeadow = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("coconino_meadow"));
            RegistryKey mojaveDesert = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("mojave_desert"));
            RegistryKey lushTundra = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("lush_tundra"));
            RegistryKey orchard = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("orchard"));
            RegistryKey prairie = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("prairie"));
            RegistryKey redOakForest = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("red_oak_forest"));
            RegistryKey redRockValley = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("red_rock_valley"));
            RegistryKey roseFields = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("rose_fields"));
            RegistryKey autumnalForest = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("autumnal_forest"));
            RegistryKey autumnalTaiga = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("autumnal_taiga"));
            RegistryKey shatteredGlacier = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("shattered_glacier"));
            RegistryKey firecrackerShrubland = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("firecracker_shrubland"));
            RegistryKey sierraBadlands = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("sierra_badlands"));
            RegistryKey skyrisVale = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("skyris_vale"));
            RegistryKey redwoodThicket = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("redwood_thicket"));
            RegistryKey frostedTaiga = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("frosted_taiga"));
            RegistryKey frostedConiferousForest = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("frosted_coniferous_forest"));
            RegistryKey fragmentForest = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("fragment_forest"));
            RegistryKey tropicalIsland = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("tropical_islands"));
            RegistryKey tropicalRainforest = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("tropical_rainforest"));
            RegistryKey twilightMeadow = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("twilight_meadow"));
            RegistryKey weepingWitchForest = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("weeping_witch_forest"));
            RegistryKey whiteMangroveMarshes = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("white_mangrove_marshes"));
            RegistryKey temperateRainforest = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("temperate_rainforest"));
            RegistryKey zelkovaForest = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Config.bygID("zelkova_forest"));
            List<RegistryKey<Biome>> bygWoods = Arrays.asList(aspenForest, orchard, redOakForest);
            List<RegistryKey<Biome>> cherry = Arrays.asList(cherryBlossomForest);
            List<RegistryKey<Biome>> nutty = Arrays.asList(weepingWitchForest, daciteRidges, ebonyWoods, mapleTaiga, twilightMeadow);
            List<RegistryKey<Biome>> jungleByg = Arrays.asList(cragGardens, tropicalIsland, tropicalRainforest);
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, RegistryKey<Biome>>)biomes, Collections.singleton(prairie), "apple_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, RegistryKey<Biome>>)biomes, Arrays.asList(jacarandaForest, autumnalForest, autumnalTaiga), "pear_tree_configured", "persimmon_tree_configured", "plum_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, RegistryKey<Biome>>)biomes, Arrays.asList(cypressSwamplands, whiteMangroveMarshes, temperateRainforest), "cinnamon_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, RegistryKey<Biome>>)biomes, jungleByg, "date_tree_configured", "dragon_fruit_tree_configured", "mango_tree_configured", "nutmeg_tree_configured", "coconut_tree_configured", "kumquat_tree_configured", "grapefruit_tree_configured", "banana_tree_configured", "fig_tree_configured", "cinnamon_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, RegistryKey<Biome>>)biomes, nutty, "almond_tree_configured", "cashew_tree_configured", "pecan_tree_configured", "walnut_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, RegistryKey<Biome>>)biomes, cherry, "cherry_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, RegistryKey<Biome>>)biomes, bygWoods, "lime_tree_configured", "pear_tree_configured", "apricot_tree_configured", "avocado_tree_configured", "star_fruit_tree_configured", "lemon_tree_configured", "cherry_tree_configured", "plum_tree_configured", "persimmon_tree_configured", "orange_tree_configured", "nectarine_tree_configured");
            ArrayList<TreeConfiguration> allTreeConfigs = new ArrayList<TreeConfiguration>();
            for (Map.Entry entry : biomes.asMap().entrySet()) {
                allTreeConfigs.add(new TreeConfiguration((String)entry.getKey(), new ArrayList<RegistryKey<Biome>>((Collection)entry.getValue())));
            }
            return allTreeConfigs;
        }
    }

    public static class TreeBuilder {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> acceptableBiomes;

        private TreeBuilder(ForgeConfigSpec.Builder builder, TreeConfiguration configuration) {
            this.acceptableBiomes = builder.comment("Settings for " + configuration.featureKey).push(configuration.featureKey).defineList("biomes", configuration.keys, o -> true);
            builder.pop();
        }
    }

    public static class CropConfiguration {
        String seed;
        List<String> biomes;

        public CropConfiguration(String seed, List<String> biomes) {
            this.seed = seed;
            this.biomes = biomes;
        }

        public static void init() {
        }
    }

    public static class CropBuilder {
    }
}

