/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.loot;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import org.antlr.v4.runtime.misc.NotNull;

public class AdditionalTableModifier
extends LootModifier {
    private String tableID;
    private final TableLootEntry reference;
    private final float chanceToRefer;

    protected AdditionalTableModifier(ILootCondition[] conditionsIn, TableLootEntry reference, String tableID, float chanceToRefer) {
        super(conditionsIn);
        this.chanceToRefer = chanceToRefer;
        this.tableID = tableID;
        this.reference = reference;
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (context.func_216032_b().nextFloat() <= this.chanceToRefer) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            this.reference.func_216154_a(items::add, context);
            return items;
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AdditionalTableModifier> {
        public AdditionalTableModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
            String tableID = JSONUtils.func_151200_h((JsonObject)object, (String)"tableRef");
            TableLootEntry reference = (TableLootEntry)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(tableID)).func_216081_b();
            float referChance = JSONUtils.func_151217_k((JsonObject)object, (String)"referChance");
            return new AdditionalTableModifier(ailootcondition, reference, tableID, referChance);
        }

        public JsonObject write(AdditionalTableModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            object.addProperty("tableRef", instance.tableID);
            object.addProperty("referChance", (Number)Float.valueOf(instance.chanceToRefer));
            return object;
        }
    }
}

