/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.loot;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.BinomialRange;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.antlr.v4.runtime.misc.NotNull;

public class EntityModifier
extends LootModifier {
    private final LootPool pool;
    private final Item item;
    private final int weight;
    private final int min;
    private final int max;

    protected EntityModifier(ILootCondition[] conditionsIn, Item item, int weight, int min, int max) {
        super(conditionsIn);
        this.item = item;
        this.weight = weight;
        this.min = min;
        this.max = max;
        LootPool.Builder builder = LootPool.func_216096_a();
        builder.func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1));
        builder.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item).func_216086_a(weight).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)BinomialRange.func_215838_a((int)min, (float)max))));
        this.pool = builder.func_216044_b();
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        this.pool.func_216091_a(generatedLoot::add, context);
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<EntityModifier> {
        public EntityModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151219_a((JsonObject)object, (String)"item", (String)"minecraft:air")));
            int weight = JSONUtils.func_151208_a((JsonObject)object, (String)"weight", (int)1);
            int min = JSONUtils.func_151208_a((JsonObject)object, (String)"min", (int)0);
            int max = JSONUtils.func_151208_a((JsonObject)object, (String)"max", (int)1);
            return new EntityModifier(ailootcondition, item, weight, min, max);
        }

        public JsonObject write(EntityModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

