/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.register.helpers;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.blocks.CroptopiaCropBlock;
import com.epherical.croptopia.items.CropItem;
import com.epherical.croptopia.items.SeedItem;
import com.epherical.croptopia.register.TagCategory;
import com.epherical.croptopia.util.BlockConvertible;
import com.epherical.croptopia.util.FoodConstructor;
import com.epherical.croptopia.util.ItemConvertibleWithPlural;
import com.epherical.croptopia.util.RegisterFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.biome.Biome;

public class FarmlandCrop
implements ItemConvertibleWithPlural,
BlockConvertible {
    private static final List<FarmlandCrop> FARMLAND_CROPS = new ArrayList<FarmlandCrop>();
    private final String name;
    private final String dropName;
    private final boolean plural;
    private final TagCategory tagCategory;
    private final Item cropItem;
    private final Block cropBlock;
    private final SeedItem seedItem;
    private final Biome.Category biomes;

    public FarmlandCrop(String cropName, boolean isPlural, TagCategory category, FoodConstructor registry, Biome.Category biomes) {
        this(cropName, cropName, isPlural, category, registry, biomes);
    }

    public FarmlandCrop(String cropName, String dropName, boolean isPlural, TagCategory category, FoodConstructor registry, Biome.Category biomes) {
        Objects.requireNonNull(category);
        this.name = cropName;
        this.dropName = dropName;
        this.plural = isPlural;
        this.tagCategory = category;
        this.biomes = biomes;
        this.cropItem = registry == null ? new CropItem(CroptopiaMod.createGroup()) : new CropItem(CroptopiaMod.createGroup().func_221540_a(FoodConstructor.createFood(registry)));
        this.cropBlock = new CroptopiaCropBlock(CroptopiaMod.createCropSettings());
        this.seedItem = new SeedItem(this.cropBlock, CroptopiaMod.createGroup(), biomes);
        FARMLAND_CROPS.add(this);
    }

    @Override
    public Block asBlock() {
        return this.cropBlock;
    }

    @Override
    public String name() {
        return this.dropName;
    }

    @Override
    public boolean hasPlural() {
        return this.plural;
    }

    public Item func_199767_j() {
        return this.cropItem;
    }

    public TagCategory getTagCategory() {
        return this.tagCategory;
    }

    public SeedItem getSeedItem() {
        return this.seedItem;
    }

    public static List<FarmlandCrop> copy() {
        return FARMLAND_CROPS;
    }

    public static void registerBlocks(RegisterFunction<Block> register) {
        for (FarmlandCrop farmlandCrop : FARMLAND_CROPS) {
            register.register(CroptopiaMod.createIdentifier(farmlandCrop.name + "_crop"), farmlandCrop.asBlock());
            CroptopiaMod.cropBlocks.add(farmlandCrop.asBlock());
        }
    }

    public static void registerItems(RegisterFunction<Item> register) {
        for (FarmlandCrop farmlandCrop : FARMLAND_CROPS) {
            register.register(CroptopiaMod.createIdentifier(farmlandCrop.dropName), farmlandCrop.func_199767_j());
            if (farmlandCrop.name().equals("vanilla")) {
                register.register(CroptopiaMod.createIdentifier(farmlandCrop.name + "_seeds"), (Item)farmlandCrop.seedItem);
            } else {
                register.register(CroptopiaMod.createIdentifier(farmlandCrop.name + "_seed"), (Item)farmlandCrop.seedItem);
            }
            CroptopiaMod.cropItems.add(farmlandCrop.func_199767_j());
            CroptopiaMod.seeds.add(farmlandCrop.seedItem);
        }
    }
}

