/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.register.helpers;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.blocks.CroptopiaSaplingBlock;
import com.epherical.croptopia.generator.CroptopiaSaplingGenerator;
import com.epherical.croptopia.register.TagCategory;
import com.epherical.croptopia.util.BlockConvertible;
import com.epherical.croptopia.util.ItemConvertibleWithPlural;
import com.epherical.croptopia.util.RegisterFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;

public class Tree
implements ItemConvertibleWithPlural,
BlockConvertible {
    private static final List<Tree> TREES = new ArrayList<Tree>();
    private final String name;
    private final boolean hasPlural;
    private final TagCategory tagCategory;
    private final Item item;
    private Block log;
    private Block strippedLog;
    private Block wood;
    private Block strippedWood;
    private Block leaves;
    private final Item sapling;
    private Block saplingBlock;

    public Tree(String name, boolean hasPlural, TagCategory category, Supplier<ConfiguredFeature<BaseTreeFeatureConfig, ?>> supplier) {
        Objects.requireNonNull(category);
        this.hasPlural = hasPlural;
        this.tagCategory = category;
        this.name = name;
        this.item = new Item(CroptopiaMod.createGroup());
        this.log = new RotatedPillarBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151650_B).func_200947_a(SoundType.field_185848_a).func_200943_b(2.0f));
        this.strippedLog = new RotatedPillarBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151650_B).func_200947_a(SoundType.field_185848_a).func_200943_b(2.0f));
        this.wood = new RotatedPillarBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151650_B).func_200947_a(SoundType.field_185848_a).func_200943_b(2.0f));
        this.strippedWood = new RotatedPillarBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151650_B).func_200947_a(SoundType.field_185848_a).func_200943_b(2.0f));
        this.leaves = CroptopiaMod.createRegularLeavesBlock();
        this.saplingBlock = new CroptopiaSaplingBlock(new CroptopiaSaplingGenerator(supplier), CroptopiaMod.createSaplingSettings());
        this.sapling = new BlockNamedItem(this.saplingBlock, CroptopiaMod.createGroup());
        TREES.add(this);
    }

    @Override
    public boolean hasPlural() {
        return this.hasPlural;
    }

    public TagCategory getTagCategory() {
        return this.tagCategory;
    }

    public Item func_199767_j() {
        return this.item;
    }

    @Override
    public Block asBlock() {
        return this.log;
    }

    public Block getLog() {
        return this.log;
    }

    public Block getStrippedLog() {
        return this.strippedLog;
    }

    public Block getWood() {
        return this.wood;
    }

    public Block getStrippedWood() {
        return this.strippedWood;
    }

    public Block getLeaves() {
        return this.leaves;
    }

    public Item getSapling() {
        return this.sapling;
    }

    public Block getSaplingBlock() {
        return this.saplingBlock;
    }

    @Override
    public String name() {
        return this.name;
    }

    public static List<Tree> copy() {
        return TREES;
    }

    public static void registerBlocks(RegisterFunction<Block> register) {
        for (Tree tree : TREES) {
            tree.log = register.register(CroptopiaMod.createIdentifier(tree.name + "_log"), tree.log);
            tree.strippedLog = register.register(CroptopiaMod.createIdentifier("stripped_" + tree.name + "_log"), tree.strippedLog);
            tree.wood = register.register(CroptopiaMod.createIdentifier(tree.name + "_wood"), tree.wood);
            tree.strippedWood = register.register(CroptopiaMod.createIdentifier("stripped_" + tree.name + "_wood"), tree.strippedWood);
            tree.leaves = register.register(CroptopiaMod.createIdentifier(tree.name + "_leaves"), tree.leaves);
            CroptopiaMod.leafBlocks.add(tree.leaves);
            tree.saplingBlock = register.register(CroptopiaMod.createIdentifier(tree.name + "_sapling"), tree.saplingBlock);
            CroptopiaMod.cropBlocks.add(tree.saplingBlock);
        }
    }

    public static void registerItems(RegisterFunction<Item> register) {
        for (Tree tree : TREES) {
            register.register(CroptopiaMod.createIdentifier(tree.name), tree.item);
            register.register(CroptopiaMod.createIdentifier(tree.name + "_log"), (Item)new BlockNamedItem(tree.log, CroptopiaMod.createGroup()));
            register.register(CroptopiaMod.createIdentifier("stripped_" + tree.name + "_log"), (Item)new BlockNamedItem(tree.strippedLog, CroptopiaMod.createGroup()));
            register.register(CroptopiaMod.createIdentifier(tree.name + "_wood"), (Item)new BlockNamedItem(tree.wood, CroptopiaMod.createGroup()));
            register.register(CroptopiaMod.createIdentifier("stripped_" + tree.name + "_wood"), (Item)new BlockNamedItem(tree.strippedWood, CroptopiaMod.createGroup()));
            register.register(CroptopiaMod.createIdentifier(tree.name + "_sapling"), tree.sapling);
        }
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> createBarkGen(int i, int j, int k, Block log, Block leaves) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log.func_176223_P()), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(leaves.func_176223_P(), 90), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(i, j, k), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 2)).func_236700_a_().func_225568_b_());
    }

    public static void attemptPop(BlockState state, ItemUseContext context, BlockPos pos) {
        for (Tree crop : TREES) {
            if (!state.func_177230_c().equals(crop.getLog()) && !state.func_177230_c().equals(crop.getWood())) continue;
            Block.func_180635_a((World)context.func_195991_k(), (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)crop.func_199767_j()));
        }
    }
}

