/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.register.helpers;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.blocks.CroptopiaSaplingBlock;
import com.epherical.croptopia.generator.CroptopiaSaplingGenerator;
import com.epherical.croptopia.items.CropItem;
import com.epherical.croptopia.items.CroptopiaSaplingItem;
import com.epherical.croptopia.register.TagCategory;
import com.epherical.croptopia.util.BlockConvertible;
import com.epherical.croptopia.util.FoodConstructor;
import com.epherical.croptopia.util.ItemConvertibleWithPlural;
import com.epherical.croptopia.util.RegisterFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;

public class TreeCrop
implements ItemConvertibleWithPlural,
BlockConvertible {
    private static final List<TreeCrop> TREE_CROPS = new ArrayList<TreeCrop>();
    private final String name;
    private final boolean isPlural;
    private final TagCategory category;
    private final Item item;
    private final Block leaves;
    private final CroptopiaSaplingItem saplingItem;
    private final CroptopiaSaplingBlock saplingBlock;

    public TreeCrop(String name, boolean plural, Block logType, Block leafType, TagCategory category, FoodConstructor constructor, Supplier<ConfiguredFeature<BaseTreeFeatureConfig, ?>> tree) {
        Objects.requireNonNull(leafType);
        Objects.requireNonNull(category);
        Objects.requireNonNull(logType);
        this.name = name;
        this.isPlural = plural;
        this.category = category;
        this.item = constructor == null ? Items.field_151034_e : new CropItem(CroptopiaMod.createGroup().func_221540_a(FoodConstructor.createFood(constructor)));
        this.leaves = CroptopiaMod.createLeavesBlock();
        this.saplingBlock = new CroptopiaSaplingBlock(new CroptopiaSaplingGenerator(tree), CroptopiaMod.createSaplingSettings());
        this.saplingItem = new CroptopiaSaplingItem((Block)this.saplingBlock, this.leaves, leafType, CroptopiaMod.createGroup());
        TREE_CROPS.add(this);
    }

    @Override
    public Block asBlock() {
        return this.leaves;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean hasPlural() {
        return this.isPlural;
    }

    public Item func_199767_j() {
        return this.item;
    }

    public CroptopiaSaplingBlock getSaplingBlock() {
        return this.saplingBlock;
    }

    public CroptopiaSaplingItem getSaplingItem() {
        return this.saplingItem;
    }

    public Block getLeaves() {
        return this.leaves;
    }

    public TagCategory getTagCategory() {
        return this.category;
    }

    public static List<TreeCrop> copy() {
        return TREE_CROPS;
    }

    public static void registerBlocks(RegisterFunction<Block> register) {
        for (TreeCrop treeCrop : TREE_CROPS) {
            register.register(CroptopiaMod.createIdentifier(treeCrop.name() + "_crop"), treeCrop.asBlock());
            CroptopiaMod.cropBlocks.add(treeCrop.asBlock());
            CroptopiaMod.cropBlocks.add((Block)treeCrop.saplingBlock);
            CroptopiaMod.leafBlocks.add(treeCrop.asBlock());
            register.register(CroptopiaMod.createIdentifier(treeCrop.name() + "_sapling"), (Block)treeCrop.getSaplingBlock());
        }
    }

    public static void registerItems(RegisterFunction<Item> register) {
        for (TreeCrop treeCrop : TREE_CROPS) {
            if (!Objects.equals(treeCrop.name(), "apple")) {
                register.register(CroptopiaMod.createIdentifier(treeCrop.name()), treeCrop.func_199767_j());
                CroptopiaMod.cropItems.add(treeCrop.func_199767_j());
            }
            register.register(CroptopiaMod.createIdentifier(treeCrop.name() + "_sapling"), (Item)treeCrop.getSaplingItem());
        }
    }
}

