/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.theme.Theme;

public final class PillarGenerator {
    public static void generateFancyPillar(IWorld world, BlockPos center, Random random, MutableBoundingBox worldGenBounds, Theme primaryTheme) {
        BlockPos west;
        BlockPos south;
        BlockPos east;
        BlockPos north;
        if (worldGenBounds.func_175898_b((Vector3i)center)) {
            PillarGenerator.generateSimplePillar(world, center, primaryTheme, random);
        }
        if (world.func_217354_b((north = center.func_177978_c()).func_177958_n() >> 4, north.func_177952_p() >> 4)) {
            PillarGenerator.placeTopStair(world, north, Direction.SOUTH, primaryTheme, random);
        }
        if (world.func_217354_b((east = center.func_177974_f()).func_177958_n() >> 4, east.func_177952_p() >> 4)) {
            PillarGenerator.placeTopStair(world, east, Direction.WEST, primaryTheme, random);
        }
        if (world.func_217354_b((south = center.func_177968_d()).func_177958_n() >> 4, south.func_177952_p() >> 4)) {
            PillarGenerator.placeTopStair(world, south, Direction.NORTH, primaryTheme, random);
        }
        if (world.func_217354_b((west = center.func_177976_e()).func_177958_n() >> 4, west.func_177952_p() >> 4)) {
            PillarGenerator.placeTopStair(world, west, Direction.EAST, primaryTheme, random);
        }
    }

    private static void placeTopStair(IWorld world, BlockPos pos, Direction toCenter, Theme primaryTheme, Random random) {
        if (world.func_175623_d(pos) && world.func_180495_p(pos.func_177984_a()).func_200132_m()) {
            BlockState stair = DungeonBlocks.applyProperty(primaryTheme.solidStairs.get(world, pos, random), BlockStateProperties.field_208157_J, toCenter);
            stair = DungeonBlocks.applyProperty(stair, BlockStateProperties.field_208164_Q, Half.TOP);
            world.func_180501_a(pos, stair, 2);
        }
    }

    public static void generateSimplePillar(IWorld world, BlockPos pos, Theme primaryTheme, Random random) {
        while (pos.func_177956_o() > 0) {
            if (world.func_180495_p(pos).func_200132_m()) {
                return;
            }
            world.func_180501_a(pos, primaryTheme.solid.get(world, pos, random), 2);
            pos = pos.func_177977_b();
        }
    }
}

