/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.dungeons_arise.structures.prairie;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.aurelj.dungeons_arise.DungeonsAriseMain;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class IllagerWindmillStructure
extends Structure<NoFeatureConfig> {
    public IllagerWindmillStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        BlockPos centerOfChunk = new BlockPos((chunkX << 4) + 7, 0, (chunkZ << 4) + 7);
        int landHeight = chunkGenerator.func_222531_c(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
        IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p());
        BlockState topBlock = columnOfBlocks.func_180495_p(centerOfChunk.func_177981_b(landHeight));
        return !(!topBlock.func_204520_s().func_206888_e() || centerOfChunk.func_177958_n() <= DungeonsAriseMain.WDAConfig.illagerWindmillSpawnpointSeparation.get() && centerOfChunk.func_177958_n() >= -DungeonsAriseMain.WDAConfig.illagerWindmillSpawnpointSeparation.get().intValue() || centerOfChunk.func_177952_p() <= DungeonsAriseMain.WDAConfig.illagerWindmillSpawnpointSeparation.get() && centerOfChunk.func_177952_p() >= -DungeonsAriseMain.WDAConfig.illagerWindmillSpawnpointSeparation.get().intValue() || this.isNearVillage(chunkGenerator, seed, chunkRandom, chunkX, chunkZ));
    }

    private boolean isNearVillage(ChunkGenerator p_242782_1_, long p_242782_2_, SharedSeedRandom p_242782_4_, int p_242782_5_, int p_242782_6_) {
        StructureSeparationSettings structureseparationsettings = p_242782_1_.func_235957_b_().func_236197_a_(Structure.field_236381_q_);
        if (structureseparationsettings == null) {
            return false;
        }
        for (int i = p_242782_5_ - 10; i <= p_242782_5_ + 10; ++i) {
            for (int j = p_242782_6_ - 10; j <= p_242782_6_ + 10; ++j) {
                ChunkPos chunkpos = Structure.field_236381_q_.func_236392_a_(structureseparationsettings, p_242782_2_, p_242782_4_, i, j);
                if (i != chunkpos.field_77276_a || j != chunkpos.field_77275_b) continue;
                return true;
            }
        }
        return false;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            BlockPos blockpos = new BlockPos(x, 0, z);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(new ResourceLocation("dungeons_arise", "prairie/illager_windmill/illager_windmill_start")), DungeonsAriseMain.WDAConfig.illagerWindmillSize.get().intValue()), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManagerIn, (BlockPos)blockpos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)true, (boolean)true);
            this.field_75075_a.forEach(piece -> piece.func_181138_a(0, -6, 0));
            this.func_202500_a();
        }
    }
}

