/*
 * Decompiled with CFR 0.152.
 */
package com.electron.endreborn.items.relic;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class UpgradableAxeItem
extends AxeItem {
    private final int sharpness;
    private final int flexibility;

    public UpgradableAxeItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, int sharpness, int flexibility, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.sharpness = sharpness;
        this.flexibility = flexibility;
    }

    public float getSharpness() {
        return this.sharpness;
    }

    public float getFlexibility() {
        return this.flexibility;
    }

    public ITextComponent func_200295_i(ItemStack p_200295_1_) {
        return new TranslationTextComponent("item.endreborn.endorium_axe");
    }

    public ActionResultType func_195939_a(ItemUseContext p_195939_1_) {
        BlockPos blockpos;
        World world = p_195939_1_.func_195991_k();
        BlockState blockstate = world.func_180495_p(blockpos = p_195939_1_.func_195995_a());
        BlockState block = blockstate.getToolModifiedState(world, blockpos, p_195939_1_.func_195999_j(), p_195939_1_.func_195996_i(), ToolType.AXE);
        if (block != null) {
            PlayerEntity playerentity = p_195939_1_.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, block, 11);
                if (playerentity != null) {
                    p_195939_1_.func_195996_i().func_222118_a(1 - this.sharpness, (LivingEntity)playerentity, p_220040_1_ -> p_220040_1_.func_213334_d(p_195939_1_.func_221531_n()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relic").func_240699_a_(TextFormatting.GRAY));
        if (this.sharpness > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.axe_sharpness").func_240699_a_(TextFormatting.DARK_GRAY));
        } else if (this.flexibility > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.uni_flexibility").func_240699_a_(TextFormatting.DARK_GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.uni_flexibility_n").func_240699_a_(TextFormatting.DARK_GRAY));
        }
    }

    public boolean func_77644_a(ItemStack p_77644_1_, LivingEntity p_77644_2_, LivingEntity p_77644_3_) {
        p_77644_1_.func_222118_a(2 + this.flexibility, p_77644_3_, p_220039_0_ -> p_220039_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }
}

