/*
 * Decompiled with CFR 0.152.
 */
package com.electron.endreborn.items.relic;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class UpgradablePickaxeItem
extends PickaxeItem {
    private final int sharpness;
    private final int flexibility;

    public UpgradablePickaxeItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, int sharpness, int flexibility, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.sharpness = sharpness;
        this.flexibility = flexibility;
    }

    public float getSharpness() {
        return this.sharpness;
    }

    public float getFlexibility() {
        return this.flexibility;
    }

    public ITextComponent func_200295_i(ItemStack p_200295_1_) {
        return new TranslationTextComponent("item.endreborn.endorium_pickaxe");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relic").func_240699_a_(TextFormatting.GRAY));
        if (this.sharpness > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pickaxe_sharpness").func_240699_a_(TextFormatting.DARK_GRAY));
        } else if (this.flexibility > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.uni_flexibility").func_240699_a_(TextFormatting.DARK_GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.uni_flexibility_n").func_240699_a_(TextFormatting.DARK_GRAY));
        }
    }

    public boolean func_77644_a(ItemStack p_77644_1_, LivingEntity p_77644_2_, LivingEntity p_77644_3_) {
        p_77644_1_.func_222118_a(2 + this.flexibility, p_77644_3_, p_220039_0_ -> p_220039_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_150897_b(BlockState blockIn) {
        Material material = blockIn.func_185904_a();
        int i = this.func_200891_e().func_200925_d();
        if (blockIn.getHarvestTool() == ToolType.PICKAXE) {
            return i >= blockIn.getHarvestLevel();
        }
        if (this.sharpness > 0 && (blockIn.getHarvestTool() == ToolType.PICKAXE || blockIn.getHarvestTool() == ToolType.SHOVEL)) {
            return i >= blockIn.getHarvestLevel();
        }
        return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        if (this.sharpness > 0) {
            return material != Material.field_151573_f && material != Material.field_151574_g && material != Material.field_151576_e && material != Material.field_151595_p ? super.func_150893_a(stack, state) : this.field_77864_a;
        }
        return material != Material.field_151573_f && material != Material.field_151574_g && material != Material.field_151576_e ? super.func_150893_a(stack, state) : this.field_77864_a;
    }
}

