/*
 * Decompiled with CFR 0.152.
 */
package com.electron.endreborn.items.relic;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UpgradableSwordItem
extends SwordItem {
    private final int sharpness;
    private final int flexibility;

    public UpgradableSwordItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, int sharpness, int flexibility, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.sharpness = sharpness;
        this.flexibility = flexibility;
    }

    public float getSharpness() {
        return this.sharpness;
    }

    public float getFlexibility() {
        return this.flexibility;
    }

    public ITextComponent func_200295_i(ItemStack p_200295_1_) {
        return new TranslationTextComponent("item.endreborn.endorium_sword");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relic").func_240699_a_(TextFormatting.GRAY));
        if (this.sharpness > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.sword_sharpness").func_240699_a_(TextFormatting.DARK_GRAY));
        } else if (this.flexibility > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.sword_flexibility").func_240699_a_(TextFormatting.DARK_GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.sword_flexibility_n").func_240699_a_(TextFormatting.DARK_GRAY));
        }
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (state.func_203425_a(Blocks.field_196553_aF)) {
            return 15 + this.sharpness * 5;
        }
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && !state.func_235714_a_((ITag)BlockTags.field_206952_E) && material != Material.field_151578_c ? 1.0f : 1.5f + (float)this.sharpness;
    }

    public boolean func_77644_a(ItemStack p_77644_1_, LivingEntity p_77644_2_, LivingEntity p_77644_3_) {
        p_77644_1_.func_222118_a(1 + this.flexibility, p_77644_3_, p_220039_0_ -> p_220039_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack p_179218_1_, World p_179218_2_, BlockState p_179218_3_, BlockPos p_179218_4_, LivingEntity p_179218_5_) {
        if (p_179218_3_.func_185887_b((IBlockReader)p_179218_2_, p_179218_4_) != 0.0f) {
            p_179218_1_.func_222118_a(2 - this.flexibility, p_179218_5_, p_220044_0_ -> p_220044_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return blockIn.func_203425_a(Blocks.field_196553_aF);
    }
}

