/*
 * Decompiled with CFR 0.152.
 */
package com.electron.endreborn.mobs;

import com.electron.endreborn.mobs.EndormanMob;
import com.electron.endreborn.mobs.HeldBlockNewLayer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.EndermanEyesLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EndermanModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;

@OnlyIn(value=Dist.CLIENT)
public class EndormanRenderer
extends MobRenderer<EndormanMob, EndermanModel<EndormanMob>> {
    private static final ResourceLocation ENDERMAN_TEXTURES = new ResourceLocation("textures/entity/enderman/enderman.png");
    private final Random rnd = new Random();

    public EndormanRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new EndermanModel(0.0f), 0.5f);
        this.func_177094_a((LayerRenderer)new EndermanEyesLayer((IEntityRenderer)this));
        this.func_177094_a(new HeldBlockNewLayer((IEntityRenderer<EndormanMob, EndermanModel<EndormanMob>>)this));
    }

    public void render(EndormanMob entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        BlockState blockstate = entityIn.getHeldBlockState();
        int i = entityIn.getEndorSize();
        float f = 1.0f + 0.1f * (float)i - 0.1f;
        matrixStackIn.func_227862_a_(f, f, f);
        EndermanModel endermanmodel = (EndermanModel)this.func_217764_d();
        endermanmodel.field_78126_a = blockstate != null;
        endermanmodel.field_78125_b = entityIn.isScreaming();
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public Vector3d getRenderOffset(EndormanMob p_225627_1_, float p_225627_2_) {
        if (p_225627_1_.isScreaming()) {
            double lvt_3_1_ = 0.02;
            return new Vector3d(this.rnd.nextGaussian() * 0.02, 0.0, this.rnd.nextGaussian() * 0.02);
        }
        return super.func_225627_b_((Entity)p_225627_1_, p_225627_2_);
    }

    public ResourceLocation getTextureLocation(EndormanMob entity) {
        return ENDERMAN_TEXTURES;
    }

    public static class RenderFactory
    implements IRenderFactory<EndormanMob> {
        public EntityRenderer<? super EndormanMob> createRenderFor(EntityRendererManager manager) {
            return new EndormanRenderer(manager);
        }
    }
}

