/*
 * Decompiled with CFR 0.152.
 */
package com.electron.endreborn.world;

import com.electron.endreborn.ModConfigs;
import com.electron.endreborn.world.NatureFeatures;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class NatureGen {
    @SubscribeEvent
    public static void registerAll(RegistryEvent.Register<Feature<?>> event) {
        if (!event.getName().equals((Object)ForgeRegistries.FEATURES.getRegistryName())) {
            return;
        }
        NatureGen.registerGen(NatureFeatures.OBSIDIAN_ORE_CONFIG, "obsidian_ore");
        NatureGen.registerGen(NatureFeatures.END_DECORATOR_CONFIG, "end_decorator");
        NatureGen.registerGen(NatureFeatures.XORCITE_CONFIG, "xorcite");
        NatureGen.registerGen(NatureFeatures.TUNGSTEN_CONFIG, "tungsten");
        NatureGen.registerGen(NatureFeatures.TUNGSTEN_END_CONFIG, "tungsten_end");
    }

    public static Feature<?> registerGen(Feature<?> feature, String name) {
        feature.setRegistryName(new ResourceLocation("endreborn", name));
        ForgeRegistries.FEATURES.register(feature);
        return feature;
    }

    public static void addStructures(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.THEEND) {
            ModConfigs.CommonConfig.Balance cfr_ignored_0 = ModConfigs.COMMON.balance;
            if (((Boolean)ModConfigs.CommonConfig.Balance.end_shipwreck.get()).booleanValue()) {
                event.getGeneration().getStructures().add(NatureFeatures.CONFIGURED_END_SHIPWRECK);
            }
            ModConfigs.CommonConfig.Balance cfr_ignored_1 = ModConfigs.COMMON.balance;
            if (((Boolean)ModConfigs.CommonConfig.Balance.end_crypt.get()).booleanValue()) {
                event.getGeneration().getStructures().add(NatureFeatures.CONFIGURED_END_CRYPT);
            }
        }
    }

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        if (event.getCategory() == Biome.Category.THEEND) {
            NatureGen.addSecondFeature(generation, NatureFeatures.OBSIDIAN_ORE_FEATURE);
            NatureGen.addSecondFeature(generation, NatureFeatures.END_DECORATOR_FEATURE);
            ModConfigs.CommonConfig.Balance cfr_ignored_0 = ModConfigs.COMMON.balance;
            if (((Boolean)ModConfigs.CommonConfig.Balance.end_coral.get()).booleanValue()) {
                NatureGen.addSecondFeature(generation, NatureFeatures.CITY_DECORATOR_FEATURE);
            }
            ModConfigs.CommonConfig.Balance cfr_ignored_1 = ModConfigs.COMMON.balance;
            if (((Boolean)ModConfigs.CommonConfig.Balance.end_coral.get()).booleanValue()) {
                NatureGen.addSecondFeature(generation, NatureFeatures.END_CORAL_FEATURE);
            }
            NatureGen.addSecondFeature(generation, NatureFeatures.XORCITE_FEATURE);
            NatureGen.addSecondFeature(generation, NatureFeatures.OGANA_FEATURE);
            NatureGen.addFirstFeature(generation, NatureFeatures.TUNGSTEN_END_FEATURE);
        }
        if (event.getCategory() == Biome.Category.FOREST) {
            NatureGen.addSecondFeature(generation, NatureFeatures.DRAGONITE_FEATURE);
        }
        if (event.getCategory() == Biome.Category.EXTREME_HILLS) {
            NatureGen.addFirstFeature(generation, NatureFeatures.TUNGSTEN_FEATURE);
        }
    }

    private static void addFirstFeature(BiomeGenerationSettingsBuilder generation, @Nullable ConfiguredFeature<?, ?> feature) {
        if (feature != null) {
            generation.func_242513_a(GenerationStage.Decoration.RAW_GENERATION, feature);
        }
    }

    private static void addSecondFeature(BiomeGenerationSettingsBuilder generation, @Nullable ConfiguredFeature<?, ?> feature) {
        if (feature != null) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, feature);
        }
    }
}

