/*
 * Decompiled with CFR 0.152.
 */
package com.electron.endreborn.world;

import com.electron.endreborn.world.EndCryptStructure;
import com.electron.endreborn.world.EndShipwreckStructure;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class NatureStructures {
    public static final DeferredRegister<Structure<?>> STRUCTURE_FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"endreborn");
    public static final RegistryObject<Structure<NoFeatureConfig>> END_SHIPWRECK = STRUCTURE_FEATURES.register("end_shipwreck", () -> new EndShipwreckStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> END_CRYPT = STRUCTURE_FEATURES.register("end_crypt", () -> new EndCryptStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void setupStructures() {
        NatureStructures.setupStructure((Structure)END_SHIPWRECK.get(), new StructureSeparationSettings(22, 1, 22620210), false);
        NatureStructures.setupStructure((Structure)END_CRYPT.get(), new StructureSeparationSettings(24, 1, 10210262), false);
    }

    public static <F extends Structure<?>> void setupStructure(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
    }

    public static void register(IEventBus modBus) {
        STRUCTURE_FEATURES.register(modBus);
    }

    public static void addDimensionSpacing(WorldEvent.Load event) {
        ServerWorld serverWorld;
        if (event.getWorld() instanceof ServerWorld && !((serverWorld = (ServerWorld)event.getWorld()).func_72863_F().func_201711_g() instanceof FlatChunkGenerator) && serverWorld.func_234923_W_().equals(World.field_234920_i_)) {
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.put(END_SHIPWRECK.get(), DimensionStructuresSettings.field_236191_b_.get((Object)END_SHIPWRECK.get()));
            tempMap.put(END_CRYPT.get(), DimensionStructuresSettings.field_236191_b_.get((Object)END_CRYPT.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

