/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootContext;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.loot.condition.ILootModifierCondition;

public class ContainsItemModifierLootCondition
implements ILootModifierCondition {
    public static final ResourceLocation ID = Mantle.getResource("contains_item");
    private final Ingredient ingredient;
    private final int amountNeeded;

    public ContainsItemModifierLootCondition(Ingredient ingredient) {
        this(ingredient, 1);
    }

    @Override
    public boolean test(List<ItemStack> generatedLoot, LootContext context) {
        int matched = 0;
        for (ItemStack stack : generatedLoot) {
            if (!this.ingredient.test(stack) || (matched += stack.func_190916_E()) < this.amountNeeded) continue;
            return true;
        }
        return false;
    }

    @Override
    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        json.add("ingredient", this.ingredient.func_200304_c());
        if (this.amountNeeded != 1) {
            json.addProperty("needed", (Number)this.amountNeeded);
        }
        return json;
    }

    public static ContainsItemModifierLootCondition deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject json = JSONUtils.func_151210_l((JsonElement)element, (String)"condition");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
        int needed = JSONUtils.func_151208_a((JsonObject)json, (String)"needed", (int)1);
        return new ContainsItemModifierLootCondition(ingredient, needed);
    }

    public ContainsItemModifierLootCondition(Ingredient ingredient, int amountNeeded) {
        this.ingredient = ingredient;
        this.amountNeeded = amountNeeded;
    }
}

