/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.util.JsonHelper;

public class IngredientIntersection
extends Ingredient {
    public static final ResourceLocation ID = Mantle.getResource("intersection");
    public static final IIngredientSerializer<IngredientIntersection> SERIALIZER = new Serializer();
    private final List<Ingredient> ingredients;
    private ItemStack[] intersectedMatchingStacks;
    private IntList packedMatchingStacks;

    public IngredientIntersection(List<Ingredient> ingredients) {
        super(Stream.empty());
        this.ingredients = ingredients;
    }

    public IngredientIntersection(Ingredient ... ingredients) {
        this((List<Ingredient>)ImmutableList.copyOf((Object[])ingredients));
    }

    public static IngredientIntersection intersection(Ingredient ... ingredients) {
        return new IngredientIntersection(ingredients);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        for (Ingredient ingredient : this.ingredients) {
            if (ingredient.test(stack)) continue;
            return false;
        }
        return true;
    }

    public ItemStack[] func_193365_a() {
        if (this.intersectedMatchingStacks == null) {
            this.intersectedMatchingStacks = this.ingredients.isEmpty() ? new ItemStack[0] : (ItemStack[])Arrays.stream(this.ingredients.get(0).func_193365_a()).filter(stack -> {
                for (int i = 1; i < this.ingredients.size(); ++i) {
                    if (this.ingredients.get(i).test(stack)) continue;
                    return false;
                }
                return true;
            }).toArray(ItemStack[]::new);
        }
        return this.intersectedMatchingStacks;
    }

    public boolean func_203189_d() {
        return this.func_193365_a().length == 0;
    }

    public boolean isSimple() {
        for (Ingredient ingredient : this.ingredients) {
            if (ingredient.isSimple()) continue;
            return false;
        }
        return true;
    }

    protected void invalidate() {
        super.invalidate();
        this.intersectedMatchingStacks = null;
        this.packedMatchingStacks = null;
    }

    public IntList func_194139_b() {
        if (this.packedMatchingStacks == null) {
            ItemStack[] matchingStacks = this.func_193365_a();
            this.packedMatchingStacks = new IntArrayList(matchingStacks.length);
            for (ItemStack stack : matchingStacks) {
                this.packedMatchingStacks.add(RecipeItemHelper.func_194113_b((ItemStack)stack));
            }
            this.packedMatchingStacks.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.packedMatchingStacks;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        JsonArray array = new JsonArray();
        for (Ingredient ingredient : this.ingredients) {
            array.add(ingredient.func_200304_c());
        }
        json.add("ingredients", (JsonElement)array);
        return json;
    }

    public IIngredientSerializer<IngredientIntersection> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements IIngredientSerializer<IngredientIntersection> {
        private Serializer() {
        }

        public IngredientIntersection parse(JsonObject json) {
            List<Ingredient> ingredients = JsonHelper.parseList(json, "ingredients", (element, name) -> Ingredient.func_199802_a((JsonElement)element));
            return new IngredientIntersection(ingredients);
        }

        public IngredientIntersection parse(PacketBuffer buffer) {
            int size = buffer.func_150792_a();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add((Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            return new IngredientIntersection((List<Ingredient>)builder.build());
        }

        public void write(PacketBuffer buffer, IngredientIntersection intersection) {
            buffer.func_150787_b(intersection.ingredients.size());
            for (Ingredient ingredient : intersection.ingredients) {
                CraftingHelper.write((PacketBuffer)buffer, (Ingredient)ingredient);
            }
        }
    }
}

