/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.item;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.tools.entity.PickarangEntity;
import vazkii.quark.content.tools.module.PickarangModule;

public class PickarangItem
extends QuarkItem {
    public final boolean isNetherite;

    public PickarangItem(String regname, QuarkModule module, Item.Properties properties, boolean isNetherite) {
        super(regname, module, properties);
        this.isNetherite = isNetherite;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(2, attacker, player -> player.func_213334_d(Hand.MAIN_HAND));
        return true;
    }

    public boolean func_150897_b(BlockState blockIn) {
        switch (this.isNetherite ? PickarangModule.netheriteHarvestLevel : PickarangModule.harvestLevel) {
            case 0: {
                return Items.field_151039_o.func_150897_b(blockIn) || Items.field_151053_p.func_150897_b(blockIn) || Items.field_151038_n.func_150897_b(blockIn);
            }
            case 1: {
                return Items.field_151050_s.func_150897_b(blockIn) || Items.field_151049_t.func_150897_b(blockIn) || Items.field_151051_r.func_150897_b(blockIn);
            }
            case 2: {
                return Items.field_151035_b.func_150897_b(blockIn) || Items.field_151036_c.func_150897_b(blockIn) || Items.field_151037_a.func_150897_b(blockIn);
            }
        }
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return Math.max(this.isNetherite ? PickarangModule.netheriteDurability : PickarangModule.durability, 0);
    }

    public int getHarvestLevel(ItemStack stack, @Nonnull ToolType type, @Nullable PlayerEntity player, @Nullable BlockState state) {
        return this.isNetherite ? PickarangModule.netheriteHarvestLevel : PickarangModule.harvestLevel;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(1, entityLiving, player -> player.func_213334_d(Hand.MAIN_HAND));
        }
        return true;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        int cooldown;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184611_a(handIn, ItemStack.field_190927_a);
        int eff = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)itemstack);
        Vector3d pos = playerIn.func_213303_ch();
        worldIn.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, QuarkSounds.ENTITY_PICKARANG_THROW, SoundCategory.NEUTRAL, 0.5f + (float)eff * 0.14f, 0.4f / (worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.field_72995_K) {
            int slot = handIn == Hand.OFF_HAND ? playerIn.field_71071_by.func_70302_i_() - 1 : playerIn.field_71071_by.field_70461_c;
            PickarangEntity entity = new PickarangEntity(worldIn, (LivingEntity)playerIn);
            entity.setThrowData(slot, itemstack, this.isNetherite);
            entity.shoot((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f + (float)eff * 0.325f, 0.0f);
            worldIn.func_217376_c((Entity)entity);
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !PickarangModule.noCooldown && (cooldown = 10 - eff) > 0) {
            playerIn.func_184811_cZ().func_185145_a((Item)this, cooldown);
        }
        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlotType slot, ItemStack stack) {
        SetMultimap multimap = Multimaps.newSetMultimap(new HashMap(), HashSet::new);
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 2.0, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.8, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return 0.0f;
    }

    public boolean isRepairable(ItemStack stack) {
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == (this.isNetherite ? Items.field_234759_km_ : Items.field_151045_i);
    }

    public int func_77619_b() {
        return this.isNetherite ? Items.field_234756_kK_.func_77619_b() : Items.field_151046_w.func_77619_b();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || ImmutableSet.of((Object)Enchantments.field_185308_t, (Object)Enchantments.field_185306_r, (Object)Enchantments.field_185305_q).contains((Object)enchantment);
    }
}

