/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.sectiontransformer.materials;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.tconstruct.library.book.sectiontransformer.materials.AbstractMaterialSectionTransformer;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

@OnlyIn(value=Dist.CLIENT)
public class TieredMaterialSectionTransformer
extends AbstractMaterialSectionTransformer {
    private static final Set<MaterialStatsId> VISIBLE_STATS = ImmutableSet.of((Object)((Object)HeadMaterialStats.ID), (Object)((Object)HandleMaterialStats.ID), (Object)((Object)ExtraMaterialStats.ID));
    private final int materialTier;

    public TieredMaterialSectionTransformer(String sectionName, int materialTier, boolean detailed) {
        super(sectionName, detailed);
        this.materialTier = materialTier;
    }

    @Override
    protected boolean isValidMaterial(IMaterial material) {
        if (material.getTier() != this.materialTier) {
            return false;
        }
        for (IMaterialStats stats : MaterialRegistry.getInstance().getAllStats(material.getIdentifier())) {
            if (!VISIBLE_STATS.contains((Object)stats.getIdentifier())) continue;
            return true;
        }
        return false;
    }
}

