/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.impl;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class InventoryModifier
extends Modifier
implements ToolInventoryCapability.IInventoryModifier {
    protected static final BiFunction<CompoundNBT, String, ListNBT> GET_COMPOUND_LIST = (nbt, name) -> nbt.func_150295_c(name, 10);
    private static final ValidatedResult HAS_ITEMS = ValidatedResult.failure(TConstruct.makeTranslationKey("modifier", "inventory_cannot_remove"), new Object[0]);
    protected static final String TAG_SLOT = "Slot";
    private final ResourceLocation inventoryKey;
    private final int slotsPerLevel;

    public InventoryModifier(int color, ResourceLocation inventoryKey, int slotsPerLevel) {
        super(color);
        this.inventoryKey = inventoryKey;
        this.slotsPerLevel = slotsPerLevel;
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        ToolInventoryCapability.addSlots(volatileData, this.getSlots(context, level));
    }

    @Override
    public ValidatedResult validate(IModifierToolStack tool, int level) {
        ListNBT listNBT;
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(this.inventoryKey, 9) && !(listNBT = persistentData.get(this.inventoryKey, GET_COMPOUND_LIST)).isEmpty()) {
            if (level == 0) {
                return HAS_ITEMS;
            }
            int maxSlots = this.getSlots(tool, level);
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundNBT compoundNBT = listNBT.func_150305_b(i);
                if (compoundNBT.func_74762_e(TAG_SLOT) < maxSlots) continue;
                return HAS_ITEMS;
            }
        }
        return ValidatedResult.PASS;
    }

    @Override
    public void onRemoved(IModifierToolStack tool) {
        tool.getPersistentData().remove(this.inventoryKey);
    }

    @Override
    public ItemStack getStack(IModifierToolStack tool, int level, int slot) {
        ModDataNBT modData = tool.getPersistentData();
        if (slot < this.getSlots(tool, level) && modData.contains(this.inventoryKey, 9)) {
            ListNBT list = tool.getPersistentData().get(this.inventoryKey, GET_COMPOUND_LIST);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT compound = list.func_150305_b(i);
                if (compound.func_74762_e(TAG_SLOT) != slot) continue;
                return ItemStack.func_199557_a((CompoundNBT)compound);
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void setStack(IModifierToolStack tool, int level, int slot, ItemStack stack) {
        if (slot < this.getSlots(tool, level)) {
            ListNBT list;
            ModDataNBT modData = tool.getPersistentData();
            if (modData.contains(this.inventoryKey, 9)) {
                list = modData.get(this.inventoryKey, GET_COMPOUND_LIST);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundNBT compound = list.func_150305_b(i);
                    if (compound.func_74762_e(TAG_SLOT) != slot) continue;
                    if (stack.func_190926_b()) {
                        list.remove(i);
                    } else {
                        compound.func_150296_c().clear();
                        stack.func_77955_b(compound);
                        compound.func_74768_a(TAG_SLOT, slot);
                    }
                    return;
                }
            } else {
                if (stack.func_190926_b()) {
                    return;
                }
                list = new ListNBT();
                modData.put(this.inventoryKey, (INBT)list);
            }
            if (!stack.func_190926_b()) {
                list.add((Object)InventoryModifier.write(stack, slot));
            }
        }
    }

    public int getSlots(IToolContext tool, int level) {
        return level * this.slotsPerLevel;
    }

    @Override
    public final int getSlots(IModifierToolStack tool, int level) {
        return this.getSlots((IToolContext)tool, level);
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        return InventoryModifier.tryModuleMatch(type, ToolInventoryCapability.IInventoryModifier.class, this);
    }

    protected static CompoundNBT write(ItemStack stack, int slot) {
        CompoundNBT compound = new CompoundNBT();
        stack.func_77955_b(compound);
        compound.func_74768_a(TAG_SLOT, slot);
        return compound;
    }
}

