/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public class TagPredicate
implements Predicate<CompoundNBT> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final TagPredicate ANY = new TagPredicate(null);
    @Nullable
    private final CompoundNBT tag;

    @Override
    public boolean test(@Nullable CompoundNBT toTest) {
        return NBTUtil.func_181123_a((INBT)this.tag, (INBT)toTest, (boolean)true);
    }

    public JsonElement serialize() {
        if (this.tag == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(this.tag.toString());
    }

    public void write(PacketBuffer buffer) {
        if (this.tag != null) {
            buffer.writeBoolean(true);
            buffer.func_150786_a(this.tag);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static TagPredicate deserialize(JsonElement element) {
        if (!element.isJsonNull()) {
            try {
                CompoundNBT nbt = element.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(element)) : JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)element, (String)"predicate"));
                return new TagPredicate(nbt);
            }
            catch (CommandSyntaxException ex) {
                throw new JsonSyntaxException("Invalid nbt tag: ", (Throwable)ex);
            }
        }
        return ANY;
    }

    public static TagPredicate read(PacketBuffer buffer) {
        CompoundNBT tag = null;
        if (buffer.readBoolean()) {
            tag = buffer.func_150793_b();
        }
        return new TagPredicate(tag);
    }

    public TagPredicate(@Nullable CompoundNBT tag) {
        this.tag = tag;
    }
}

