/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.context;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.Hand;
import slimeknights.tconstruct.library.utils.Util;

public class ToolAttackContext {
    @Nonnull
    private final LivingEntity attacker;
    @Nullable
    private final PlayerEntity playerAttacker;
    @Nonnull
    private final Hand hand;
    @Nonnull
    private final EquipmentSlotType slotType;
    @Nonnull
    private final Entity target;
    @Nullable
    private final LivingEntity livingTarget;
    private final boolean isCritical;
    private final float cooldown;
    private final boolean isExtraAttack;

    public ToolAttackContext(LivingEntity attacker, @Nullable PlayerEntity playerAttacker, Hand hand, Entity target, @Nullable LivingEntity livingTarget, boolean isCritical, float cooldown, boolean isExtraAttack) {
        this(attacker, playerAttacker, hand, Util.getSlotType(hand), target, livingTarget, isCritical, cooldown, isExtraAttack);
    }

    public boolean isFullyCharged() {
        return this.getCooldown() > 0.9f;
    }

    @Nonnull
    public LivingEntity getAttacker() {
        return this.attacker;
    }

    @Nullable
    public PlayerEntity getPlayerAttacker() {
        return this.playerAttacker;
    }

    @Nonnull
    public Hand getHand() {
        return this.hand;
    }

    @Nonnull
    public EquipmentSlotType getSlotType() {
        return this.slotType;
    }

    @Nonnull
    public Entity getTarget() {
        return this.target;
    }

    @Nullable
    public LivingEntity getLivingTarget() {
        return this.livingTarget;
    }

    public boolean isCritical() {
        return this.isCritical;
    }

    public float getCooldown() {
        return this.cooldown;
    }

    public boolean isExtraAttack() {
        return this.isExtraAttack;
    }

    public ToolAttackContext(@Nonnull LivingEntity attacker, @Nullable PlayerEntity playerAttacker, @Nonnull Hand hand, @Nonnull EquipmentSlotType slotType, @Nonnull Entity target, @Nullable LivingEntity livingTarget, boolean isCritical, float cooldown, boolean isExtraAttack) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        if (slotType == null) {
            throw new NullPointerException("slotType is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.attacker = attacker;
        this.playerAttacker = playerAttacker;
        this.hand = hand;
        this.slotType = slotType;
        this.target = target;
        this.livingTarget = livingTarget;
        this.isCritical = isCritical;
        this.cooldown = cooldown;
        this.isExtraAttack = isExtraAttack;
    }
}

