/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import slimeknights.tconstruct.library.tools.SlotType;

public class DefinitionModifierSlots {
    protected static final DefinitionModifierSlots EMPTY = new DefinitionModifierSlots(Collections.emptyMap());
    public static Serializer SERIALIZER = new Serializer();
    private final Map<SlotType, Integer> slots;

    public int getSlots(SlotType slotType) {
        return this.slots.getOrDefault(slotType, 0);
    }

    public Set<SlotType> containedTypes() {
        return this.slots.keySet();
    }

    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.slots.size());
        for (Map.Entry<SlotType, Integer> entry : this.slots.entrySet()) {
            buffer.func_180714_a(entry.getKey().getName());
            buffer.func_150787_b(entry.getValue().intValue());
        }
    }

    public static DefinitionModifierSlots read(PacketBuffer buffer) {
        Builder builder = DefinitionModifierSlots.builder();
        int max = buffer.func_150792_a();
        for (int i = 0; i < max; ++i) {
            SlotType slotType = SlotType.getOrCreate(buffer.func_150789_c(Short.MAX_VALUE));
            builder.setSlots(slotType, buffer.func_150792_a());
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected DefinitionModifierSlots(Map<SlotType, Integer> slots) {
        this.slots = slots;
    }

    protected static class Serializer
    implements JsonDeserializer<DefinitionModifierSlots>,
    JsonSerializer<DefinitionModifierSlots> {
        protected Serializer() {
        }

        public DefinitionModifierSlots deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = JSONUtils.func_151210_l((JsonElement)json, (String)"stats");
            Builder builder = DefinitionModifierSlots.builder();
            for (Map.Entry entry : object.entrySet()) {
                int value = JSONUtils.func_151215_f((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                SlotType slotType = SlotType.getOrCreate((String)entry.getKey());
                builder.setSlots(slotType, value);
            }
            return builder.build();
        }

        public JsonElement serialize(DefinitionModifierSlots stats, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            for (Map.Entry entry : stats.slots.entrySet()) {
                json.addProperty(((SlotType)entry.getKey()).getName(), (Number)entry.getValue());
            }
            return json;
        }
    }

    public static class Builder {
        private final ImmutableMap.Builder<SlotType, Integer> builder = ImmutableMap.builder();

        protected Builder() {
        }

        public Builder setSlots(SlotType slotType, int count) {
            this.builder.put((Object)slotType, (Object)count);
            return this;
        }

        public DefinitionModifierSlots build() {
            return new DefinitionModifierSlots((Map<SlotType, Integer>)this.builder.build());
        }
    }
}

