/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class RestrictedCompoundTag {
    private final CompoundNBT tag;
    private final Set<String> restrictedKeys;

    public boolean contains(String name, int type) {
        return !this.restrictedKeys.contains(name) && this.tag.func_150297_b(name, type);
    }

    protected <T> T get(String name, BiFunction<CompoundNBT, String, T> function, T defaultValue) {
        if (this.restrictedKeys.contains(name)) {
            return defaultValue;
        }
        return function.apply(this.tag, name);
    }

    @Nullable
    public INBT get(String name) {
        return this.get(name, CompoundNBT::func_74781_a, null);
    }

    public int getInt(String name) {
        return this.get(name, CompoundNBT::func_74762_e, 0);
    }

    public boolean getBoolean(String name) {
        return this.get(name, CompoundNBT::func_74767_n, false);
    }

    public float getFloat(String name) {
        return this.get(name, CompoundNBT::func_74760_g, Float.valueOf(0.0f)).floatValue();
    }

    public String getString(String name) {
        return this.get(name, CompoundNBT::func_74779_i, "");
    }

    public CompoundNBT getCompound(String name) {
        if (this.restrictedKeys.contains(name)) {
            return new CompoundNBT();
        }
        return this.tag.func_74775_l(name);
    }

    public ListNBT getList(String name, int type) {
        if (this.restrictedKeys.contains(name)) {
            return new ListNBT();
        }
        return this.tag.func_150295_c(name, type);
    }

    public void put(String name, INBT nbt) {
        if (!this.restrictedKeys.contains(name)) {
            this.tag.func_218657_a(name, nbt);
        }
    }

    public void putInt(String name, int value) {
        if (!this.restrictedKeys.contains(name)) {
            this.tag.func_74768_a(name, value);
        }
    }

    public void putBoolean(String name, boolean value) {
        if (!this.restrictedKeys.contains(name)) {
            this.tag.func_74757_a(name, value);
        }
    }

    public void putFloat(String name, float value) {
        if (!this.restrictedKeys.contains(name)) {
            this.tag.func_74776_a(name, value);
        }
    }

    public void putString(String name, String value) {
        if (!this.restrictedKeys.contains(name)) {
            this.tag.func_74778_a(name, value);
        }
    }

    public void remove(String name) {
        if (!this.restrictedKeys.contains(name)) {
            this.tag.func_82580_o(name);
        }
    }

    public RestrictedCompoundTag(CompoundNBT tag, Set<String> restrictedKeys) {
        this.tag = tag;
        this.restrictedKeys = restrictedKeys;
    }
}

