/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.multiblock;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.tconstruct.common.multiblock.IMasterLogic;
import slimeknights.tconstruct.common.multiblock.IServantLogic;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.smeltery.tileentity.multiblock.MultiblockCuboid;
import slimeknights.tconstruct.smeltery.tileentity.multiblock.MultiblockResult;
import slimeknights.tconstruct.smeltery.tileentity.multiblock.MultiblockStructureData;

public abstract class HeatingStructureMultiblock<T extends MantleTileEntity>
extends MultiblockCuboid<StructureData> {
    private static final String TAG_TANKS = "tanks";
    private static final String TAG_INSIDE_CHECK = "insideCheck";
    protected final T parent;
    protected final List<BlockPos> tanks = new ArrayList<BlockPos>();

    public HeatingStructureMultiblock(T parent, boolean hasFloor, boolean hasFrame, boolean hasCeiling, int maxHeight, int innerLimit) {
        super(hasFloor, hasFrame, hasCeiling, maxHeight, innerLimit);
        this.parent = parent;
    }

    public HeatingStructureMultiblock(T parent, boolean hasFloor, boolean hasFrame, boolean hasCeiling) {
        super(hasFloor, hasFrame, hasCeiling);
        this.parent = parent;
    }

    @Override
    public StructureData create(BlockPos min, BlockPos max, Set<BlockPos> extraPos) {
        this.tanks.removeIf(pos -> !MultiblockStructureData.isWithin(pos, min, max));
        return new StructureData(min, max, extraPos, this.hasFloor, this.hasFrame, this.hasCeiling, (List<BlockPos>)ImmutableList.copyOf(this.tanks));
    }

    public StructureData createClient(BlockPos min, BlockPos max, List<BlockPos> tanks) {
        return new StructureData(min, max, Collections.emptySet(), this.hasFloor, this.hasFrame, this.hasCeiling, tanks);
    }

    @Override
    public StructureData detectMultiblock(World world, BlockPos master, Direction facing) {
        this.tanks.clear();
        return (StructureData)super.detectMultiblock(world, master, facing);
    }

    @Override
    @Nullable
    public StructureData readFromNBT(CompoundNBT nbt) {
        this.tanks.clear();
        this.tanks.addAll(HeatingStructureMultiblock.readPosList(nbt, TAG_TANKS));
        return (StructureData)super.readFromNBT(nbt);
    }

    protected boolean isValidSlave(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IServantLogic) {
            return ((IServantLogic)te).isValidMaster((IMasterLogic)this.parent);
        }
        return true;
    }

    public boolean canExpand(StructureData data, World world) {
        BlockPos min = data.getMinPos();
        BlockPos to = data.getMaxPos().func_177984_a();
        MultiblockResult result = this.detectLayer(world, new BlockPos(min.func_177958_n(), to.func_177956_o(), min.func_177952_p()), to, pos -> {});
        this.setLastResult(result);
        return result.isSuccess();
    }

    protected abstract boolean isValidBlock(Block var1);

    protected abstract boolean isValidFloor(Block var1);

    protected abstract boolean isValidTank(Block var1);

    protected abstract boolean isValidWall(Block var1);

    @Override
    protected boolean isValidBlock(World world, BlockPos pos, MultiblockCuboid.CuboidSide side, boolean isFrame) {
        if (pos.equals((Object)this.parent.func_174877_v())) {
            return true;
        }
        if (!this.isValidSlave(world, pos)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        if (side == MultiblockCuboid.CuboidSide.FLOOR && !isFrame) {
            return this.isValidFloor(state.func_177230_c());
        }
        if (this.isValidTank(state.func_177230_c())) {
            this.tanks.add(pos.func_185334_h());
            return true;
        }
        return this.isValidWall(state.func_177230_c());
    }

    @Override
    public boolean shouldUpdate(World world, MultiblockStructureData structure, BlockPos pos, BlockState state) {
        if (structure.withinBounds(pos)) {
            if (structure.contains(pos)) {
                return !this.isValidBlock(state.func_177230_c());
            }
            return structure.isInside(pos) && !state.isAir((IBlockReader)world, pos);
        }
        return structure.isDirectlyAbove(pos) && this.isValidWall(state.func_177230_c());
    }

    public static class StructureData
    extends MultiblockStructureData {
        private final List<BlockPos> tanks;
        private BlockPos insideCheck;

        protected StructureData(BlockPos minPos, BlockPos maxPos, Set<BlockPos> extraPositions, boolean hasFloor, boolean hasFrame, boolean hasCeiling, List<BlockPos> tanks) {
            super(minPos, maxPos, extraPositions, hasFloor, hasFrame, hasCeiling);
            this.tanks = tanks;
        }

        public boolean hasTanks() {
            return !this.tanks.isEmpty();
        }

        private BlockPos getNextInsideCheck(@Nullable BlockPos prev) {
            BlockPos min = this.getMinInside();
            if (prev == null) {
                return min;
            }
            if (prev.func_177958_n() < min.func_177958_n() || prev.func_177956_o() < min.func_177956_o() || prev.func_177952_p() < min.func_177952_p()) {
                return min;
            }
            BlockPos max = this.getMaxInside();
            if (prev.func_177952_p() >= max.func_177952_p()) {
                if (prev.func_177958_n() >= max.func_177958_n()) {
                    if (prev.func_177956_o() >= max.func_177956_o()) {
                        return min;
                    }
                    return new BlockPos(min.func_177958_n(), prev.func_177956_o() + 1, min.func_177952_p());
                }
                return new BlockPos(prev.func_177958_n() + 1, prev.func_177956_o(), min.func_177952_p());
            }
            return prev.func_177982_a(0, 0, 1);
        }

        public BlockPos getNextInsideCheck() {
            this.insideCheck = this.getNextInsideCheck(this.insideCheck);
            return this.insideCheck;
        }

        public int getPerimeterCount() {
            BlockPos min = this.getMinInside();
            BlockPos max = this.getMaxInside();
            int dx = max.func_177958_n() - min.func_177958_n();
            int dy = max.func_177956_o() - min.func_177956_o();
            int dz = max.func_177952_p() - min.func_177952_p();
            return 2 * (dx * dy) + 2 * (dy * dz) + dx * dz;
        }

        @Override
        public CompoundNBT writeClientNBT() {
            CompoundNBT nbt = super.writeClientNBT();
            nbt.func_218657_a(HeatingStructureMultiblock.TAG_TANKS, (INBT)StructureData.writePosList(this.tanks));
            return nbt;
        }

        @Override
        public CompoundNBT writeToNBT() {
            CompoundNBT nbt = super.writeToNBT();
            if (this.insideCheck != null) {
                nbt.func_218657_a(HeatingStructureMultiblock.TAG_INSIDE_CHECK, (INBT)TagUtil.writePos(this.insideCheck));
            }
            return nbt;
        }

        public List<BlockPos> getTanks() {
            return this.tanks;
        }
    }
}

