/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data.material;

import java.util.function.Consumer;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.recipe.data.CompoundIngredient;
import slimeknights.mantle.recipe.ingredient.FluidContainerIngredient;
import slimeknights.mantle.recipe.ingredient.IngredientWithout;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.data.BaseRecipeProvider;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IMaterialRecipeHelper;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.world.TinkerWorld;

public class MaterialRecipeProvider
extends BaseRecipeProvider
implements IMaterialRecipeHelper {
    public MaterialRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public String func_200397_b() {
        return "Tinkers' Construct Material Recipe";
    }

    @Override
    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.addMaterialItems(consumer);
        this.addMaterialSmeltery(consumer);
    }

    private void addMaterialItems(Consumer<IFinishedRecipe> consumer) {
        String folder = "tools/materials/";
        this.materialRecipe(consumer, MaterialIds.wood, Ingredient.func_199805_a((ITag)Tags.Items.RODS_WOODEN), 1, 2, folder + "wood/sticks");
        this.materialRecipe(consumer, MaterialIds.wood, (Ingredient)new IngredientWithout(Ingredient.func_199805_a((ITag)ItemTags.field_199905_b), Ingredient.func_199805_a(TinkerTags.Items.SLIMY_PLANKS)), 1, 1, folder + "wood/planks");
        this.materialRecipe(consumer, MaterialIds.wood, (Ingredient)new IngredientWithout(Ingredient.func_199805_a((ITag)ItemTags.field_200038_h), Ingredient.func_199805_a(TinkerTags.Items.SLIMY_LOGS)), 4, 1, ItemOutput.fromStack((ItemStack)new ItemStack((IItemProvider)Items.field_151055_y, 2)), folder + "wood/logs");
        this.materialRecipe(consumer, MaterialIds.stone, (Ingredient)CompoundIngredient.from((Ingredient[])new Ingredient[]{Ingredient.func_199805_a((ITag)Tags.Items.STONE), Ingredient.func_199805_a((ITag)Tags.Items.COBBLESTONE), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_235406_np_, Blocks.field_235410_nt_})}), 1, 1, folder + "stone");
        this.materialRecipe(consumer, MaterialIds.flint, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151145_ak, Blocks.field_235337_cO_, Blocks.field_235338_cP_}), 1, 1, folder + "flint");
        this.materialRecipe(consumer, MaterialIds.bone, Ingredient.func_199805_a((ITag)Tags.Items.BONES), 1, 1, folder + "bone");
        this.materialRecipe(consumer, MaterialIds.necroticBone, Ingredient.func_199805_a(TinkerTags.Items.WITHER_BONES), 1, 1, folder + "necrotic_bone");
        this.materialRecipe(consumer, MaterialIds.string, Ingredient.func_199805_a((ITag)Tags.Items.STRING), 1, 4, folder + "string");
        this.materialRecipe(consumer, MaterialIds.leather, Ingredient.func_199805_a((ITag)Tags.Items.LEATHER), 1, 1, folder + "leather");
        this.materialRecipe(consumer, MaterialIds.vine, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221796_dh, Items.field_234719_bC_, Items.field_234718_bB_}), 1, 1, folder + "vine");
        this.metalMaterialRecipe(consumer, MaterialIds.iron, folder, "iron", false);
        this.materialRecipe(consumer, MaterialIds.searedStone, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.searedBrick}), 1, 2, folder + "seared_stone/brick");
        this.materialRecipe(consumer, MaterialIds.searedStone, Ingredient.func_199805_a(TinkerTags.Items.SEARED_BLOCKS), 2, 1, ItemOutput.fromItem(TinkerSmeltery.searedBrick), folder + "seared_stone/block");
        this.materialRecipe(consumer, MaterialIds.scorchedStone, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.scorchedBrick}), 1, 2, folder + "scorched_stone/brick");
        this.materialRecipe(consumer, MaterialIds.scorchedStone, Ingredient.func_199805_a(TinkerTags.Items.SCORCHED_BLOCKS), 2, 1, ItemOutput.fromItem(TinkerSmeltery.scorchedBrick), folder + "scorched_stone/block");
        this.metalMaterialRecipe(consumer, MaterialIds.copper, folder, "copper", false);
        this.materialRecipe(consumer, MaterialIds.slimewood, Ingredient.func_199805_a(TinkerTags.Items.SLIMY_PLANKS), 1, 1, folder + "slimewood/planks");
        this.materialRecipe(consumer, MaterialIds.slimewood, Ingredient.func_199805_a((ITag)TinkerWorld.greenheart.getLogItemTag()), 4, 1, ItemOutput.fromItem((IItemProvider)TinkerWorld.greenheart), folder + "slimewood/greenheart_logs");
        this.materialRecipe(consumer, MaterialIds.slimewood, Ingredient.func_199805_a((ITag)TinkerWorld.skyroot.getLogItemTag()), 4, 1, ItemOutput.fromItem((IItemProvider)TinkerWorld.skyroot), folder + "slimewood/skyroot_logs");
        this.materialRecipe(consumer, MaterialIds.slimewood, Ingredient.func_199805_a((ITag)TinkerWorld.bloodshroom.getLogItemTag()), 4, 1, ItemOutput.fromItem((IItemProvider)TinkerWorld.bloodshroom), folder + "slimewood/bloodshroom_logs");
        this.materialRecipe(consumer, MaterialIds.bloodbone, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerMaterials.bloodbone}), 1, 1, folder + "bloodbone");
        this.metalMaterialRecipe(consumer, MaterialIds.roseGold, folder, "rose_gold", false);
        this.materialRecipe(consumer, MaterialIds.chain, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_235341_dI_}), 1, 1, folder + "chain");
        this.materialRecipe(consumer, MaterialIds.skyslimeVine, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerWorld.skySlimeVine}), 1, 1, folder + "skyslime_vine");
        this.metalMaterialRecipe(consumer, MaterialIds.slimesteel, folder, "slimesteel", false);
        this.materialRecipe(consumer, MaterialIds.nahuatl, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerMaterials.nahuatl}), 1, 1, folder + "nahuatl");
        this.metalMaterialRecipe(consumer, MaterialIds.tinkersBronze, folder, "silicon_bronze", false);
        this.metalMaterialRecipe(consumer, MaterialIds.pigIron, folder, "pig_iron", false);
        this.metalMaterialRecipe(consumer, MaterialIds.cobalt, folder, "cobalt", false);
        this.metalMaterialRecipe(consumer, MaterialIds.queensSlime, folder, "queens_slime", false);
        this.metalMaterialRecipe(consumer, MaterialIds.manyullyn, folder, "manyullyn", false);
        this.metalMaterialRecipe(consumer, MaterialIds.hepatizon, folder, "hepatizon", false);
        this.materialRecipe(consumer, MaterialIds.blazingBone, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerMaterials.blazingBone}), 1, 1, folder + "blazing_bone");
        this.materialRecipe(consumer, MaterialIds.enderslimeVine, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerWorld.enderSlimeVine}), 1, 1, folder + "enderslime_vine");
        this.metalMaterialRecipe(consumer, MaterialIds.osmium, folder, "osmium", true);
        this.metalMaterialRecipe(consumer, MaterialIds.tungsten, folder, "tungsten", true);
        this.metalMaterialRecipe(consumer, MaterialIds.platinum, folder, "platinum", true);
        this.metalMaterialRecipe(consumer, MaterialIds.silver, folder, "silver", true);
        this.metalMaterialRecipe(consumer, MaterialIds.lead, folder, "lead", true);
        this.metalMaterialRecipe(consumer, MaterialIds.steel, folder, "steel", true);
        this.metalMaterialRecipe(consumer, MaterialIds.bronze, folder, "bronze", true);
        this.metalMaterialRecipe(consumer, MaterialIds.constantan, folder, "constantan", true);
        this.metalMaterialRecipe(consumer, MaterialIds.invar, folder, "invar", true);
        this.materialRecipe(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/uranium")}), MaterialIds.necronium, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerMaterials.necroniumBone}), 1, 1, folder + "necronium");
        this.metalMaterialRecipe(consumer, MaterialIds.electrum, folder, "electrum", true);
        this.metalMaterialRecipe(consumer, MaterialIds.gold, folder, "gold", false);
        this.materialRecipe(consumer, MaterialIds.gunpowder, Ingredient.func_199805_a((ITag)Tags.Items.GUNPOWDER), 1, 2, folder + "gunpowder");
        this.materialRecipe(consumer, MaterialIds.enderPearl, Ingredient.func_199805_a((ITag)Tags.Items.ENDER_PEARLS), 1, 1, folder + "ender_pearl");
        this.materialRecipe(consumer, MaterialIds.spider, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151070_bp}), 1, 1, folder + "spider");
        this.materialRecipe(consumer, MaterialIds.venom, (Ingredient)FluidContainerIngredient.fromFluid(TinkerFluids.venom, (boolean)false), 4, 1, folder + "venom_bucket");
        this.materialRecipe(consumer, MaterialIds.rottenFlesh, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151078_bh}), 1, 1, folder + "rotten_flesh");
        this.materialRecipe(consumer, MaterialIds.enderslime, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TinkerCommons.slimeball.get((Enum)SlimeType.ENDER)}), 1, 1, folder + "enderslime/ball");
        this.materialRecipe(consumer, MaterialIds.enderslime, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TinkerWorld.congealedSlime.get((Enum)SlimeType.ENDER)}), 4, 1, folder + "enderslime/congealed");
        this.materialRecipe(consumer, MaterialIds.enderslime, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TinkerWorld.slime.get((Enum)SlimeType.ENDER)}), 9, 1, folder + "enderslime/block");
        this.materialRecipe(consumer, MaterialIds.phantom, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_204840_eX}), 1, 1, folder + "phantom_membrane");
        this.materialRecipe(consumer, MaterialIds.chorus, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185162_cT}), 1, 1, folder + "chorus_popped");
        this.materialRecipe(consumer, MaterialIds.rabbit, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_179555_bs}), 1, 1, folder + "rabbit_hide");
    }

    private void addMaterialSmeltery(Consumer<IFinishedRecipe> consumer) {
        String folder = "tools/materials/";
        this.materialMeltingCasting(consumer, MaterialIds.iron, TinkerFluids.moltenIron, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.copper, TinkerFluids.moltenCopper, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.searedStone, TinkerFluids.searedStone, false, 288, folder);
        this.materialMeltingCasting(consumer, MaterialIds.scorchedStone, TinkerFluids.scorchedStone, false, 288, folder);
        this.materialMelting(consumer, MaterialIds.chain, (Fluid)TinkerFluids.moltenIron.get(), 176, folder);
        this.materialComposite(consumer, MaterialIds.stone, MaterialIds.searedStone, TinkerFluids.moltenClay, 250, false, folder);
        this.materialComposite(consumer, MaterialIds.wood, MaterialIds.slimewood, TinkerFluids.earthSlime, 250, true, folder);
        this.materialComposite(consumer, MaterialIds.flint, MaterialIds.scorchedStone, TinkerFluids.magma, 250, true, folder);
        this.materialComposite(consumer, MaterialIds.bone, MaterialIds.bloodbone, TinkerFluids.blood, 250, false, folder);
        this.materialMeltingCasting(consumer, MaterialIds.slimesteel, TinkerFluids.moltenSlimesteel, false, folder);
        this.materialMeltingCasting(consumer, MaterialIds.tinkersBronze, TinkerFluids.moltenTinkersBronze, false, folder);
        this.materialMeltingCasting(consumer, MaterialIds.roseGold, TinkerFluids.moltenRoseGold, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.pigIron, TinkerFluids.moltenPigIron, false, folder);
        this.materialMeltingCasting(consumer, MaterialIds.cobalt, TinkerFluids.moltenCobalt, true, folder);
        this.materialMeltingComposite(consumer, MaterialIds.wood, MaterialIds.nahuatl, TinkerFluids.moltenObsidian, 1000, false, folder);
        this.materialMeltingComposite(consumer, MaterialIds.string, MaterialIds.darkthread, TinkerFluids.moltenObsidian, 250, false, folder);
        this.materialMeltingCasting(consumer, MaterialIds.queensSlime, TinkerFluids.moltenQueensSlime, false, folder);
        this.materialMeltingCasting(consumer, MaterialIds.hepatizon, TinkerFluids.moltenHepatizon, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.manyullyn, TinkerFluids.moltenManyullyn, true, folder);
        this.materialComposite(consumer, MaterialIds.necroticBone, MaterialIds.blazingBone, TinkerFluids.blazingBlood, 200, false, folder);
        this.materialMeltingComposite(consumer, MaterialIds.leather, MaterialIds.ancientHide, TinkerFluids.moltenDebris, 144, false, folder);
        this.compatMeltingCasting(consumer, MaterialIds.osmium, TinkerFluids.moltenOsmium, folder);
        this.compatMeltingCasting(consumer, MaterialIds.tungsten, TinkerFluids.moltenTungsten, folder);
        this.compatMeltingCasting(consumer, MaterialIds.platinum, TinkerFluids.moltenPlatinum, folder);
        this.compatMeltingCasting(consumer, MaterialIds.silver, TinkerFluids.moltenSilver, folder);
        this.compatMeltingCasting(consumer, MaterialIds.lead, TinkerFluids.moltenLead, folder);
        this.materialComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/aluminum")}), MaterialIds.stone, MaterialIds.whitestone, TinkerFluids.moltenAluminum, 144, true, folder, "whitestone_from_aluminum");
        this.materialComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/tin")}), MaterialIds.stone, MaterialIds.whitestone, TinkerFluids.moltenTin, 144, true, folder, "whitestone_from_tin");
        this.materialComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/zinc")}), MaterialIds.stone, MaterialIds.whitestone, TinkerFluids.moltenZinc, 144, true, folder, "whitestone_from_zinc");
        this.compatMeltingCasting(consumer, MaterialIds.steel, TinkerFluids.moltenSteel, folder);
        this.compatMeltingCasting(consumer, MaterialIds.bronze, TinkerFluids.moltenBronze, folder);
        this.compatMeltingCasting(consumer, MaterialIds.constantan, TinkerFluids.moltenConstantan, folder);
        this.compatMeltingCasting(consumer, MaterialIds.invar, TinkerFluids.moltenInvar, folder);
        this.compatMeltingCasting(consumer, MaterialIds.electrum, TinkerFluids.moltenElectrum, folder);
        this.materialMeltingComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/uranium")}), MaterialIds.necroticBone, MaterialIds.necronium, TinkerFluids.moltenUranium, 144, true, folder);
        this.materialMeltingComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/brass")}), MaterialIds.slimewood, MaterialIds.platedSlimewood, TinkerFluids.moltenBrass, 144, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.gold, TinkerFluids.moltenGold, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.enderslime, TinkerFluids.enderSlime, 250, folder);
        this.materialMeltingCasting(consumer, MaterialIds.venom, TinkerFluids.venom, 250, folder);
    }
}

