/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.slotless;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.SingleUseModifier;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;

public class CreativeSlotModifier
extends SingleUseModifier {
    public static final ResourceLocation KEY_SLOTS = TConstruct.getResource("creative");

    public CreativeSlotModifier() {
        super(13417031);
    }

    @Override
    public void onRemoved(IModifierToolStack tool) {
        tool.getPersistentData().remove(KEY_SLOTS);
    }

    @Override
    public void addVolatileData(Item item, ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, int level, ModDataNBT volatileData) {
        if (persistentData.contains(KEY_SLOTS, 10)) {
            CompoundNBT slots = persistentData.getCompound(KEY_SLOTS);
            for (String key : slots.func_150296_c()) {
                SlotType slotType = SlotType.getIfPresent(key);
                if (slotType == null) continue;
                volatileData.addSlots(slotType, slots.func_74762_e(key));
            }
        }
    }

    private static ITextComponent formatCount(SlotType slotType, int count) {
        return new StringTextComponent((count > 0 ? "+" : "") + count + " ").func_230529_a_(slotType.getDisplayName()).func_240700_a_(style -> style.func_240718_a_(slotType.getColor()));
    }

    @Override
    public List<ITextComponent> getDescriptionList(IModifierToolStack tool, int level) {
        List<ITextComponent> tooltip = this.getDescriptionList(level);
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(KEY_SLOTS, 10)) {
            CompoundNBT slots = persistentData.getCompound(KEY_SLOTS);
            boolean first = true;
            for (String key : slots.func_150296_c()) {
                SlotType slotType = SlotType.getIfPresent(key);
                if (slotType == null) continue;
                if (first) {
                    tooltip = new ArrayList<ITextComponent>(tooltip);
                    first = false;
                }
                tooltip.add(CreativeSlotModifier.formatCount(slotType, slots.func_74762_e(key)));
            }
        }
        return tooltip;
    }
}

