/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.armor;

import net.minecraft.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalArmorLevelModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;

public class LeapingModifier
extends IncrementalArmorLevelModifier {
    private static final TinkerDataCapability.TinkerDataKey<Float> LEAPING = TConstruct.createKey("leaping");

    public LeapingModifier() {
        super(14201473, LEAPING);
        MinecraftForge.EVENT_BUS.addListener(LeapingModifier::onLivingFall);
        MinecraftForge.EVENT_BUS.addListener(LeapingModifier::onLivingJump);
    }

    private static void onLivingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntityLiving();
        float boost = ModifierUtil.getTotalModifierFloat(entity, LEAPING);
        if (boost > 0.0f) {
            event.setDistance(Math.max(event.getDistance() - boost, 0.0f));
        }
    }

    private static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntityLiving();
        float boost = ModifierUtil.getTotalModifierFloat(entity, LEAPING);
        if (boost > 0.0f) {
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(0.0, (double)boost * 0.1, 0.0));
        }
    }
}

