/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blocks;

import com.google.common.collect.Lists;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.tileentity.TravelersBackpackTileEntity;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class TravelersBackpackBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final double X = 0.7777777777777778;
    private static final double Y = 0.7692307692307693;
    private static final double Z = 0.7777777777777778;
    private static final double OX = 1.775;
    private static final double OY = 1.655;
    private static final double OZ = 1.778;
    private static final VoxelShape BACKPACK_SHAPE_NORTH = Stream.of(Block.func_208617_a((double)4.108333333333333, (double)0.8857692307692308, (double)6.4446666666666665, (double)11.886111111111111, (double)10.116538461538461, (double)10.333555555555556), Block.func_208617_a((double)4.108333333333333, (double)0.11653846153846148, (double)7.222444444444445, (double)11.886111111111111, (double)0.8857692307692308, (double)10.333555555555556), Block.func_208617_a((double)4.886111111111111, (double)2.4857692307692307, (double)4.889111111111111, (double)11.108333333333334, (double)7.101153846153847, (double)6.4446666666666665), Block.func_208617_a((double)4.886111111111111, (double)1.655, (double)10.333555555555556, (double)5.663888888888889, (double)7.808846153846154, (double)11.111333333333334), Block.func_208617_a((double)10.330555555555556, (double)1.655, (double)10.333555555555556, (double)11.108333333333334, (double)7.808846153846154, (double)11.111333333333334), Block.func_208617_a((double)0.9972222222222221, (double)0.11653846153846148, (double)6.833555555555556, (double)4.108333333333333, (double)7.808846153846154, (double)9.944666666666667), Block.func_208617_a((double)11.886111111111111, (double)0.11653846153846148, (double)6.833555555555556, (double)14.997222222222224, (double)7.808846153846154, (double)9.944666666666667)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape BACKPACK_SHAPE_SOUTH = Stream.of(Block.func_208617_a((double)4.108333333333333, (double)0.8857692307692308, (double)5.666888888888889, (double)11.886111111111111, (double)10.116538461538461, (double)9.555777777777777), Block.func_208617_a((double)4.108333333333333, (double)0.11653846153846148, (double)5.666888888888889, (double)11.886111111111111, (double)0.8857692307692308, (double)8.778), Block.func_208617_a((double)4.886111111111111, (double)2.4857692307692307, (double)9.555777777777777, (double)11.108333333333334, (double)7.101153846153847, (double)11.111333333333334), Block.func_208617_a((double)4.886111111111111, (double)1.655, (double)5.666888888888889, (double)5.663888888888889, (double)7.808846153846154, (double)4.889111111111111), Block.func_208617_a((double)10.330555555555556, (double)1.655, (double)5.666888888888889, (double)11.108333333333334, (double)7.808846153846154, (double)4.889111111111111), Block.func_208617_a((double)0.9972222222222221, (double)0.11653846153846148, (double)6.055777777777777, (double)4.108333333333333, (double)7.808846153846154, (double)9.16688888888889), Block.func_208617_a((double)11.886111111111111, (double)0.11653846153846148, (double)6.055777777777777, (double)14.997222222222224, (double)7.808846153846154, (double)9.16688888888889)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape BACKPACK_SHAPE_WEST = Stream.of(Block.func_208617_a((double)6.441666666666666, (double)0.8857692307692308, (double)4.1113333333333335, (double)10.330555555555556, (double)10.116538461538461, (double)11.889111111111111), Block.func_208617_a((double)7.219444444444445, (double)0.11653846153846148, (double)4.1113333333333335, (double)10.330555555555556, (double)0.8857692307692308, (double)11.889111111111111), Block.func_208617_a((double)4.886111111111111, (double)2.4857692307692307, (double)4.889111111111111, (double)6.441666666666666, (double)7.101153846153847, (double)11.111333333333334), Block.func_208617_a((double)10.330555555555556, (double)1.655, (double)4.889111111111111, (double)11.108333333333334, (double)7.808846153846154, (double)5.666888888888889), Block.func_208617_a((double)10.330555555555556, (double)1.655, (double)10.333555555555556, (double)11.108333333333334, (double)7.808846153846154, (double)11.111333333333334), Block.func_208617_a((double)6.830555555555556, (double)0.11653846153846148, (double)1.0002222222222223, (double)9.941666666666666, (double)7.808846153846154, (double)4.1113333333333335), Block.func_208617_a((double)6.830555555555556, (double)0.11653846153846148, (double)11.889111111111111, (double)9.941666666666666, (double)7.808846153846154, (double)15.000222222222224)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape BACKPACK_SHAPE_EAST = Stream.of(Block.func_208617_a((double)5.663888888888889, (double)0.8857692307692308, (double)4.1113333333333335, (double)9.552777777777777, (double)10.116538461538461, (double)11.889111111111111), Block.func_208617_a((double)5.663888888888889, (double)0.11653846153846148, (double)4.1113333333333335, (double)8.775, (double)0.8857692307692308, (double)11.889111111111111), Block.func_208617_a((double)9.552777777777777, (double)2.4857692307692307, (double)4.889111111111111, (double)11.108333333333334, (double)7.101153846153847, (double)11.111333333333334), Block.func_208617_a((double)5.663888888888889, (double)1.655, (double)4.889111111111111, (double)4.886111111111111, (double)7.808846153846154, (double)5.666888888888889), Block.func_208617_a((double)5.663888888888889, (double)1.655, (double)10.333555555555556, (double)4.886111111111111, (double)7.808846153846154, (double)11.111333333333334), Block.func_208617_a((double)6.052777777777777, (double)0.11653846153846148, (double)1.0002222222222223, (double)9.16388888888889, (double)7.808846153846154, (double)4.1113333333333335), Block.func_208617_a((double)6.052777777777777, (double)0.11653846153846148, (double)11.889111111111111, (double)9.16388888888889, (double)7.808846153846154, (double)15.000222222222224)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public TravelersBackpackBlock(AbstractBlock.Properties builder) {
        super(builder.func_200948_a(1.0f, Float.MAX_VALUE).harvestLevel(0));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case SOUTH: {
                return BACKPACK_SHAPE_SOUTH;
            }
            case EAST: {
                return BACKPACK_SHAPE_EAST;
            }
            case WEST: {
                return BACKPACK_SHAPE_WEST;
            }
        }
        return BACKPACK_SHAPE_NORTH;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.func_175625_s(pos) instanceof TravelersBackpackTileEntity) {
            TravelersBackpackTileEntity te = (TravelersBackpackTileEntity)worldIn.func_175625_s(pos);
            if (TravelersBackpackConfig.enableBackpackBlockWearable) {
                if (player.func_213453_ef() && !worldIn.field_72995_K) {
                    if (!CapabilityUtils.isWearingBackpack(player)) {
                        if (!TravelersBackpack.enableCurios()) {
                            if (worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 7)) {
                                ItemStack stack = new ItemStack((IItemProvider)this.func_199767_j(), 1);
                                te.transferToItemStack(stack);
                                CapabilityUtils.equipBackpack(player, stack);
                                if (te.isSleepingBagDeployed()) {
                                    Direction bagDirection = (Direction)state.func_177229_b((Property)FACING);
                                    worldIn.func_175656_a(pos.func_177972_a(bagDirection), Blocks.field_150350_a.func_176223_P());
                                    worldIn.func_175656_a(pos.func_177972_a(bagDirection).func_177972_a(bagDirection), Blocks.field_150350_a.func_176223_P());
                                }
                            } else {
                                player.func_145747_a((ITextComponent)new TranslationTextComponent("action.travelersbackpack.equip_fail"), player.func_110124_au());
                            }
                        } else {
                            ItemStack stack = new ItemStack((IItemProvider)this.func_199767_j(), 1);
                            te.transferToItemStack(stack);
                            CuriosApi.getCuriosHelper().getCurio(stack).ifPresent(curio -> CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
                                Map curios = handler.getCurios();
                                for (Map.Entry entry : curios.entrySet()) {
                                    IDynamicStackHandler stackHandler = ((ICurioStacksHandler)entry.getValue()).getStacks();
                                    for (int i = 0; i < stackHandler.getSlots(); ++i) {
                                        ItemStack present = stackHandler.getStackInSlot(i);
                                        Set tags = CuriosApi.getCuriosHelper().getCurioTags(stack.func_77973_b());
                                        String id = (String)entry.getKey();
                                        if (!present.func_190926_b() || !tags.contains(id) && !tags.contains(SlotTypePreset.CURIO.getIdentifier()) && (tags.isEmpty() || !id.equals(SlotTypePreset.CURIO.getIdentifier())) || !curio.canEquip(id, (LivingEntity)player) || !worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 7)) continue;
                                        stackHandler.setStackInSlot(i, stack.func_77946_l());
                                        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, (1.0f + (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                                        if (!te.isSleepingBagDeployed()) continue;
                                        Direction bagDirection = (Direction)state.func_177229_b((Property)FACING);
                                        worldIn.func_175656_a(pos.func_177972_a(bagDirection), Blocks.field_150350_a.func_176223_P());
                                        worldIn.func_175656_a(pos.func_177972_a(bagDirection).func_177972_a(bagDirection), Blocks.field_150350_a.func_176223_P());
                                    }
                                }
                            }));
                        }
                    } else {
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("action.travelersbackpack.equip_otherbackpack"), player.func_110124_au());
                    }
                } else {
                    te.openGUI(player, te, pos);
                }
            } else {
                te.openGUI(player, te, pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TravelersBackpackTileEntity && !worldIn.func_201670_d()) {
            ((TravelersBackpackTileEntity)te).drop(worldIn, pos, this.func_199767_j());
            if (((TravelersBackpackTileEntity)te).isSleepingBagDeployed()) {
                Direction direction = (Direction)state.func_177229_b((Property)FACING);
                worldIn.func_175656_a(pos.func_177972_a(direction), Blocks.field_150350_a.func_176223_P());
                worldIn.func_175656_a(pos.func_177972_a(direction).func_177972_a(direction), Blocks.field_150350_a.func_176223_P());
            }
        }
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), worldIn.field_72995_K ? 11 : 3);
        super.func_176208_a(worldIn, pos, state, player);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack stack = new ItemStack((IItemProvider)this.func_199767_j(), 1);
        if (world.func_175625_s(pos) instanceof TravelersBackpackTileEntity) {
            TravelersBackpackTileEntity te = (TravelersBackpackTileEntity)world.func_175625_s(pos);
            te.transferToItemStack(stack);
            if (te.func_145818_k_()) {
                stack.func_200302_a(te.func_200201_e());
            }
        }
        return stack;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TravelersBackpackTileEntity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if (worldIn.func_175625_s(pos) instanceof TravelersBackpackTileEntity) {
            BackpackAbilities.ABILITIES.animateTick((TravelersBackpackTileEntity)worldIn.func_175625_s(pos), stateIn, worldIn, pos, rand);
        }
    }

    public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TravelersBackpackTileEntity && ((TravelersBackpackTileEntity)world.func_175625_s(pos)).getAbilityValue() && state.func_177230_c() == ModBlocks.BOOKSHELF_TRAVELERS_BACKPACK.get()) {
            return 5.0f;
        }
        return super.getEnchantPowerBonus(state, world, pos);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (blockAccess.func_175625_s(pos) instanceof TravelersBackpackTileEntity && ((TravelersBackpackTileEntity)blockAccess.func_175625_s(pos)).getAbilityValue() && blockState.func_177230_c() == ModBlocks.REDSTONE_TRAVELERS_BACKPACK.get()) {
            return 15;
        }
        return super.func_180656_a(blockState, blockAccess, pos, side);
    }

    public boolean func_149744_f(BlockState state) {
        return state.func_177230_c() == ModBlocks.REDSTONE_TRAVELERS_BACKPACK.get();
    }

    public void func_220082_b(BlockState p_220082_1_, World p_220082_2_, BlockPos p_220082_3_, BlockState p_220082_4_, boolean p_220082_5_) {
        if (!p_220082_4_.func_203425_a(p_220082_1_.func_177230_c()) && p_220082_1_.func_177230_c() == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
            this.tryAbsorbWater(p_220082_2_, p_220082_3_);
        }
        super.func_220082_b(p_220082_1_, p_220082_2_, p_220082_3_, p_220082_4_, p_220082_5_);
    }

    public void func_220069_a(BlockState state, World p_220069_2_, BlockPos p_220069_3_, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (state.func_177230_c() == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
            this.tryAbsorbWater(p_220069_2_, p_220069_3_);
        }
        super.func_220069_a(state, p_220069_2_, p_220069_3_, p_220069_4_, p_220069_5_, p_220069_6_);
    }

    public void tryAbsorbWater(World world, BlockPos pos) {
        TravelersBackpackTileEntity tile;
        if (world.func_175625_s(pos) instanceof TravelersBackpackTileEntity && (tile = (TravelersBackpackTileEntity)world.func_175625_s(pos)).getAbilityValue() && (tile.getLeftTank().isEmpty() || tile.getLeftTank().getFluid().getFluid().func_207187_a((Fluid)Fluids.field_204546_a) && tile.getLeftTank().getFluidAmount() < tile.getLeftTank().getCapacity() || tile.getRightTank().isEmpty() || tile.getRightTank().getFluid().getFluid().func_207187_a((Fluid)Fluids.field_204546_a) && tile.getRightTank().getFluidAmount() < tile.getRightTank().getCapacity()) && this.removeWaterBreadthFirstSearch(world, pos, tile)) {
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)Blocks.field_150355_j.func_176223_P()));
        }
    }

    private boolean removeWaterBreadthFirstSearch(World world, BlockPos pos, TravelersBackpackTileEntity tile) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)pos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.func_76341_a();
            int j = (Integer)tuple.func_76340_b();
            for (Direction direction : Direction.values()) {
                BlockPos blockpos1 = blockpos.func_177972_a(direction);
                BlockState blockstate = world.func_180495_p(blockpos1);
                FluidState fluidstate = world.func_204610_c(blockpos1);
                Material material = blockstate.func_185904_a();
                if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                if (blockstate.func_177230_c() instanceof IBucketPickupHandler && ((IBucketPickupHandler)blockstate.func_177230_c()).func_204508_a((IWorld)world, blockpos1, blockstate) != Fluids.field_204541_a) {
                    ++i;
                    if (tile.getLeftTank().isEmpty() || tile.getLeftTank().getFluid().getFluid().func_207187_a((Fluid)Fluids.field_204546_a) && tile.getLeftTank().getFluidAmount() < tile.getLeftTank().getCapacity()) {
                        tile.getLeftTank().fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
                    } else if (tile.getRightTank().isEmpty() || tile.getRightTank().getFluid().getFluid().func_207187_a((Fluid)Fluids.field_204546_a) && tile.getRightTank().getFluidAmount() < tile.getRightTank().getCapacity()) {
                        tile.getRightTank().fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
                    }
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (blockstate.func_177230_c() instanceof FlowingFluidBlock) {
                    world.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 3);
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (material != Material.field_203243_f && material != Material.field_204868_h) continue;
                TileEntity tileentity = blockstate.hasTileEntity() ? world.func_175625_s(blockpos1) : null;
                TravelersBackpackBlock.func_220059_a((BlockState)blockstate, (IWorld)world, (BlockPos)blockpos1, (TileEntity)tileentity);
                world.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 3);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        return i > 0;
    }
}

