/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.screen.ScreenImageButton;
import com.tiviacz.travelersbackpack.client.screen.TankScreen;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackBaseContainer;
import com.tiviacz.travelersbackpack.network.SAbilitySliderPacket;
import com.tiviacz.travelersbackpack.network.SEquipBackpackPacket;
import com.tiviacz.travelersbackpack.network.SSleepingBagPacket;
import com.tiviacz.travelersbackpack.network.SSlotPacket;
import com.tiviacz.travelersbackpack.network.SSorterPacket;
import com.tiviacz.travelersbackpack.network.SSpecialActionPacket;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import java.util.ArrayList;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TravelersBackpackScreen
extends ContainerScreen<TravelersBackpackBaseContainer> {
    public static final ResourceLocation SCREEN_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/travelers_backpack.png");
    private static final ScreenImageButton BED_BUTTON = new ScreenImageButton(5, 96, 18, 18);
    private static final ScreenImageButton EQUIP_BUTTON = new ScreenImageButton(5, 96, 18, 18);
    private static final ScreenImageButton UNEQUIP_BUTTON = new ScreenImageButton(5, 96, 18, 18);
    private static final ScreenImageButton DISABLED_CRAFTING_BUTTON = new ScreenImageButton(225, 96, 18, 18);
    private static final ScreenImageButton ABILITY_SLIDER = new ScreenImageButton(5, 56, 18, 11);
    private static final ScreenImageButton SORT_BUTTON = new ScreenImageButton(61, -10, 14, 13);
    private static final ScreenImageButton QUICK_STACK_BUTTON = new ScreenImageButton(75, -10, 11, 13);
    private static final ScreenImageButton TRANSFER_TO_BACKPACK_BUTTON = new ScreenImageButton(86, -10, 11, 13);
    private static final ScreenImageButton TRANSFER_TO_PLAYER_BUTTON = new ScreenImageButton(97, -10, 14, 13);
    private final ITravelersBackpackInventory inv;
    private final byte screenID;
    private final TankScreen tankLeft;
    private final TankScreen tankRight;

    public TravelersBackpackScreen(TravelersBackpackBaseContainer screenContainer, PlayerInventory inventory, ITextComponent titleIn) {
        super((Container)screenContainer, inventory, titleIn);
        this.inv = screenContainer.inventory;
        this.screenID = screenContainer.inventory.getScreenID();
        this.field_147003_i = 0;
        this.field_147009_r = 0;
        this.field_146999_f = 248;
        this.field_147000_g = 207;
        this.tankLeft = new TankScreen(this.inv.getLeftTank(), 25, 7, 100, 16);
        this.tankRight = new TankScreen(this.inv.getRightTank(), 207, 7, 100, 16);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (!this.inv.getLeftTank().isEmpty()) {
            this.tankLeft.drawScreenFluidBar(matrixStack);
        }
        if (!this.inv.getRightTank().isEmpty()) {
            this.tankRight.drawScreenFluidBar(matrixStack);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ArrayList<IReorderingProcessor> list;
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        if (this.tankLeft.inTank(this, mouseX, mouseY)) {
            this.func_243308_b(matrixStack, this.tankLeft.getTankTooltip(), mouseX, mouseY);
        }
        if (this.tankRight.inTank(this, mouseX, mouseY)) {
            this.func_243308_b(matrixStack, this.tankRight.getTankTooltip(), mouseX, mouseY);
        }
        if (BackpackUtils.isShiftPressed()) {
            if (SORT_BUTTON.inButton(this, mouseX, mouseY, 65)) {
                list = new ArrayList<IReorderingProcessor>();
                list.add(new TranslationTextComponent("screen.travelersbackpack.sort").func_241878_f());
                list.add(new TranslationTextComponent("screen.travelersbackpack.sort_shift").func_241878_f());
                this.func_238654_b_(matrixStack, list, mouseX, mouseY);
            }
            if (QUICK_STACK_BUTTON.inButton(this, mouseX, mouseY, 76)) {
                list = new ArrayList();
                list.add(new TranslationTextComponent("screen.travelersbackpack.quick_stack").func_241878_f());
                list.add(new TranslationTextComponent("screen.travelersbackpack.quick_stack_shift").func_241878_f());
                this.func_238654_b_(matrixStack, list, mouseX, mouseY);
            }
            if (TRANSFER_TO_BACKPACK_BUTTON.inButton(this, mouseX, mouseY, 87)) {
                list = new ArrayList();
                list.add(new TranslationTextComponent("screen.travelersbackpack.transfer_to_backpack").func_241878_f());
                list.add(new TranslationTextComponent("screen.travelersbackpack.transfer_to_backpack_shift").func_241878_f());
                this.func_238654_b_(matrixStack, list, mouseX, mouseY);
            }
            if (TRANSFER_TO_PLAYER_BUTTON.inButton(this, mouseX, mouseY, 98)) {
                this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("screen.travelersbackpack.transfer_to_player"), mouseX, mouseY);
            }
        }
        if ((this.screenID == 3 || this.screenID == 2) && BackpackAbilities.isOnList(this.screenID == 2 ? BackpackAbilities.ITEM_ABILITIES_LIST : BackpackAbilities.BLOCK_ABILITIES_LIST, this.inv.getItemStack()) && ABILITY_SLIDER.inButton(this, mouseX, mouseY)) {
            if (this.inv.getAbilityValue()) {
                list = new ArrayList();
                list.add(new TranslationTextComponent("screen.travelersbackpack.ability_enabled").func_241878_f());
                if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_TIMER_ABILITIES_LIST, this.inv.getItemStack())) {
                    list.add(this.inv.getLastTime() == 0 ? new TranslationTextComponent("screen.travelersbackpack.ability_ready").func_241878_f() : new StringTextComponent(BackpackUtils.getConvertedTime(this.inv.getLastTime())).func_241878_f());
                }
                this.func_238654_b_(matrixStack, list, mouseX, mouseY);
            } else if (!TravelersBackpackConfig.enableBackpackAbilities) {
                this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("screen.travelersbackpack.ability_disabled_config"), mouseX, mouseY);
            } else {
                this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("screen.travelersbackpack.ability_disabled"), mouseX, mouseY);
            }
        }
        if (TravelersBackpackConfig.disableCrafting && DISABLED_CRAFTING_BUTTON.inButton(this, mouseX, mouseY)) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("screen.travelersbackpack.disabled_crafting"), mouseX, mouseY);
        }
    }

    public int getX(int slot) {
        if (slot <= 7) {
            return 62 + 18 * slot;
        }
        if (slot >= 8 && slot <= 15) {
            return 62 + 18 * (slot - 8);
        }
        if (slot >= 16 && slot <= 23) {
            return 62 + 18 * (slot - 16);
        }
        if (slot >= 24 && slot <= 28) {
            return 62 + 18 * (slot - 24);
        }
        if (slot >= 29 && slot <= 33) {
            return 62 + 18 * (slot - 29);
        }
        if (slot >= 34 && slot <= 38) {
            return 62 + 18 * (slot - 34);
        }
        return 0;
    }

    public int getY(int slot) {
        if (slot <= 7) {
            return 7;
        }
        if (slot <= 15) {
            return 25;
        }
        if (slot <= 23) {
            return 43;
        }
        if (slot <= 28) {
            return 61;
        }
        if (slot <= 33) {
            return 79;
        }
        if (slot <= 38) {
            return 97;
        }
        return 0;
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(SCREEN_TRAVELERS_BACKPACK);
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (TravelersBackpackConfig.disableCrafting) {
            DISABLED_CRAFTING_BUTTON.draw(matrixStack, this, 77, 208);
        }
        if (!this.inv.getSlotManager().getUnsortableSlots().isEmpty()) {
            this.inv.getSlotManager().getUnsortableSlots().forEach(i -> this.func_238474_b_(matrixStack, this.getGuiLeft() + this.getX((int)i), this.getGuiTop() + this.getY((int)i), 78, 228, 16, 16));
        }
        if (SORT_BUTTON.inButton(this, mouseX, mouseY, 65)) {
            SORT_BUTTON.draw(matrixStack, this, 134, 222);
        } else {
            SORT_BUTTON.draw(matrixStack, this, 134, 208);
        }
        if (this.inv.getSlotManager().isActive()) {
            SORT_BUTTON.draw(matrixStack, this, 134, 236);
        }
        if (QUICK_STACK_BUTTON.inButton(this, mouseX, mouseY, 76)) {
            QUICK_STACK_BUTTON.draw(matrixStack, this, 148, 222);
        } else {
            QUICK_STACK_BUTTON.draw(matrixStack, this, 148, 208);
        }
        if (TRANSFER_TO_BACKPACK_BUTTON.inButton(this, mouseX, mouseY, 87)) {
            TRANSFER_TO_BACKPACK_BUTTON.draw(matrixStack, this, 159, 222);
        } else {
            TRANSFER_TO_BACKPACK_BUTTON.draw(matrixStack, this, 159, 208);
        }
        if (TRANSFER_TO_PLAYER_BUTTON.inButton(this, mouseX, mouseY, 98)) {
            TRANSFER_TO_PLAYER_BUTTON.draw(matrixStack, this, 170, 222);
        } else {
            TRANSFER_TO_PLAYER_BUTTON.draw(matrixStack, this, 170, 208);
        }
        if (this.inv.hasTileEntity()) {
            if (BED_BUTTON.inButton(this, mouseX, mouseY)) {
                BED_BUTTON.draw(matrixStack, this, 20, 227);
            } else {
                BED_BUTTON.draw(matrixStack, this, 1, 227);
            }
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.inv.getItemStack())) {
                if (ABILITY_SLIDER.inButton(this, mouseX, mouseY)) {
                    if (this.inv.getAbilityValue()) {
                        ABILITY_SLIDER.draw(matrixStack, this, 115, 208);
                    } else {
                        ABILITY_SLIDER.draw(matrixStack, this, 115, 220);
                    }
                } else if (this.inv.getAbilityValue()) {
                    ABILITY_SLIDER.draw(matrixStack, this, 96, 208);
                } else {
                    ABILITY_SLIDER.draw(matrixStack, this, 96, 220);
                }
            }
        } else {
            if (!CapabilityUtils.isWearingBackpack(this.field_213127_e.field_70458_d) && this.screenID == 1 && !TravelersBackpack.enableCurios()) {
                if (EQUIP_BUTTON.inButton(this, mouseX, mouseY)) {
                    EQUIP_BUTTON.draw(matrixStack, this, 58, 208);
                } else {
                    EQUIP_BUTTON.draw(matrixStack, this, 39, 208);
                }
            }
            if (CapabilityUtils.isWearingBackpack(this.field_213127_e.field_70458_d) && this.screenID == 2) {
                if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.inv.getItemStack())) {
                    if (ABILITY_SLIDER.inButton(this, mouseX, mouseY)) {
                        if (this.inv.getAbilityValue()) {
                            ABILITY_SLIDER.draw(matrixStack, this, 115, 208);
                        } else {
                            ABILITY_SLIDER.draw(matrixStack, this, 115, 220);
                        }
                    } else if (this.inv.getAbilityValue()) {
                        ABILITY_SLIDER.draw(matrixStack, this, 96, 208);
                    } else {
                        ABILITY_SLIDER.draw(matrixStack, this, 96, 220);
                    }
                }
                if (!TravelersBackpack.enableCurios()) {
                    if (UNEQUIP_BUTTON.inButton(this, mouseX, mouseY)) {
                        UNEQUIP_BUTTON.draw(matrixStack, this, 58, 227);
                    } else {
                        UNEQUIP_BUTTON.draw(matrixStack, this, 39, 227);
                    }
                }
            }
        }
    }

    protected void func_184098_a(Slot slot, int slotId, int button, ClickType type) {
        super.func_184098_a(slot, slotId, button, type);
        if (slotId >= 10 && slotId <= 48 && this.inv.getSlotManager().isActive()) {
            this.inv.getSlotManager().setUnsortableSlot(slotId - 10);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.inv.getSlotManager().isActive() && !SORT_BUTTON.inButton(this, (int)mouseX, (int)mouseY, 65)) {
            return super.func_231044_a_(mouseX, mouseY, button);
        }
        if (SORT_BUTTON.inButton(this, (int)mouseX, (int)mouseY, 65)) {
            TravelersBackpack.NETWORK.sendToServer((Object)new SSorterPacket(this.inv.getScreenID(), 0, BackpackUtils.isShiftPressed()));
            if (BackpackUtils.isShiftPressed()) {
                TravelersBackpack.NETWORK.sendToServer((Object)new SSlotPacket(this.inv.getScreenID(), this.inv.getSlotManager().isActive(), this.inv.getSlotManager().getUnsortableSlots().stream().mapToInt(i -> i).toArray()));
                this.inv.getSlotManager().setActive(!this.inv.getSlotManager().isActive());
            }
            this.playUIClickSound();
            return true;
        }
        if (QUICK_STACK_BUTTON.inButton(this, (int)mouseX, (int)mouseY, 76)) {
            TravelersBackpack.NETWORK.sendToServer((Object)new SSorterPacket(this.inv.getScreenID(), 1, BackpackUtils.isShiftPressed()));
            this.playUIClickSound();
            return true;
        }
        if (TRANSFER_TO_BACKPACK_BUTTON.inButton(this, (int)mouseX, (int)mouseY, 87)) {
            TravelersBackpack.NETWORK.sendToServer((Object)new SSorterPacket(this.inv.getScreenID(), 2, BackpackUtils.isShiftPressed()));
            this.playUIClickSound();
            return true;
        }
        if (TRANSFER_TO_PLAYER_BUTTON.inButton(this, (int)mouseX, (int)mouseY, 98)) {
            TravelersBackpack.NETWORK.sendToServer((Object)new SSorterPacket(this.inv.getScreenID(), 3, BackpackUtils.isShiftPressed()));
            this.playUIClickSound();
            return true;
        }
        if (!this.inv.getLeftTank().isEmpty() && this.tankLeft.inTank(this, (int)mouseX, (int)mouseY) && BackpackUtils.isShiftPressed()) {
            TravelersBackpack.NETWORK.sendToServer((Object)new SSpecialActionPacket(this.inv.getScreenID(), 3, 1.0));
            if (this.inv.getScreenID() == 1) {
                ServerActions.emptyTank(1.0, this.field_213127_e.field_70458_d, this.inv.getLevel(), this.inv.getScreenID());
            }
        }
        if (!this.inv.getRightTank().isEmpty() && this.tankRight.inTank(this, (int)mouseX, (int)mouseY) && BackpackUtils.isShiftPressed()) {
            TravelersBackpack.NETWORK.sendToServer((Object)new SSpecialActionPacket(this.inv.getScreenID(), 3, 2.0));
            if (this.inv.getScreenID() == 1) {
                ServerActions.emptyTank(2.0, this.field_213127_e.field_70458_d, this.inv.getLevel(), this.inv.getScreenID());
            }
        }
        if (this.inv.hasTileEntity()) {
            if (BED_BUTTON.inButton(this, (int)mouseX, (int)mouseY)) {
                TravelersBackpack.NETWORK.sendToServer((Object)new SSleepingBagPacket(this.inv.getPosition()));
                return true;
            }
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.inv.getItemStack()) && ABILITY_SLIDER.inButton(this, (int)mouseX, (int)mouseY)) {
                TravelersBackpack.NETWORK.sendToServer((Object)new SAbilitySliderPacket(this.inv.getScreenID(), !this.inv.getAbilityValue()));
                this.playUIClickSound();
                return true;
            }
        }
        if (!this.inv.hasTileEntity()) {
            if (!TravelersBackpack.enableCurios()) {
                if (!CapabilityUtils.isWearingBackpack(this.field_213127_e.field_70458_d) && this.screenID == 1 && EQUIP_BUTTON.inButton(this, (int)mouseX, (int)mouseY)) {
                    TravelersBackpack.NETWORK.sendToServer((Object)new SEquipBackpackPacket(true));
                    return true;
                }
                if (CapabilityUtils.isWearingBackpack(this.field_213127_e.field_70458_d) && this.screenID == 2 && UNEQUIP_BUTTON.inButton(this, (int)mouseX, (int)mouseY)) {
                    TravelersBackpack.NETWORK.sendToServer((Object)new SEquipBackpackPacket(false));
                    return true;
                }
            }
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.inv.getItemStack()) && ABILITY_SLIDER.inButton(this, (int)mouseX, (int)mouseY)) {
                TravelersBackpack.NETWORK.sendToServer((Object)new SAbilitySliderPacket(this.inv.getScreenID(), !this.inv.getAbilityValue()));
                this.playUIClickSound();
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void playUIClickSound() {
        this.field_213127_e.field_70458_d.field_70170_p.func_184133_a(this.field_213127_e.field_70458_d, this.field_213127_e.field_70458_d.func_233580_cy_(), SoundEvents.field_187909_gi, SoundCategory.MASTER, 1.0f, 1.0f);
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (ModClientEventHandler.OPEN_INVENTORY.isActiveAndMatches(InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            ClientPlayerEntity playerEntity = this.getMinecraft().field_71439_g;
            if (playerEntity != null) {
                this.func_231175_as__();
            }
            return true;
        }
        return super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }
}

