/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="travelersbackpack", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TravelersBackpackConfig {
    public static boolean curiosIntegration;
    public static boolean backpackDeathPlace;
    public static boolean backpackForceDeathPlace;
    public static boolean enableSleepingBagSpawnPoint;
    public static boolean enableLoot;
    public static boolean toolSlotsAcceptSwords;
    public static boolean disableCrafting;
    public static boolean enableBackpackBlockWearable;
    public static boolean invulnerableBackpack;
    public static boolean enableBackpackAbilities;
    public static int tanksCapacity;
    public static boolean displayWarning;
    public static boolean enableToolCycling;
    public static boolean disableScrollWheel;
    public static boolean obtainTips;
    public static boolean renderTools;
    public static boolean renderBackpackWithElytra;
    public static boolean disableBackpackRender;
    public static boolean enableOverlay;
    public static int offsetX;
    public static int offsetY;
    private static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    private static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, commonSpec);
        context.registerConfig(ModConfig.Type.CLIENT, clientSpec);
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == commonSpec) {
            TravelersBackpackConfig.bakeCommonConfig();
        }
        if (configEvent.getConfig().getSpec() == clientSpec) {
            TravelersBackpackConfig.bakeClientConfig();
        }
    }

    public static void bakeCommonConfig() {
        curiosIntegration = (Boolean)TravelersBackpackConfig.COMMON.curiosIntegration.get();
        backpackDeathPlace = (Boolean)TravelersBackpackConfig.COMMON.backpackDeathPlace.get();
        backpackForceDeathPlace = (Boolean)TravelersBackpackConfig.COMMON.backpackForceDeathPlace.get();
        enableSleepingBagSpawnPoint = (Boolean)TravelersBackpackConfig.COMMON.enableSleepingBagSpawnPoint.get();
        enableLoot = (Boolean)TravelersBackpackConfig.COMMON.enableLoot.get();
        toolSlotsAcceptSwords = (Boolean)TravelersBackpackConfig.COMMON.toolSlotsAcceptSwords.get();
        enableBackpackBlockWearable = (Boolean)TravelersBackpackConfig.COMMON.enableBackpackBlockWearable.get();
        disableCrafting = (Boolean)TravelersBackpackConfig.COMMON.disableCrafting.get();
        invulnerableBackpack = (Boolean)TravelersBackpackConfig.COMMON.invulnerableBackpack.get();
        enableBackpackAbilities = (Boolean)TravelersBackpackConfig.COMMON.enableBackpackAbilities.get();
        tanksCapacity = (Integer)TravelersBackpackConfig.COMMON.tanksCapacity.get();
    }

    public static void bakeClientConfig() {
        displayWarning = (Boolean)TravelersBackpackConfig.CLIENT.displayWarning.get();
        enableToolCycling = (Boolean)TravelersBackpackConfig.CLIENT.enableToolCycling.get();
        disableScrollWheel = (Boolean)TravelersBackpackConfig.CLIENT.disableScrollWheel.get();
        obtainTips = (Boolean)TravelersBackpackConfig.CLIENT.obtainTips.get();
        renderTools = (Boolean)TravelersBackpackConfig.CLIENT.renderTools.get();
        renderBackpackWithElytra = (Boolean)TravelersBackpackConfig.CLIENT.renderBackpackWithElytra.get();
        disableBackpackRender = (Boolean)TravelersBackpackConfig.CLIENT.disableBackpackRender.get();
        enableOverlay = (Boolean)TravelersBackpackConfig.CLIENT.overlay.enableOverlay.get();
        offsetX = (Integer)TravelersBackpackConfig.CLIENT.overlay.offsetX.get();
        offsetY = (Integer)TravelersBackpackConfig.CLIENT.overlay.offsetY.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue displayWarning;
        public final ForgeConfigSpec.BooleanValue enableToolCycling;
        public final ForgeConfigSpec.BooleanValue disableScrollWheel;
        public final ForgeConfigSpec.BooleanValue obtainTips;
        public final ForgeConfigSpec.BooleanValue renderTools;
        public final ForgeConfigSpec.BooleanValue renderBackpackWithElytra;
        public final ForgeConfigSpec.BooleanValue disableBackpackRender;
        public final Overlay overlay;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client-only settings").push("client");
            this.displayWarning = builder.comment("Displays warning about item deletion after updating from older version").define("displayWarning", true);
            this.enableToolCycling = builder.comment("Enables tool cycling via keybind (Default Z) + scroll combination, while backpack is worn").define("enableToolCycling", true);
            this.disableScrollWheel = builder.comment("Allows tool cycling using keybinding only (Default Z)").define("disableScrollWheel", false);
            this.obtainTips = builder.comment("Enables tip, how to obtain a backpack, if there's no crafting recipe for it").define("obtainTips", true);
            this.renderTools = builder.comment("Render tools in tool slots on the backpack, while worn").define("renderTools", true);
            this.renderBackpackWithElytra = builder.comment("Render backpack if elytra is present").define("renderBackpackWithElytra", true);
            this.disableBackpackRender = builder.comment("Disable backpack rendering").define("disableBackpackRender", false);
            this.overlay = new Overlay(builder, "The position of the Overlay on the screen", "overlay", true, 20, 30);
            builder.pop();
        }

        public static class Overlay {
            public final ForgeConfigSpec.BooleanValue enableOverlay;
            public final ForgeConfigSpec.IntValue offsetX;
            public final ForgeConfigSpec.IntValue offsetY;

            Overlay(ForgeConfigSpec.Builder builder, String comment, String path, boolean defaultOverlay, int defaultX, int defaultY) {
                builder.comment(comment).push(path);
                this.enableOverlay = builder.comment("Enables tanks and tool slots overlay, while backpack is worn").define("enableOverlay", defaultOverlay);
                this.offsetX = builder.comment("Offsets to left side").defineInRange("offsetX", defaultX, Integer.MIN_VALUE, Integer.MAX_VALUE);
                this.offsetY = builder.comment("Offsets to up").defineInRange("offsetY", defaultY, Integer.MIN_VALUE, Integer.MAX_VALUE);
                builder.pop();
            }
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue curiosIntegration;
        public final ForgeConfigSpec.BooleanValue backpackDeathPlace;
        public final ForgeConfigSpec.BooleanValue backpackForceDeathPlace;
        public final ForgeConfigSpec.BooleanValue enableSleepingBagSpawnPoint;
        public final ForgeConfigSpec.BooleanValue enableLoot;
        public final ForgeConfigSpec.BooleanValue toolSlotsAcceptSwords;
        public final ForgeConfigSpec.BooleanValue disableCrafting;
        public final ForgeConfigSpec.BooleanValue enableBackpackBlockWearable;
        public final ForgeConfigSpec.BooleanValue invulnerableBackpack;
        public final ForgeConfigSpec.BooleanValue enableBackpackAbilities;
        public final ForgeConfigSpec.IntValue tanksCapacity;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common config settings").push("common");
            this.curiosIntegration = builder.comment(new String[]{"If true, backpack can only be worn by placing it in curios 'Back' slot", "WARNING - Remember to TAKE OFF BACKPACK BEFORE enabling or disabling this integration!! - if not you'll lose your backpack"}).define("curiosIntegration", false);
            this.backpackDeathPlace = builder.comment("Places backpack at place where player died").define("backpackDeathPlace", true);
            this.backpackForceDeathPlace = builder.comment("Places backpack at place where player died, replacing all blocks that are breakable and do not have inventory (backpackDeathPlace must be true in order to work)").define("backpackForceDeathPlace", false);
            this.enableSleepingBagSpawnPoint = builder.define("enableSleepingBagSpawnPoint", false);
            this.enableLoot = builder.comment("Enables backpacks spawning in loot chests").define("enableLoot", true);
            this.toolSlotsAcceptSwords = builder.define("toolSlotsAcceptSwords", true);
            this.disableCrafting = builder.define("disableCrafting", false);
            this.enableBackpackBlockWearable = builder.comment("Enables wearing backpack directly from ground").define("enableBackpackBlockWearable", true);
            this.invulnerableBackpack = builder.comment("Backpack immune to any damage source (lava, fire), can't be destroyed, never disappears as floating item").define("invulnerableBackpack", true);
            this.enableBackpackAbilities = builder.define("enableBackpackAbilities", true);
            this.tanksCapacity = builder.defineInRange("tanksCapacity", 4000, 250, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

