/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.util.FluidUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PotionItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryActions {
    public static boolean transferContainerTank(ITravelersBackpackInventory inv, FluidTank tank, int slotIn, @Nullable PlayerEntity player) {
        LazyOptional container;
        ItemStackHandler inventory = inv.getInventory();
        ItemStack stackIn = inventory.getStackInSlot(slotIn);
        int slotOut = slotIn + 1;
        if (tank == null || stackIn.func_190926_b() || stackIn.func_77973_b() == Items.field_190931_a) {
            return false;
        }
        if (stackIn.func_77973_b() instanceof PotionItem && stackIn.func_77973_b() != Items.field_151069_bo) {
            int amount = 250;
            FluidStack fluidStack = new FluidStack((Fluid)ModFluids.POTION_FLUID.get(), amount);
            FluidUtils.setFluidStackNBT(stackIn, fluidStack);
            if ((tank.isEmpty() || FluidStack.areFluidStackTagsEqual((FluidStack)tank.getFluid(), (FluidStack)fluidStack)) && tank.getFluidAmount() + amount <= tank.getCapacity()) {
                ItemStack bottle = new ItemStack((IItemProvider)Items.field_151069_bo);
                ItemStack currentStackOut = inventory.getStackInSlot(slotOut);
                if (currentStackOut.func_190926_b() || currentStackOut.func_77973_b() == bottle.func_77973_b()) {
                    if (currentStackOut.func_77973_b() == bottle.func_77973_b()) {
                        if (currentStackOut.func_190916_E() + 1 > currentStackOut.func_77976_d()) {
                            return false;
                        }
                        bottle.func_190920_e(inventory.getStackInSlot(slotOut).func_190916_E() + 1);
                    }
                    tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    inv.decrStackSize(slotIn, 1);
                    inventory.setStackInSlot(slotOut, bottle);
                    inv.setDataChanged(3);
                    if (player != null) {
                        player.field_70170_p.func_184148_a(null, player.func_213303_ch().func_82615_a(), player.func_213303_ch().func_82617_b() + 0.5, player.func_213303_ch().func_82616_c(), SoundEvents.field_187621_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    return true;
                }
            }
        }
        if (stackIn.func_77973_b() == Items.field_151069_bo && tank.getFluid().getFluid() == ModFluids.POTION_FLUID.get() && tank.getFluidAmount() >= 250) {
            ItemStack stackOut = FluidUtils.getItemStackFromFluidStack(tank.getFluid());
            ItemStack currentStackOut = inventory.getStackInSlot(slotOut);
            if (currentStackOut.func_190926_b()) {
                tank.drain(250, IFluidHandler.FluidAction.EXECUTE);
                inv.decrStackSize(slotIn, 1);
                inventory.setStackInSlot(slotOut, stackOut);
                inv.setDataChanged(3);
                if (player != null) {
                    player.field_70170_p.func_184148_a(null, player.func_213303_ch().func_82615_a(), player.func_213303_ch().func_82617_b() + 0.5, player.func_213303_ch().func_82616_c(), SoundEvents.field_187621_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
        }
        if ((container = FluidUtil.getFluidHandler((ItemStack)stackIn)).isPresent()) {
            ItemStack slotOutStack;
            ItemStack stackOut;
            FluidTank tankCopy;
            ItemStack stackInCopy;
            Optional fluidstack = FluidUtil.getFluidContained((ItemStack)stackIn);
            if (fluidstack.isPresent() && fluidstack.map(FluidStack::getAmount).orElse(0) > 0) {
                int amount = fluidstack.map(FluidStack::getAmount).orElse(0);
                if (tank.getFluidAmount() + amount > tank.getCapacity()) {
                    return false;
                }
                if (tank.getFluidAmount() > 0 && !tank.getFluid().isFluidEqual(fluidstack.orElse(FluidStack.EMPTY))) {
                    return false;
                }
                stackInCopy = stackIn.func_77946_l();
                tankCopy = new FluidTank(tank.getCapacity());
                tankCopy.fill(tank.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                stackOut = FluidUtil.tryEmptyContainer((ItemStack)stackInCopy, (IFluidHandler)tankCopy, (int)amount, (PlayerEntity)player, (boolean)false).getResult();
                if (stackOut.func_190926_b()) {
                    return false;
                }
                slotOutStack = inventory.getStackInSlot(slotOut);
                if (slotOutStack.func_190926_b() || slotOutStack.func_77973_b() == stackOut.func_77973_b()) {
                    if (slotOutStack.func_77973_b() == stackOut.func_77973_b()) {
                        stackOut.func_190920_e(slotOutStack.func_190916_E() + 1);
                        if (stackOut.func_190916_E() > slotOutStack.func_77976_d()) {
                            return false;
                        }
                    }
                    FluidUtil.tryEmptyContainer((ItemStack)stackIn, (IFluidHandler)tank, (int)amount, (PlayerEntity)player, (boolean)true);
                    inventory.setStackInSlot(slotOut, stackOut);
                    inv.decrStackSize(slotIn, 1);
                    inv.setDataChanged(3);
                    return true;
                }
            }
            if (tank.isEmpty() || tank.getFluidAmount() <= 0) {
                return false;
            }
            if (InventoryActions.isFluidEqual(stackIn, tank)) {
                int amount = FluidUtil.getFluidHandler((ItemStack)stackIn).map(iFluidHandlerItem -> iFluidHandlerItem.getTankCapacity(0)).orElse(0);
                stackInCopy = stackIn.func_77946_l();
                tankCopy = new FluidTank(tank.getCapacity());
                tankCopy.fill(tank.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                stackOut = FluidUtil.tryFillContainer((ItemStack)stackInCopy, (IFluidHandler)tankCopy, (int)amount, (PlayerEntity)player, (boolean)true).getResult();
                if (stackOut.func_190926_b()) {
                    return false;
                }
                slotOutStack = inventory.getStackInSlot(slotOut);
                if (slotOutStack.func_190926_b() || slotOutStack.func_77973_b() == stackOut.func_77973_b()) {
                    if (slotOutStack.func_77973_b() == stackOut.func_77973_b()) {
                        stackOut.func_190920_e(slotOutStack.func_190916_E() + 1);
                        if (stackOut.func_190916_E() > slotOutStack.func_77976_d()) {
                            return false;
                        }
                    }
                    FluidUtil.tryFillContainer((ItemStack)stackIn, (IFluidHandler)tank, (int)amount, (PlayerEntity)player, (boolean)true);
                    inventory.setStackInSlot(slotOut, stackOut);
                    inv.decrStackSize(slotIn, 1);
                    inv.setDataChanged(3);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isFluidEqual(ItemStack stackIn, FluidTank tank) {
        if (FluidUtil.getFluidContained((ItemStack)stackIn).isPresent() && FluidUtil.getFluidContained((ItemStack)stackIn).map(FluidStack::getAmount).orElse(0) > 0) {
            return FluidUtil.getFluidContained((ItemStack)stackIn).map(fluidstack -> fluidstack.isFluidEqual(tank.getFluid())).orElse(false);
        }
        return !FluidUtil.getFluidContained((ItemStack)stackIn).isPresent();
    }
}

