/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;

public class SlotManager {
    protected final ITravelersBackpackInventory inventory;
    protected List<Integer> unsortableSlots = new ArrayList<Integer>();
    protected boolean isActive = false;
    private final String UNSORTABLE_SLOTS = "UnsortableSlots";

    public SlotManager(ITravelersBackpackInventory inventory) {
        this.inventory = inventory;
    }

    public List<Integer> getUnsortableSlots() {
        return this.unsortableSlots;
    }

    public boolean hasSlot(int slot) {
        return this.unsortableSlots.contains(slot);
    }

    public void setUnsortableSlots(int[] slots, boolean isFinal) {
        if (this.isActive()) {
            this.unsortableSlots = Arrays.stream(slots).boxed().collect(Collectors.toList());
            if (isFinal) {
                this.setChanged();
            }
        }
    }

    public void setUnsortableSlot(int slot) {
        if (this.isActive() && slot <= 38) {
            if (this.hasSlot(slot)) {
                this.unsortableSlots.remove((Object)slot);
            } else {
                this.unsortableSlots.add(slot);
            }
        }
    }

    public void setChanged() {
        if (this.inventory.getScreenID() != 3) {
            this.inventory.setDataChanged(7);
        } else {
            this.inventory.setChanged();
        }
    }

    public void clearSlots() {
        this.unsortableSlots = new ArrayList<Integer>();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean bool) {
        this.isActive = bool;
    }

    public void saveUnsortableSlots(CompoundNBT compound) {
        compound.func_74783_a("UnsortableSlots", this.getUnsortableSlots().stream().mapToInt(i -> i).toArray());
    }

    public void loadUnsortableSlots(CompoundNBT compound) {
        this.unsortableSlots = Arrays.stream(compound.func_74759_k("UnsortableSlots")).boxed().collect(Collectors.toList());
    }
}

