/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class CSyncCapabilityPacket {
    private final CompoundNBT compound;
    private final int entityID;

    public CSyncCapabilityPacket(CompoundNBT compound, int entityID) {
        this.compound = compound;
        this.entityID = entityID;
    }

    public static CSyncCapabilityPacket decode(PacketBuffer buffer) {
        CompoundNBT compound = buffer.func_150793_b();
        int entityID = buffer.readInt();
        return new CSyncCapabilityPacket(compound, entityID);
    }

    public static void encode(CSyncCapabilityPacket message, PacketBuffer buffer) {
        buffer.func_150786_a(message.compound);
        buffer.writeInt(message.entityID);
    }

    public static void handle(CSyncCapabilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            PlayerEntity playerEntity = (PlayerEntity)Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(message.entityID);
            ITravelersBackpack cap = (ITravelersBackpack)CapabilityUtils.getCapability(playerEntity).orElseThrow(() -> new RuntimeException("No player capability found!"));
            if (cap != null) {
                cap.setWearable(ItemStack.func_199557_a((CompoundNBT)message.compound));
                cap.setContents(ItemStack.func_199557_a((CompoundNBT)message.compound));
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

