/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.common.ServerActions;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SSorterPacket {
    private final byte screenID;
    private final byte button;
    private final boolean shiftPressed;

    public SSorterPacket(byte screenID, byte button, boolean shiftPressed) {
        this.screenID = screenID;
        this.button = button;
        this.shiftPressed = shiftPressed;
    }

    public static SSorterPacket decode(PacketBuffer buffer) {
        byte screenID = buffer.readByte();
        byte button = buffer.readByte();
        boolean shiftPressed = buffer.readBoolean();
        return new SSorterPacket(screenID, button, shiftPressed);
    }

    public static void encode(SSorterPacket message, PacketBuffer buffer) {
        buffer.writeByte((int)message.screenID);
        buffer.writeByte((int)message.button);
        buffer.writeBoolean(message.shiftPressed);
    }

    public static void handle(SSorterPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity serverPlayerEntity = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayerEntity != null) {
                ServerActions.sortBackpack((PlayerEntity)serverPlayerEntity, message.screenID, message.button, message.shiftPressed);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

