/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.tileentity.TravelersBackpackTileEntity;
import com.tiviacz.travelersbackpack.util.LogHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import org.lwjgl.glfw.GLFW;

public class BackpackUtils {
    public static void onPlayerDeath(World world, PlayerEntity player, ItemStack stack) {
        LazyOptional<ITravelersBackpack> cap = CapabilityUtils.getCapability(player);
        if (TravelersBackpackConfig.backpackDeathPlace) {
            if (TravelersBackpackConfig.backpackForceDeathPlace) {
                if (!BackpackUtils.forcePlace(world, player, stack)) {
                    player.func_70099_a(stack, 1.0f);
                    cap.ifPresent(ITravelersBackpack::removeWearable);
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("information.travelersbackpack.backpack_drop", new Object[]{player.func_233580_cy_().func_177958_n(), player.func_233580_cy_().func_177956_o(), player.func_233580_cy_().func_177952_p()}), player.func_110124_au());
                    LogHelper.info("There's no space for backpack. Dropping backpack item at X: " + player.func_233580_cy_().func_177958_n() + " Y: " + player.func_233580_cy_().func_177956_o() + " Z: " + player.func_233580_cy_().func_177952_p(), new Object[0]);
                }
            } else if (!BackpackUtils.tryPlace(world, player, stack)) {
                player.func_70099_a(stack, 1.0f);
                cap.ifPresent(ITravelersBackpack::removeWearable);
                player.func_145747_a((ITextComponent)new TranslationTextComponent("information.travelersbackpack.backpack_drop", new Object[]{player.func_233580_cy_().func_177958_n(), player.func_233580_cy_().func_177956_o(), player.func_233580_cy_().func_177952_p()}), player.func_110124_au());
                LogHelper.info("There's no space for backpack. Dropping backpack item at X: " + player.func_233580_cy_().func_177958_n() + " Y: " + player.func_233580_cy_().func_177956_o() + " Z: " + player.func_233580_cy_().func_177952_p(), new Object[0]);
            }
        } else {
            player.func_70099_a(stack, 1.0f);
            player.func_145747_a((ITextComponent)new TranslationTextComponent("information.travelersbackpack.backpack_drop", new Object[]{player.func_233580_cy_().func_177958_n(), player.func_233580_cy_().func_177956_o(), player.func_233580_cy_().func_177952_p()}), player.func_110124_au());
            LogHelper.info("There's no space for backpack. Dropping backpack item at X: " + player.func_233580_cy_().func_177958_n() + " Y: " + player.func_233580_cy_().func_177956_o() + " Z: " + player.func_233580_cy_().func_177952_p(), new Object[0]);
            cap.ifPresent(ITravelersBackpack::removeWearable);
        }
    }

    public static BlockPos findBlock3D(World world, int x, int y, int z, Block block, int hRange, int vRange) {
        for (int i = y - vRange; i <= y + vRange; ++i) {
            for (int j = x - hRange; j <= x + hRange; ++j) {
                for (int k = z - hRange; k <= z + hRange; ++k) {
                    if (world.func_180495_p(new BlockPos(j, i, k)).func_177230_c() != block) continue;
                    return new BlockPos(j, i, k);
                }
            }
        }
        return null;
    }

    private static boolean forcePlace(World world, PlayerEntity player, ItemStack stack) {
        BlockPos targetPos;
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        BlockPos playerPos = player.func_233580_cy_();
        int y = playerPos.func_177956_o();
        if (y <= 0 || y >= world.func_234938_ad_()) {
            for (int i = 1; i < world.func_234938_ad_(); ++i) {
                BlockPos pos = new BlockPos(playerPos.func_177958_n(), i, playerPos.func_177952_p());
                if (!world.func_175623_d(pos) && !(world.func_180495_p(pos).func_185887_b((IBlockReader)world, pos) > -1.0f)) continue;
                y = i;
                break;
            }
        }
        if (world.func_180495_p(targetPos = new BlockPos(playerPos.func_177958_n(), y, playerPos.func_177952_p())).func_185887_b((IBlockReader)world, targetPos) > -1.0f) {
            while (world.func_175625_s(targetPos) != null) {
                targetPos = targetPos.func_177984_a();
            }
            if (!world.func_175656_a(targetPos, block.func_176223_P())) {
                return false;
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("information.travelersbackpack.backpack_coords", new Object[]{targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p()}), player.func_110124_au());
            LogHelper.info("Your backpack has been placed at X: " + targetPos.func_177958_n() + " Y: " + targetPos.func_177956_o() + " Z: " + targetPos.func_177952_p(), new Object[0]);
            world.func_184148_a(player, (double)playerPos.func_177958_n(), (double)y, (double)playerPos.func_177952_p(), block.func_176223_P().func_215695_r().func_185841_e(), SoundCategory.BLOCKS, 0.5f, 1.0f);
            ((TravelersBackpackTileEntity)world.func_175625_s(targetPos)).loadAllData(stack.func_77978_p());
            if (CapabilityUtils.isWearingBackpack(player)) {
                CapabilityUtils.getCapability(player).ifPresent(cap -> {
                    cap.setWearable(ItemStack.field_190927_a);
                    cap.setContents(ItemStack.field_190927_a);
                });
            }
            return true;
        }
        return false;
    }

    private static boolean tryPlace(World world, PlayerEntity player, ItemStack stack) {
        int[] positions;
        int X = (int)player.func_226277_ct_();
        int Z = (int)player.func_226281_cx_();
        for (int Y : positions = new int[]{0, -1, 1, -2, 2, -3, 3, -4, 4, -5, 5, -6, 6}) {
            BlockPos spawn = BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, X, Z, new BlockPos(X, (int)player.func_226278_cu_() + Y, Z), 12, true, 1, (byte)0, false);
            if (spawn == null) continue;
            return BackpackUtils.placeBackpack(stack, player, world, spawn.func_177958_n(), spawn.func_177956_o(), spawn.func_177952_p(), Direction.UP);
        }
        return false;
    }

    public static boolean placeBackpack(ItemStack stack, PlayerEntity player, World world, int x, int y, int z, Direction facing) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (y <= 0 || y >= world.func_234938_ad_()) {
            return false;
        }
        BlockPos targetPos = new BlockPos(x, y, z);
        if (world.func_180495_p(targetPos).func_185904_a().func_76222_j() && !world.func_180495_p(targetPos).func_185904_a().func_76220_a()) {
            if (!world.func_175656_a(targetPos, block.func_176223_P())) {
                return false;
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("information.travelersbackpack.backpack_coords", new Object[]{targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p()}), player.func_110124_au());
            LogHelper.info("Your backpack has been placed at X: " + targetPos.func_177958_n() + " Y: " + targetPos.func_177956_o() + " Z: " + targetPos.func_177952_p(), new Object[0]);
            world.func_184148_a(player, (double)x, (double)y, (double)z, block.func_176223_P().func_215695_r().func_185841_e(), SoundCategory.BLOCKS, 0.5f, 1.0f);
            ((TravelersBackpackTileEntity)world.func_175625_s(targetPos)).loadAllData(stack.func_77978_p());
            if (stack.func_82837_s()) {
                ((TravelersBackpackTileEntity)world.func_175625_s(targetPos)).setCustomName(stack.func_151000_E());
            }
            if (CapabilityUtils.isWearingBackpack(player)) {
                CapabilityUtils.getCapability(player).ifPresent(cap -> {
                    cap.setWearable(ItemStack.field_190927_a);
                    cap.setContents(ItemStack.field_190927_a);
                });
            }
            return true;
        }
        return false;
    }

    public static String getConvertedTime(int ticks) {
        int i = ticks / 20;
        int minutes = i / 60;
        int seconds = i % 60;
        if (seconds < 10) {
            return minutes + ":0" + seconds;
        }
        return minutes + ":" + seconds;
    }

    public static boolean isShiftPressed() {
        return GLFW.glfwGetKey((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) == 1 || GLFW.glfwGetKey((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344) == 1;
    }

    public static BlockPos getNearestEmptyChunkCoordinatesSpiral(PlayerEntity player, World world, int origX, int origZ, BlockPos pos, int radius, boolean except, int steps, byte pass, boolean type) {
        int j;
        int i;
        if (steps >= radius) {
            return null;
        }
        if (steps % 2 == 0) {
            if (pass == 0) {
                for (i = pos.func_177958_n(); i <= pos.func_177958_n() + steps; ++i) {
                    BlockPos blockPos;
                    BlockPos blockPos2 = blockPos = type ? BackpackUtils.checkCoordsForPlayer(player, world, origX, origZ, pos, except) : BackpackUtils.checkCoordsForBackpack(player, world, origX, origZ, pos, except);
                    if (blockPos == null) continue;
                    return blockPos;
                }
                pass = (byte)(pass + 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, origX, origZ, new BlockPos(i, pos.func_177956_o(), j), radius, except, steps, pass, type);
            }
            if (pass == 1) {
                for (j = pos.func_177952_p(); j >= pos.func_177952_p() - steps; --j) {
                    BlockPos blockPos;
                    BlockPos blockPos3 = blockPos = type ? BackpackUtils.checkCoordsForPlayer(player, world, origX, origZ, pos, except) : BackpackUtils.checkCoordsForBackpack(player, world, origX, origZ, pos, except);
                    if (blockPos == null) continue;
                    return blockPos;
                }
                pass = (byte)(pass - 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, origX, origZ, new BlockPos(i, pos.func_177956_o(), j), radius, except, ++steps, pass, type);
            }
        }
        if (steps % 2 == 1) {
            if (pass == 0) {
                while (i >= pos.func_177958_n() - steps) {
                    BlockPos blockPos;
                    BlockPos blockPos4 = blockPos = type ? BackpackUtils.checkCoordsForPlayer(player, world, origX, origZ, pos, except) : BackpackUtils.checkCoordsForBackpack(player, world, origX, origZ, pos, except);
                    if (blockPos != null) {
                        return blockPos;
                    }
                    --i;
                }
                pass = (byte)(pass + 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, origX, origZ, new BlockPos(i, pos.func_177956_o(), j), radius, except, steps, pass, type);
            }
            if (pass == 1) {
                while (j <= pos.func_177952_p() + steps) {
                    BlockPos blockPos;
                    BlockPos blockPos5 = blockPos = type ? BackpackUtils.checkCoordsForPlayer(player, world, origX, origZ, pos, except) : BackpackUtils.checkCoordsForBackpack(player, world, origX, origZ, pos, except);
                    if (blockPos != null) {
                        return blockPos;
                    }
                    ++j;
                }
                pass = (byte)(pass - 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, origX, origZ, new BlockPos(i, pos.func_177956_o(), j), radius, except, ++steps, pass, type);
            }
        }
        return null;
    }

    private static BlockPos checkCoordsForBackpack(PlayerEntity player, World world, int origX, int origZ, BlockPos pos, boolean except) {
        if (except && world.func_217400_a(pos.func_177977_b(), (Entity)player) && world.func_175623_d(pos) && !BackpackUtils.areCoordinatesTheSame(new BlockPos(origX, pos.func_177956_o(), origZ), pos)) {
            return pos;
        }
        if (!except && world.func_217400_a(pos.func_177977_b(), (Entity)player) && world.func_175623_d(pos)) {
            return pos;
        }
        return null;
    }

    private static BlockPos checkCoordsForPlayer(PlayerEntity player, World world, int origX, int origZ, BlockPos pos, boolean except) {
        if (except && world.func_217400_a(pos.func_177977_b(), (Entity)player) && world.func_175623_d(pos) && world.func_175623_d(pos.func_177984_a()) && !BackpackUtils.areCoordinatesTheSame2D(origX, origZ, pos.func_177958_n(), pos.func_177952_p())) {
            return pos;
        }
        if (!except && world.func_217400_a(pos.func_177977_b(), (Entity)player) && world.func_175623_d(pos) && world.func_175623_d(pos.func_177984_a())) {
            return pos;
        }
        return null;
    }

    private static boolean areCoordinatesTheSame(BlockPos pos1, BlockPos pos2) {
        return pos1 == pos2;
    }

    private static boolean areCoordinatesTheSame2D(int X1, int Z1, int X2, int Z2) {
        return X1 == X2 && Z1 == Z2;
    }
}

