/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.tuple.Triple;

public class RenderUtils {
    private static final float OFFSET = 0.01f;
    private static final float MINY = 0.01f;
    private static final float MIN = 0.135f;
    private static final float MAX = 0.29000002f;
    private static final float[][][] coordinates = new float[][][]{new float[][]{{0.135f, 0.01f, 0.29000002f}, {0.135f, 0.01f, 0.135f}, {0.29000002f, 0.01f, 0.135f}, {0.29000002f, 0.01f, 0.29000002f}}, new float[][]{{0.29000002f, 0.29000002f, 0.29000002f}, {0.29000002f, 0.29000002f, 0.135f}, {0.135f, 0.29000002f, 0.135f}, {0.135f, 0.29000002f, 0.29000002f}}, new float[][]{{0.135f, 0.01f, 0.135f}, {0.135f, 0.29000002f, 0.135f}, {0.29000002f, 0.29000002f, 0.135f}, {0.29000002f, 0.01f, 0.135f}}, new float[][]{{0.29000002f, 0.01f, 0.29000002f}, {0.29000002f, 0.29000002f, 0.29000002f}, {0.135f, 0.29000002f, 0.29000002f}, {0.135f, 0.01f, 0.29000002f}}, new float[][]{{0.135f, 0.01f, 0.29000002f}, {0.135f, 0.29000002f, 0.29000002f}, {0.135f, 0.29000002f, 0.135f}, {0.135f, 0.01f, 0.135f}}, new float[][]{{0.29000002f, 0.01f, 0.135f}, {0.29000002f, 0.29000002f, 0.135f}, {0.29000002f, 0.29000002f, 0.29000002f}, {0.29000002f, 0.01f, 0.29000002f}}};

    public static void renderScreenTank(MatrixStack matrixStackIn, FluidTank tank, double x, double y, double height, double width) {
        RenderUtils.renderScreenTank(matrixStackIn, tank.getFluid(), tank.getCapacity(), tank.getFluidAmount(), x, y, height, width);
    }

    public static void renderScreenTank(MatrixStack matrixStackIn, FluidStack fluid, int capacity, int amount, double x, double y, double height, double width) {
        if (fluid == null || fluid.getFluid() == null || amount <= 0) {
            return;
        }
        TextureAtlasSprite icon = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluid.getFluid().getAttributes().getStillTexture());
        if (icon == null) {
            icon = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(MissingTextureSprite.func_195675_b());
        }
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)capacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        int color = fluid.getFluid() == ModFluids.POTION_FLUID.get() ? fluid.getFluid().getAttributes().getColor(fluid) : fluid.getFluid().getAttributes().getColor();
        matrixStackIn.func_227860_a_();
        RenderSystem.color4f((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
        RenderSystem.disableBlend();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                float minU = icon.func_94209_e();
                float minV = icon.func_94206_g();
                float maxU = icon.func_94212_f();
                float maxV = icon.func_94210_h();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder builder = tessellator.func_178180_c();
                builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                builder.func_225582_a_((double)drawX, (double)(drawY + drawHeight), 0.0).func_225583_a_(minU, minV + (maxV - minV) * (float)drawHeight / 16.0f).func_181675_d();
                builder.func_225582_a_((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).func_225583_a_(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV + (maxV - minV) * (float)drawHeight / 16.0f).func_181675_d();
                builder.func_225582_a_((double)(drawX + drawWidth), (double)drawY, 0.0).func_225583_a_(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV).func_181675_d();
                builder.func_225582_a_((double)drawX, (double)drawY, 0.0).func_225583_a_(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
            i += 16;
        }
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStackIn.func_227865_b_();
    }

    public static void renderFluidSides(ITravelersBackpackInventory inv, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float height, FluidStack fluid, int brightness) {
        Triple<Float, Float, Float> colorParts = RenderUtils.getFluidVertexBufferColor(fluid);
        float r = ((Float)colorParts.getLeft()).floatValue();
        float g = ((Float)colorParts.getMiddle()).floatValue();
        float b = ((Float)colorParts.getRight()).floatValue();
        float a = 1.0f;
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        for (Direction direction : Direction.values()) {
            TextureAtlasSprite icon = RenderUtils.getFluidIcon(inv, fluid, direction);
            IVertexBuilder renderer = bufferIn.getBuffer(RenderType.func_228658_l_((ResourceLocation)icon.func_229241_m_().func_229223_g_()));
            float[][] c = coordinates[direction.ordinal()];
            float replacedMaxV = direction == Direction.UP || direction == Direction.DOWN ? icon.func_94207_b(4.0) : (icon.func_94210_h() - icon.func_94206_g()) * height + icon.func_94206_g();
            float replacedU1 = direction == Direction.UP || direction == Direction.DOWN ? icon.func_94214_a(4.0) : icon.func_94214_a(7.0);
            float replacedU2 = direction == Direction.UP || direction == Direction.DOWN ? icon.func_94214_a(8.0) : icon.func_94214_a(8.0);
            renderer.func_227888_a_(matrix4f, c[0][0], RenderUtils.getHeight(c[0][1], height), c[0][2]).func_227885_a_(r, g, b, a).func_225583_a_(replacedU1, replacedMaxV).func_227886_a_(brightness).func_181675_d();
            renderer.func_227888_a_(matrix4f, c[1][0], RenderUtils.getHeight(c[1][1], height), c[1][2]).func_227885_a_(r, g, b, a).func_225583_a_(replacedU1, icon.func_94206_g()).func_227886_a_(brightness).func_181675_d();
            renderer.func_227888_a_(matrix4f, c[2][0], RenderUtils.getHeight(c[2][1], height), c[2][2]).func_227885_a_(r, g, b, a).func_225583_a_(replacedU2, icon.func_94206_g()).func_227886_a_(brightness).func_181675_d();
            renderer.func_227888_a_(matrix4f, c[3][0], RenderUtils.getHeight(c[3][1], height), c[3][2]).func_227885_a_(r, g, b, a).func_225583_a_(replacedU2, replacedMaxV).func_227886_a_(brightness).func_181675_d();
        }
    }

    private static float getHeight(float height, float replaceHeight) {
        if (height == 0.29000002f) {
            return replaceHeight;
        }
        return height;
    }

    public static void renderFluidInTank(ITravelersBackpackInventory inv, FluidTank tank, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, float x, float y, float z) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        if (!tank.isEmpty() && !tank.getFluid().isEmpty()) {
            matrixStackIn.func_227861_a_((double)x, (double)y, (double)z);
            float height = RenderUtils.getTankFillRatio(tank) * 0.99f;
            RenderUtils.renderFluidSides(inv, matrixStackIn, bufferIn, height, tank.getFluid(), combinedLightIn);
        }
        matrixStackIn.func_227865_b_();
    }

    public static TextureAtlasSprite getFluidIcon(ITravelersBackpackInventory inv, FluidStack fluidstack, Direction direction) {
        TextureAtlasSprite icon;
        Block defaultBlock;
        Block block = defaultBlock = Blocks.field_150355_j;
        if (fluidstack.getFluid().getAttributes().getBlock((IBlockDisplayReader)Minecraft.func_71410_x().field_71441_e, inv.getPosition(), fluidstack.getFluid().func_207188_f()) != null) {
            block = fluidstack.getFluid().getAttributes().getBlock((IBlockDisplayReader)Minecraft.func_71410_x().field_71441_e, inv.getPosition(), fluidstack.getFluid().func_207188_f()).func_177230_c();
        }
        if (direction == null) {
            direction = Direction.UP;
        }
        if ((icon = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidstack.getFluid().getAttributes().getFlowingTexture())) == null || direction == Direction.UP || direction == Direction.DOWN) {
            icon = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidstack.getFluid().getAttributes().getStillTexture());
        }
        if (icon == null && (icon = RenderUtils.getBlockIcon(block)) == null) {
            icon = RenderUtils.getBlockIcon(defaultBlock);
        }
        return icon;
    }

    public static TextureAtlasSprite getBlockIcon(Block block) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(block.func_176223_P());
    }

    public static float getTankFillRatio(FluidTank tank) {
        return Math.min(1.0f, (float)tank.getFluidAmount() / (float)tank.getCapacity()) * 0.5f;
    }

    public static Triple<Float, Float, Float> getFluidVertexBufferColor(FluidStack fluidStack) {
        int color = fluidStack.getFluid().getAttributes().getColor(fluidStack);
        return RenderUtils.intToRGB(color);
    }

    public static Triple<Float, Float, Float> intToRGB(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return Triple.of((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
    }
}

