/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.api.conditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.minecraftabnormals.abnormals_core.core.api.conditions.config.IConfigPredicate;
import com.minecraftabnormals.abnormals_core.core.api.conditions.config.IConfigPredicateSerializer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ConfigValueCondition
implements ICondition {
    private final ForgeConfigSpec.ConfigValue<?> value;
    private final String valueID;
    private final Map<IConfigPredicate, Boolean> predicates;
    private final boolean inverted;
    private final ResourceLocation location;

    public ConfigValueCondition(ResourceLocation location, ForgeConfigSpec.ConfigValue<?> value, String valueID, Map<IConfigPredicate, Boolean> predicates, boolean inverted) {
        this.location = location;
        this.value = value;
        this.valueID = valueID;
        this.predicates = predicates;
        this.inverted = inverted;
    }

    public ResourceLocation getID() {
        return this.location;
    }

    public boolean test() {
        boolean returnValue;
        if (this.predicates.size() > 0) {
            returnValue = this.predicates.keySet().stream().allMatch(c -> this.predicates.get(c).booleanValue() != c.test(this.value));
        } else if (this.value.get() instanceof Boolean) {
            returnValue = (Boolean)this.value.get();
        } else {
            throw new IllegalStateException("Predicates required for non-boolean ConfigLootCondition, but none found");
        }
        return this.inverted != returnValue;
    }

    public static class Serializer
    implements IConditionSerializer<ConfigValueCondition> {
        public static final Hashtable<ResourceLocation, IConfigPredicateSerializer<?>> CONFIG_PREDICATE_SERIALIZERS = new Hashtable();
        private final Map<String, ForgeConfigSpec.ConfigValue<?>> configValues;
        private final ResourceLocation location;

        public Serializer(String modId, Map<String, ForgeConfigSpec.ConfigValue<?>> configValues) {
            this.location = new ResourceLocation(modId, "config");
            this.configValues = configValues;
        }

        public void write(JsonObject json, ConfigValueCondition value) {
            json.addProperty("value", value.valueID);
            if (!value.predicates.isEmpty()) {
                JsonArray predicates = new JsonArray();
                json.add("predicates", (JsonElement)predicates);
                for (Map.Entry predicatePair : value.predicates.entrySet()) {
                    IConfigPredicate predicate = (IConfigPredicate)predicatePair.getKey();
                    ResourceLocation predicateID = predicate.getID();
                    JsonObject object = new JsonObject();
                    predicates.add((JsonElement)object);
                    object.addProperty("type", predicateID.toString());
                    CONFIG_PREDICATE_SERIALIZERS.get(predicateID).write(object, predicate);
                    object.addProperty("inverted", (Boolean)predicatePair.getValue());
                }
            }
            if (value.inverted) {
                json.addProperty("inverted", Boolean.valueOf(true));
            }
        }

        public ConfigValueCondition read(JsonObject json) {
            if (!json.has("value")) {
                throw new JsonSyntaxException("Missing 'value', expected to find a string");
            }
            String name = JSONUtils.func_151200_h((JsonObject)json, (String)"value");
            ForgeConfigSpec.ConfigValue<?> configValue = this.configValues.get(name);
            if (configValue == null) {
                throw new JsonSyntaxException("No config value of name '" + name + "' found");
            }
            HashMap<IConfigPredicate, Boolean> predicates = new HashMap<IConfigPredicate, Boolean>();
            if (JSONUtils.func_151204_g((JsonObject)json, (String)"predicates")) {
                for (JsonElement predicateElement : JSONUtils.func_151214_t((JsonObject)json, (String)"predicates")) {
                    if (!predicateElement.isJsonObject()) {
                        throw new JsonSyntaxException("Predicates must be an array of JsonObjects");
                    }
                    JsonObject predicateObject = predicateElement.getAsJsonObject();
                    ResourceLocation type = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)predicateObject, (String)"type"));
                    IConfigPredicateSerializer<?> serializer = CONFIG_PREDICATE_SERIALIZERS.get(type);
                    if (serializer == null) {
                        throw new JsonSyntaxException("Unknown predicate type: " + type.toString());
                    }
                    predicates.put((IConfigPredicate)serializer.read(predicateObject), predicateObject.has("inverted") && JSONUtils.func_151212_i((JsonObject)predicateObject, (String)"inverted"));
                }
            } else if (!(configValue.get() instanceof Boolean)) {
                throw new JsonSyntaxException("Missing 'predicates' for non-boolean config value '" + name + "', expected to find an array");
            }
            return new ConfigValueCondition(this.location, configValue, name, predicates, json.has("inverted") && JSONUtils.func_151212_i((JsonObject)json, (String)"inverted"));
        }

        public ResourceLocation getID() {
            return this.location;
        }
    }
}

